/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import nomadictents.block.TentBlock;
import nomadictents.tileentity.TentDoorBlockEntity;

public class TentDoorBlock
extends TentBlock
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = DoorBlock.f_52730_;
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61598_((String)"axis", Direction.Axis.class, (Enum[])new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z});
    protected static final VoxelShape AABB_X = TentDoorBlock.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_Z = TentDoorBlock.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final HashMap<BlockState, VoxelShape> SHAPES = new HashMap();

    public TentDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF}).m_61104_(new Property[]{AXIS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (!SHAPES.containsKey(state)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            if (axis == Direction.Axis.X) {
                SHAPES.put(state, AABB_X);
            } else {
                SHAPES.put(state, AABB_Z);
            }
        }
        return SHAPES.get(state);
    }

    public void m_6807_(BlockState stateIn, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (stateIn.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            level.m_7731_(pos.m_7494_(), (BlockState)stateIn.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            level.m_7471_(pos.m_7494_(), false);
        } else {
            level.m_7471_(pos.m_7495_(), false);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            BlockEntity blockEntity;
            BlockPos doorPos = pos;
            if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                doorPos = pos.m_7495_();
            }
            if ((blockEntity = level.m_7702_(doorPos)) instanceof TentDoorBlockEntity) {
                TentDoorBlockEntity tentDoor = (TentDoorBlockEntity)blockEntity;
                tentDoor.playerWillDestroy(level, doorPos, level.m_8055_(doorPos), player);
            }
        }
        super.m_5707_(level, pos, blockState, player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult raytraceResult) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos doorPos = pos;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            doorPos = pos.m_7495_();
        }
        if ((blockEntity = level.m_7702_(doorPos)) instanceof TentDoorBlockEntity) {
            TentDoorBlockEntity tentDoor = (TentDoorBlockEntity)blockEntity;
            return tentDoor.use(level.m_8055_(doorPos), level, doorPos, player, hand);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        BlockPos doorPos = pos;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            doorPos = pos.m_7495_();
        }
        if ((blockEntity = level.m_7702_(doorPos)) instanceof TentDoorBlockEntity) {
            TentDoorBlockEntity tentDoor = (TentDoorBlockEntity)blockEntity;
            tentDoor.entityInside(level.m_8055_(doorPos), level, doorPos, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return new TentDoorBlockEntity(pos, state);
        }
        return null;
    }
}

