/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.location.TerminalStorageLocations;

public abstract class TerminalStorageIngredientCraftingOptionDataPacketAbstract<T, M, L>
extends PacketCodec {
    @CodecField
    private String ingredientComponent;
    private ITerminalStorageLocation<L> location;
    private L locationInstance;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag craftingOption;
    @CodecField
    private int amount;
    @CodecField
    private CompoundTag craftingPlan;

    public TerminalStorageIngredientCraftingOptionDataPacketAbstract() {
    }

    public TerminalStorageIngredientCraftingOptionDataPacketAbstract(CraftingOptionGuiData<T, M, L> craftingOptionData) {
        this.ingredientComponent = craftingOptionData.getComponent().getName().toString();
        this.location = craftingOptionData.getLocation();
        this.locationInstance = craftingOptionData.getLocationInstance();
        this.tabName = craftingOptionData.getTabName();
        this.channel = craftingOptionData.getChannel();
        this.craftingOption = craftingOptionData.getCraftingOption() != null ? HandlerWrappedTerminalCraftingOption.serialize(craftingOptionData.getCraftingOption()) : new CompoundTag();
        this.amount = craftingOptionData.getAmount();
        this.craftingPlan = craftingOptionData.getCraftingPlan() != null ? HandlerWrappedTerminalCraftingPlan.serialize(craftingOptionData.getCraftingPlan()) : new CompoundTag();
    }

    public void encode(FriendlyByteBuf output) {
        super.encode(output);
        output.m_130085_(this.location.getName());
        this.location.writeToPacketBuffer(output, this.locationInstance);
    }

    public void decode(FriendlyByteBuf input) {
        super.decode(input);
        this.location = TerminalStorageLocations.REGISTRY.getLocation(input.m_130281_());
        this.locationInstance = this.location.readFromPacketBuffer(input);
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingOption<T> getCraftingOption(IngredientComponent<T, M> ingredientComponent) {
        try {
            return HandlerWrappedTerminalCraftingOption.deserialize(ingredientComponent, this.craftingOption);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getCraftingPlan() {
        try {
            return HandlerWrappedTerminalCraftingPlan.deserialize(this.craftingPlan);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(this.ingredientComponent));
        if (component == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + this.ingredientComponent);
        }
        return component;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getTabName() {
        return this.tabName;
    }

    public int getAmount() {
        return this.amount;
    }

    public CraftingOptionGuiData<T, M, L> getCraftingOptionData() {
        IngredientComponent<T, M> ingredientComponent = this.getIngredientComponent();
        return new CraftingOptionGuiData<T, M, L>(ingredientComponent, this.tabName, this.channel, this.getCraftingOption(ingredientComponent), this.amount, this.getCraftingPlan(), this.location, this.locationInstance);
    }
}

