/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.autothirdperson;

import agency.highlysuspect.autothirdperson.AtpOpts;
import agency.highlysuspect.autothirdperson.VersionCapabilities;
import agency.highlysuspect.autothirdperson.config.ConfigSchema;
import agency.highlysuspect.autothirdperson.config.CookedConfig;
import agency.highlysuspect.autothirdperson.config.StubConfig;
import agency.highlysuspect.autothirdperson.wrap.MyLogger;
import agency.highlysuspect.autothirdperson.wrap.Vehicle;
import org.jetbrains.annotations.Nullable;

public abstract class AutoThirdPerson {
    public static final String MODID = "auto_third_person";
    public static final String NAME = "Auto Third Person";
    public static AutoThirdPerson instance;
    public final MyLogger logger;
    public final VersionCapabilities version = this.caps(new VersionCapabilities.Builder()).build();
    public final AtpOpts opts = new AtpOpts(this.version);
    public CookedConfig config = new StubConfig();
    public final State state;
    public static final int FIRST_PERSON = 0;
    public static final int THIRD_PERSON = 1;
    public static final int THIRD_PERSON_REVERSED = 2;

    public AutoThirdPerson() {
        if (instance != null) {
            IllegalStateException e = new IllegalStateException("Auto Third Person instantiated twice!");
            e.printStackTrace();
            this.makeLogger().error("Auto Third Person instantiated twice!", e);
            throw e;
        }
        instance = this;
        this.logger = this.makeLogger();
        this.state = this.makeState();
    }

    public abstract VersionCapabilities.Builder caps(VersionCapabilities.Builder var1);

    public abstract MyLogger makeLogger();

    public State makeState() {
        return new State();
    }

    public abstract CookedConfig makeConfig(ConfigSchema var1);

    public abstract int getCameraType();

    public abstract void setCameraType(int var1);

    public int numberOfCameraTypes() {
        return 3;
    }

    public abstract boolean f3ScreenUp();

    public abstract boolean safeToTick();

    public abstract boolean playerIsElytraFlying();

    public abstract boolean playerInSwimmingAnimation();

    public abstract boolean playerIsUnderwater();

    public abstract boolean modEnableToggleKeyPressed();

    public abstract void sayEnabled(boolean var1);

    public void init() {
        this.logger.info("Auto Third Person initializing...", new Object[0]);
        this.config = this.makeConfig(this.opts.makeSchema());
        this.refreshConfig();
    }

    public void refreshConfig() {
        try {
            this.config.refresh();
        }
        catch (Exception e) {
            this.logger.error("Problem with Auto Third Person config load", e);
        }
    }

    public void debugSpam(String msg, Object ... args) {
        if (this.f3ScreenUp() || this.config.get(this.opts.LOG_SPAM).booleanValue()) {
            this.logger.info(msg, args);
        }
    }

    public void mount(Vehicle mounting) {
        if (!this.state.modEnabled) {
            return;
        }
        this.mountOrDismount(mounting, true);
    }

    public void dismount(Vehicle dismounting) {
        if (!this.state.modEnabled) {
            return;
        }
        this.mountOrDismount(dismounting, false);
    }

    public void manualPress() {
        if (!this.state.modEnabled) {
            return;
        }
        if (this.config.get(this.opts.CANCEL_AUTO_RESTORE).booleanValue() && this.state.isActive()) {
            this.debugSpam("Cancelling auto-restore, if it was about to happen", new Object[0]);
            this.state.cancel();
        }
    }

    public void renderClient() {
        int currentCameraType;
        boolean modEnableToggleKeyPressed = this.modEnableToggleKeyPressed();
        if (modEnableToggleKeyPressed && !this.state.modEnableToggleKeyWasPressed) {
            this.state.modEnabled ^= true;
            this.sayEnabled(this.state.modEnabled);
            this.debugSpam("Auto Third Person is now " + (this.state.modEnabled ? "ENABLED" : "DISABLED"), new Object[0]);
        }
        this.state.modEnableToggleKeyWasPressed = modEnableToggleKeyPressed;
        if (!this.safeToTick() || !this.state.modEnabled) {
            return;
        }
        if (this.config.get(this.opts.SKIP_FRONT_VIEW).booleanValue() && (currentCameraType = this.getCameraType()) == 2) {
            this.debugSpam("Skipping third-person reversed view", new Object[0]);
            this.setCameraType((currentCameraType + 1) % this.numberOfCameraTypes());
        }
    }

    public void tickClient() {
        boolean isSwimming;
        if (!this.state.modEnabled || !this.safeToTick()) {
            return;
        }
        boolean elytraEnabled = this.config.getOr(this.opts.ELYTRA, false);
        int elytraDelay = this.config.getOr(this.opts.ELYTRA_DELAY, 10);
        boolean swimEnabled = this.config.get(this.opts.SWIM);
        boolean isFlying = this.version.hasElytra && this.playerIsElytraFlying();
        boolean bl = isSwimming = this.version.hasSwimmingAnimation ? this.playerInSwimmingAnimation() : this.playerIsUnderwater();
        if (elytraEnabled && isFlying) {
            if (this.state.elytraFlyingTicks == elytraDelay) {
                this.enterThirdPerson(new FlyingReason());
            }
            ++this.state.elytraFlyingTicks;
        } else {
            if (this.state.elytraFlyingTicks != 0) {
                this.exitThirdPerson(new FlyingReason());
            }
            this.state.elytraFlyingTicks = 0;
        }
        if (!(!swimEnabled || elytraEnabled && isFlying && isSwimming)) {
            boolean stickySwim = this.config.getOr(this.opts.STICKY_SWIM, false);
            int swimmingDelayStart = this.config.get(this.opts.SWIMMING_DELAY_START);
            int swimmingDelayEnd = this.config.get(this.opts.SWIMMING_DELAY_END);
            if (this.state.wasSwimming && stickySwim) {
                isSwimming |= this.playerIsUnderwater();
            }
            if (this.state.wasSwimming != isSwimming) {
                this.state.swimTicks = 0;
                this.state.wasSwimming = isSwimming;
            }
            if (isSwimming && this.state.swimTicks == swimmingDelayStart) {
                this.enterThirdPerson(new SwimmingReason());
            }
            if (!isSwimming && this.state.swimTicks == swimmingDelayEnd) {
                this.exitThirdPerson(new SwimmingReason());
            }
            ++this.state.swimTicks;
        }
    }

    private void mountOrDismount(Vehicle vehicle, boolean mounting) {
        if (!this.safeToTick()) {
            return;
        }
        this.debugSpam((mounting ? "Mounting " : "Dismounting ") + vehicle.id(), new Object[0]);
        if (this.config.get(this.opts.USEIGNORE).booleanValue() && this.config.get(this.opts.IGNORE_PATTERN).matcher(vehicle.id()).matches()) {
            this.debugSpam("Ignoring, since it matches the ignore pattern '{}'.", this.config.get(this.opts.IGNORE_PATTERN));
            return;
        }
        boolean doIt = false;
        if (this.config.get(this.opts.BOAT).booleanValue() && vehicle.classification() == Vehicle.Classification.BOAT) {
            this.debugSpam("This is a boat!", new Object[0]);
            doIt = true;
        }
        if (this.config.get(this.opts.CART).booleanValue() && vehicle.classification() == Vehicle.Classification.MINECART) {
            this.debugSpam("This is a minecart!", new Object[0]);
            doIt = true;
        }
        if (this.config.get(this.opts.ANIMAL).booleanValue() && vehicle.classification() == Vehicle.Classification.ANIMAL) {
            this.debugSpam("This is an animal!", new Object[0]);
            doIt = true;
        }
        if (this.config.get(this.opts.CUSTOM).booleanValue() && this.config.get(this.opts.CUSTOM_PATTERN).matcher(vehicle.id()).matches()) {
            this.debugSpam("This matches the pattern '{}'!", this.config.get(this.opts.CUSTOM_PATTERN));
            doIt = true;
        }
        if (doIt) {
            if (mounting) {
                this.enterThirdPerson(new MountingReason(vehicle));
            } else {
                this.exitThirdPerson(new MountingReason(vehicle));
            }
        }
    }

    private void enterThirdPerson(Reason reason) {
        if (this.state.reason == null && this.getCameraType() == 0) {
            this.state.oldPerspective = this.getCameraType();
            this.state.reason = reason;
            this.setCameraType(1);
            this.debugSpam("Automatically entering third person due to {}", reason);
        } else if (this.state.isActive()) {
            this.state.reason = reason;
            this.debugSpam("Continuing third person into {}", reason);
        }
    }

    private void exitThirdPerson(Reason reason) {
        if (!this.config.get(this.opts.AUTO_RESTORE).booleanValue()) {
            this.debugSpam("Not automatically leaving third person due to {} ending - auto restore is turned off", reason);
            return;
        }
        if (!this.state.isActive()) {
            this.debugSpam("Not automatically leaving third person due to {} ending - cancelled or inactive", reason);
            return;
        }
        if (!reason.equals(this.state.reason)) {
            this.debugSpam("Not automatically leaving third person due to {} ending - current state is {}", reason, this.state.reason);
            return;
        }
        this.debugSpam("Automatically leaving third person due to {} ending", reason);
        this.setCameraType(this.state.oldPerspective);
        this.state.cancel();
    }

    public static class State {
        public boolean modEnabled = true;
        public boolean modEnableToggleKeyWasPressed = false;
        public int oldPerspective = 0;
        @Nullable
        public Reason reason;
        public int elytraFlyingTicks = 0;
        public boolean wasSwimming = false;
        public int swimTicks = 0;

        public boolean isActive() {
            return this.reason != null;
        }

        public void cancel() {
            this.reason = null;
        }

        public void reset() {
            this.oldPerspective = 0;
            this.reason = null;
            this.swimTicks = 0;
            this.elytraFlyingTicks = 0;
            this.wasSwimming = false;
        }
    }

    public static final class FlyingReason
    implements Reason {
        public String toString() {
            return "flying";
        }

        public boolean equals(Object other) {
            return other instanceof FlyingReason;
        }
    }

    public static interface Reason {
    }

    public static final class SwimmingReason
    implements Reason {
        public String toString() {
            return "swimming";
        }

        public boolean equals(Object other) {
            return other instanceof SwimmingReason;
        }
    }

    public static final class MountingReason
    implements Reason {
        private final Vehicle vehicle;

        public MountingReason(Vehicle vehicle) {
            this.vehicle = vehicle;
        }

        public boolean equals(Object other) {
            return other instanceof MountingReason && ((MountingReason)other).vehicle.vehicleEquals(this.vehicle);
        }

        public String toString() {
            return "riding " + this.vehicle.id();
        }
    }
}

