/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GSoundEvents;

public class SaltboundTabletItem
extends Item {
    public SaltboundTabletItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 18;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_5496_((SoundEvent)GSoundEvents.SALTBOUND_TABLET_PREPARE_ATTACK.get(), 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        return this.performAttack(stack, level, user);
    }

    public ItemStack performAttack(ItemStack stack, Level level, LivingEntity user) {
        if (user instanceof Player) {
            int cooldown;
            Player player = (Player)user;
            InteractionHand hand = player.m_7655_();
            player.m_6674_(hand);
            player.m_5496_((SoundEvent)GSoundEvents.SALTBOUND_TABLET_CAST_ATTACK.get(), 1.0f, 1.0f);
            Vec3 lookAngle = player.m_20154_();
            Vec3 adjustedAngle = lookAngle.m_82520_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            double d = Math.min(adjustedAngle.m_7098_(), player.m_20186_());
            double e = Math.max(adjustedAngle.m_7098_(), player.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(adjustedAngle.m_7094_() - player.m_20189_()), (double)(adjustedAngle.m_7096_() - player.m_20185_()));
            int n = cooldown = player.m_150110_().f_35937_ ? 10 : 60;
            if (lookAngle.m_82507_(Direction.Axis.Y) <= -0.8) {
                for (int round = 2; round < 5; ++round) {
                    for (float index = 0.0f; index < (float)Math.PI * 2; index += 0.7853982f) {
                        this.createPillar(player, stack, (int)(index * 2.0f), 8.0f, 0.0f, player.m_20185_() + (double)(Mth.m_14031_((float)index) * (float)round), player.m_20189_() + (double)(Mth.m_14089_((float)index) * (float)round), d, e, f);
                        player.m_36335_().m_41524_((Item)this, cooldown);
                    }
                }
            } else {
                for (int index = 0; index < 16; ++index) {
                    double h = 1.25 * (double)(index + 1);
                    this.createPillar(player, stack, index, 12.0f, 0.4f, adjustedAngle.m_7096_() + (double)Mth.m_14089_((float)f) * h + (double)((player.m_217043_().m_188501_() - 0.5f) * 0.4f), adjustedAngle.m_7094_() + (double)Mth.m_14031_((float)f) * h + (double)((player.m_217043_().m_188501_() - 0.5f) * 0.4f), d, e, f);
                    player.m_36335_().m_41524_((Item)this, cooldown);
                }
            }
            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
        }
        return stack;
    }

    private void createPillar(Player player, ItemStack stack, int index, float damage, float damageLowerRate, double d, double e, double f, double g, float h) {
        BlockPos pos = BlockPos.m_274561_((double)d, (double)g, (double)e);
        Level level = player.m_9236_();
        boolean bl = false;
        double j = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos pos2;
            BlockState state;
            if (!(state = level.m_8055_(pos2 = pos.m_7495_())).m_60783_((BlockGetter)level, pos2, Direction.UP)) continue;
            if (!level.m_46859_(pos) && !(voxelShape = level.m_8055_(pos).m_60812_((BlockGetter)level, pos)).m_83281_()) {
                j = voxelShape.m_83297_(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)f) - 7);
        if (bl) {
            if (damageLowerRate > 0.0f) {
                damage -= (float)index * damageLowerRate;
            }
            level.m_7967_((Entity)new PinkSaltPillar(level, d, (double)pos.m_123342_() + j, e, h, index, damage, (LivingEntity)player, stack));
        }
    }
}

