/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.registry;

import com.teamabnormals.blueprint.core.util.PropertyUtil;
import com.uraneptus.sullysmod.common.items.ArtifactHelmetItem;
import com.uraneptus.sullysmod.common.items.ArtifactWeaponItem;
import com.uraneptus.sullysmod.common.items.DeathWhistleItem;
import com.uraneptus.sullysmod.common.items.JadeShieldItem;
import com.uraneptus.sullysmod.common.items.JadeSmithingTemplateItem;
import com.uraneptus.sullysmod.common.items.MinersHelmetItem;
import com.uraneptus.sullysmod.common.items.SMRecordItem;
import com.uraneptus.sullysmod.common.items.ThrowingKnifeItem;
import com.uraneptus.sullysmod.common.items.TortoiseShellItem;
import com.uraneptus.sullysmod.common.items.VenomVialItem;
import com.uraneptus.sullysmod.common.items.VialItem;
import com.uraneptus.sullysmod.core.other.SMArmorMaterials;
import com.uraneptus.sullysmod.core.other.SMProperties;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import com.uraneptus.sullysmod.core.other.SMTextUtil;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMFluids;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SMItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"sullysmod");
    public static List<RegistryObject<? extends Item>> AUTO_TRANSLATE = new ArrayList<RegistryObject<? extends Item>>();
    public static final Rarity ANCIENT = Rarity.create((String)"sullysmod:ancient", style -> style.m_178520_(15107584));
    public static final RegistryObject<Item> ROUGH_JADE = SMItems.createItem("rough_jade");
    public static final RegistryObject<Item> JADE = SMItems.createItem("jade");
    public static final RegistryObject<Item> MUSIC_DISC_SCOUR = SMItems.createItem("music_disc_scour", () -> new SMRecordItem(12, (Supplier<SoundEvent>)SMSounds.MUSIC_DISC_SCOUR, SMProperties.Items.MUSIC_DISCS, 4980), true);
    public static final RegistryObject<Item> MUSIC_DISC_SUNKEN_PAST = SMItems.createItem("music_disc_sunken_past", () -> new SMRecordItem(12, (Supplier<SoundEvent>)SMSounds.MUSIC_DISC_SUNKEN_PAST, SMProperties.Items.MUSIC_DISCS, 2700), true);
    public static final RegistryObject<Item> TORTOISE_SCUTE = SMItems.createItem("tortoise_scute");
    public static final RegistryObject<Item> TORTOISE_SHELL = SMItems.createItem("tortoise_shell", () -> new TortoiseShellItem(PropertyUtil.stacksOnce()));
    public static final RegistryObject<Item> JADE_UPGRADE_SMITHING_TEMPLATE = SMItems.createItem("jade_upgrade_smithing_template", JadeSmithingTemplateItem::new, true);
    public static final RegistryObject<Item> GLASS_VIAL = SMItems.createItem("glass_vial", () -> new VialItem(new Item.Properties()));
    public static final RegistryObject<Item> VENOM_VIAL = SMItems.createItem("venom_vial", () -> new VenomVialItem(new Item.Properties().m_41487_(16)), true);
    public static final RegistryObject<Item> JADE_HORSE_ARMOR = SMItems.createItem("jade_horse_armor", () -> new HorseArmorItem(9, "jade", PropertyUtil.stacksOnce()));
    public static final RegistryObject<Item> PIRANHA_TOOTH = SMItems.createItem("piranha_tooth");
    public static final RegistryObject<Item> JADE_SHIELD = SMItems.createItem("jade_shield", () -> new JadeShieldItem(-2.0f, SMProperties.Items.JADE_SHIELD));
    public static final RegistryObject<Item> THROWING_KNIFE = SMItems.createItem("throwing_knife", () -> new ThrowingKnifeItem(SMProperties.Items.sixteenStack()));
    public static final RegistryObject<Item> LANTERNFISH = SMItems.createItem("lanternfish", PropertyUtil.food((FoodProperties)SMProperties.Foods.LANTERNFISH_FOOD), true);
    public static final RegistryObject<Item> COOKED_LANTERNFISH = SMItems.createItem("cooked_lanternfish", PropertyUtil.food((FoodProperties)SMProperties.Foods.COOKED_LANTERNFISH_FOOD));
    public static final RegistryObject<Item> PIRANHA = SMItems.createItem("piranha", PropertyUtil.food((FoodProperties)SMProperties.Foods.PIRANHA_FOOD), true);
    public static final RegistryObject<Item> COOKED_PIRANHA = SMItems.createItem("cooked_piranha", PropertyUtil.food((FoodProperties)SMProperties.Foods.COOKED_PIRANHA_FOOD));
    public static final RegistryObject<Item> MOLTEN_AMBER_BUCKET = SMItems.createItem("molten_amber_bucket", () -> new BucketItem(SMFluids.SOURCE_MOLTEN_AMBER, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> LANTERNFISH_BUCKET = SMItems.createMobBucketItem("lanternfish_bucket", () -> SMEntityTypes.LANTERNFISH.get());
    public static final RegistryObject<Item> LANTERNFISH_SPAWN_EGG = SMItems.createSpawnEggItem("lanternfish", () -> SMEntityTypes.LANTERNFISH.get(), 16573395, 9306085);
    public static final RegistryObject<Item> TORTOISE_SPAWN_EGG = SMItems.createSpawnEggItem("tortoise", () -> SMEntityTypes.TORTOISE.get(), 0xE7E7E7, 10844478);
    public static final RegistryObject<Item> BOULDERING_ZOMBIE_SPAWN_EGG = SMItems.createSpawnEggItem("bouldering_zombie", () -> SMEntityTypes.BOULDERING_ZOMBIE.get(), 8142370, 4608338);
    public static final RegistryObject<Item> JUNGLE_SPIDER_SPAWN_EGG = SMItems.createSpawnEggItem("jungle_spider", () -> SMEntityTypes.JUNGLE_SPIDER.get(), 5597514, 11013646);
    public static final RegistryObject<Item> PIRANHA_BUCKET = SMItems.createMobBucketItem("piranha_bucket", () -> SMEntityTypes.PIRANHA.get());
    public static final RegistryObject<Item> PIRANHA_SPAWN_EGG = SMItems.createSpawnEggItem("piranha", () -> SMEntityTypes.PIRANHA.get(), 15561472, 4240022);
    public static Map<RegistryObject<Item>, Component> ARTIFACT_DESC_MAP = new HashMap<RegistryObject<Item>, Component>();
    public static Map<Supplier<Item>, Integer> TRADES = new HashMap<Supplier<Item>, Integer>();
    public static final RegistryObject<Item> BROKEN_VASE = SMItems.registerArtifact("broken_vase", "A large piece of the side is missing", 10);
    public static final RegistryObject<Item> PRIMITIVE_KNIFE = SMItems.registerArtifact("primitive_knife", "A small knife made from obsidian", () -> new ArtifactWeaponItem(5, -2.5f, null, SMProperties.Items.artifacts().m_41487_(1).m_41503_(20)), 15);
    public static final RegistryObject<Item> MINERS_HELMET = SMItems.registerArtifact("miners_helmet", "Looks like it\u2019s previous owner couldn\u2019t get the candle lit anymore", () -> new MinersHelmetItem(SMProperties.Items.artifacts().m_41487_(1)), 15);
    public static final RegistryObject<Item> SMALL_DENTED_HELMET = SMItems.registerArtifact("small_dented_helmet", "A small rusty helmet. Barely fits", () -> new ArtifactHelmetItem((ArmorMaterial)SMArmorMaterials.SMALL_DENTED_HELMET, SMProperties.Items.artifacts().m_41487_(1)), 22);
    public static final RegistryObject<Item> LOST_CROWN = SMItems.registerArtifact("lost_crown", "Once belonged to the king of a now fallen kingdom", () -> new ArtifactHelmetItem((ArmorMaterial)SMArmorMaterials.LOST_CROWN, SMProperties.Items.artifacts().m_41487_(1)), 30);
    public static final RegistryObject<Item> JADE_AMULET = SMItems.registerArtifact("jade_amulet", "A creature is carefully sculpted from the stone", 20);
    public static final RegistryObject<Item> PRIMITIVE_RING = SMItems.registerArtifact("primitive_ring", "A roughly made metal ring", 10);
    public static final RegistryObject<Item> RUSTY_TOOLS = SMItems.registerArtifact("rusty_tools", "Maybe their owners are still out there", 9);
    public static final RegistryObject<Item> BROKEN_BOWL = SMItems.registerArtifact("broken_bowl", "A large crack runs down the edge", 9);
    public static final RegistryObject<Item> COPPER_COG = SMItems.registerArtifact("copper_cog", "Said to have been part of living creatures", 23);
    public static final RegistryObject<Item> PETRIFIED_COOKIE = SMItems.registerArtifact("petrified_cookie", "Petrified food is still food, just extra crisp", () -> new Item(SMProperties.Items.artifacts().m_41489_(SMProperties.Foods.PETRIFIED_COOKIE)), 12);
    public static final RegistryObject<Item> ARROWHEAD = SMItems.registerArtifact("arrowhead", "The tip of an ancient arrow", 5);
    public static final RegistryObject<Item> DEATH_WHISTLE = SMItems.registerArtifact("death_whistle", "Screeches horrible noises when blown into", DeathWhistleItem::new, 20);
    public static final RegistryObject<Item> OMINOUS_TABLET = SMItems.registerArtifact("ominous_tablet", "A dark figure is carved into the stone", 25);
    public static final RegistryObject<Item> MOON_TABLET = SMItems.registerArtifact("moon_tablet", "Has a carved image of the moon", 27);
    public static final RegistryObject<Item> STONE_IDOL = SMItems.registerArtifact("stone_idol", "Almost looks alive", 20);
    public static final RegistryObject<Item> RED_CAP = SMItems.registerArtifact("red_cap", "A tiny red cap. It\u2019s too small to wear and the fabric feels strange", 20);
    public static final RegistryObject<Item> DRIED_CYAN_FLOWER = SMItems.registerArtifact("dried_cyan_flower", "A delicate cyan flower that feels strangely familiar", 21);
    public static final RegistryObject<Item> DRIED_RED_FLOWER = SMItems.registerArtifact("dried_red_flower", "A delicate red flower that feels like home", 22);
    public static final RegistryObject<Item> METALLIC_SKULL = SMItems.registerArtifact("metallic_skull", "The a metallic skull attached to broken off bars", 25);
    public static final RegistryObject<Item> LOST_BAG = SMItems.registerArtifact("lost_bag", "A small lightweight bag sloppily sewn together", 14);
    public static final RegistryObject<Item> MYSTERIOUS_PLATE = SMItems.registerArtifact("mysterious_plate", "Made from an unknown material", 35);
    public static final RegistryObject<Item> FAMILIAR_CUBE = SMItems.registerArtifact("familiar_cube", "Hot to the touch and has strange growths on it", 30);
    public static final RegistryObject<Item> AMBER_ENCASED_BUG = SMItems.registerArtifact("amber_encased_bug", "A small bug that was covered by tree sap ages ago", 20);
    public static final RegistryObject<Item> FOSSILISED_SHELLS = SMItems.registerArtifact("fossilised_shells", "Shells from a sea creature that lived long ago", 27);
    public static final RegistryObject<Item> FOSSILISED_BONE = SMItems.registerArtifact("fossilised_bone", "A large bone of an extinct creature", 27);
    public static final RegistryObject<Item> FOSSILISED_FOOTSTEP = SMItems.registerArtifact("fossilised_footstep", "An ancient footprint that never faded", 25);
    public static final RegistryObject<Item> FOSSILISED_FISH = SMItems.registerArtifact("fossilised_fish", "The bones of a small fish from times past", 27);
    public static final RegistryObject<Item> TORN_MANUSCRIPT = SMItems.registerArtifact("torn_manuscript", "Part of a manuscript with an unknown language", 18);
    public static final RegistryObject<Item> LOST_JOURNAL = SMItems.registerArtifact("lost_journal", "Waterlogged and left unreadable, it has a few pages ripped out", 17);
    public static final RegistryObject<Item> LOST_SKETCHBOOK = SMItems.registerArtifact("lost_sketchbook", "A small book with scratchy drawings of an unknown large mouthed biped", 24);
    public static final RegistryObject<Item> LOST_RECIPE_BOOK = SMItems.registerArtifact("lost_recipe_book", "Mostly ruined and unreadable, but still has some recipes inside.", 12);
    public static final RegistryObject<Item> GOLDEN_BELT_BUCKLE = SMItems.registerArtifact("golden_belt_buckle", "Has a peculiar shape and it\u2019s leather feels strange", 26);
    public static final RegistryObject<Item> DEEPSLATE_VASE = SMItems.registerArtifact("deepslate_vase", "Who would\u2019ve needed a vase made from deepslate?", 25);
    public static final RegistryObject<Item> SMALL_GEODE = SMItems.registerArtifact("small_geode", "Kind of cute", 23);
    public static final RegistryObject<Item> TORN_CLOTH = SMItems.registerArtifact("torn_cloth", "A dirty torn off piece of clothing", 6);
    public static final RegistryObject<Item> GOLDEN_GOBLET = SMItems.registerArtifact("golden_goblet", "An old but beautiful chalice made by a skilled goldsmith", 29);
    public static final RegistryObject<Item> EMERALD_EARRING = SMItems.registerArtifact("emerald_earring", "Besides the beautiful emerald, it looks sloppily put together", 17);
    public static final RegistryObject<Item> BROKEN_BOTTLE = SMItems.registerArtifact("broken_bottle", "The top half of a bottle", () -> new ArtifactWeaponItem(4, -1.2f, (Supplier<SoundEvent>)SMSounds.BROKEN_BOTTLE_SHATTERS, SMProperties.Items.artifacts().m_41487_(1).m_41503_(1)), 5);
    public static final RegistryObject<Item> FROG_IDOL = SMItems.registerArtifact("frog_idol", "Everybody likes frogs", 29);

    private static RegistryObject<Item> registerArtifact(String name, String description, int price) {
        return SMItems.registerArtifact(name, description, () -> new Item(SMProperties.Items.artifacts()), price);
    }

    private static RegistryObject<Item> registerArtifact(String name, String description, Supplier<? extends Item> item, int price) {
        RegistryObject<? extends Item> object = SMItems.createItem(name, item, true);
        ARTIFACT_DESC_MAP.put(object, (Component)SMTextUtil.addSMTranslatable("artifact." + name + ".desc", description).m_130948_(SMTextDefinitions.ARTIFACT_DESC_STYLE));
        TRADES.put((Supplier<Item>)object, price);
        return object;
    }

    private static RegistryObject<Item> createSpawnEggItem(String name, Supplier<EntityType<? extends Mob>> supplier, int primaryColor, int secondaryColor) {
        return SMItems.createItem(name + "_spawn_egg", () -> new ForgeSpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties()));
    }

    private static RegistryObject<Item> createMobBucketItem(String name, Supplier<EntityType<? extends WaterAnimal>> entityType) {
        return SMItems.createItem(name, () -> new MobBucketItem(entityType, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, SMProperties.Items.singleStack()), true);
    }

    private static RegistryObject<Item> createItem(String name, boolean customTranslation) {
        return SMItems.createItem(name, new Item.Properties(), customTranslation);
    }

    private static RegistryObject<Item> createItem(String name) {
        return SMItems.createItem(name, new Item.Properties());
    }

    private static RegistryObject<Item> createItem(String name, Item.Properties properties, boolean customTranslation) {
        return SMItems.createItem(name, () -> new Item(properties), customTranslation);
    }

    private static RegistryObject<Item> createItem(String name, Item.Properties properties) {
        return SMItems.createItem(name, () -> new Item(properties));
    }

    private static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier, boolean customTranslation) {
        RegistryObject<? extends I> item = SMItems.createItem(name, supplier);
        if (customTranslation) {
            AUTO_TRANSLATE.remove(item);
        }
        return item;
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        RegistryObject item = ITEMS.register(name, supplier);
        AUTO_TRANSLATE.add((RegistryObject<? extends Item>)item);
        return item;
    }
}

