/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.sign.BlueprintCeilingHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import com.uraneptus.sullysmod.common.blocks.AmberBlock;
import com.uraneptus.sullysmod.common.blocks.AmberLayeredCauldronBlock;
import com.uraneptus.sullysmod.common.blocks.AmberRotatedPillarBlock;
import com.uraneptus.sullysmod.common.blocks.AmberSlabBlock;
import com.uraneptus.sullysmod.common.blocks.AmberStairBlock;
import com.uraneptus.sullysmod.common.blocks.AmberWallBlock;
import com.uraneptus.sullysmod.common.blocks.AncientSkullBlock;
import com.uraneptus.sullysmod.common.blocks.AncientWallSkullBlock;
import com.uraneptus.sullysmod.common.blocks.CopperButtonBlock;
import com.uraneptus.sullysmod.common.blocks.FlingerTotem;
import com.uraneptus.sullysmod.common.blocks.ItemStandBlock;
import com.uraneptus.sullysmod.common.blocks.PetrifiedLog;
import com.uraneptus.sullysmod.common.blocks.PetrifiedSapling;
import com.uraneptus.sullysmod.common.blocks.SolidAmberBlock;
import com.uraneptus.sullysmod.common.blocks.TortoiseEggBlock;
import com.uraneptus.sullysmod.common.blocks.WeatheringCopperButtonBlock;
import com.uraneptus.sullysmod.common.blocks.utilities.SMDirectionalBlock;
import com.uraneptus.sullysmod.core.other.SMProperties;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import com.uraneptus.sullysmod.core.other.SMTextUtil;
import com.uraneptus.sullysmod.core.registry.SMBlocksetTypes;
import com.uraneptus.sullysmod.core.registry.SMFluids;
import com.uraneptus.sullysmod.core.registry.SMItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SMBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sullysmod");
    public static List<RegistryObject<? extends Block>> AUTO_TRANSLATE = new ArrayList<RegistryObject<? extends Block>>();
    public static final RegistryObject<Block> JADE_ORE = SMBlocks.createBlock("jade_ore", () -> new DropExperienceBlock(SMProperties.Blocks.JADE_ORE));
    public static final RegistryObject<Block> DEEPSLATE_JADE_ORE = SMBlocks.createBlock("deepslate_jade_ore", () -> new DropExperienceBlock(SMProperties.Blocks.DEEPSLATE_JADE_ORE));
    public static final RegistryObject<Block> ROUGH_JADE_BLOCK = SMBlocks.createBlockNoLang("rough_jade_block", () -> new Block(SMProperties.Blocks.ROUGH_JADE_BLOCKS));
    public static final RegistryObject<Block> ROUGH_JADE_BRICKS = SMBlocks.createBlock("rough_jade_bricks", () -> new Block(SMProperties.Blocks.ROUGH_JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_BLOCK = SMBlocks.createBlockNoLang("jade_block", () -> new Block(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_BRICKS = SMBlocks.createBlock("jade_bricks", () -> new Block(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> CHISELED_JADE = SMBlocks.createBlock("chiseled_jade", () -> new Block(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_TOTEM = SMBlocks.createBlock("jade_totem", () -> new SMDirectionalBlock(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_FLINGER_TOTEM = SMBlocks.createBlock("jade_flinger_totem", () -> new FlingerTotem(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_PILLAR = SMBlocks.createBlock("jade_pillar", () -> new RotatedPillarBlock(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> ROUGH_JADE_BRICK_STAIRS = SMBlocks.createBlock("rough_jade_brick_stairs", () -> new StairBlock(() -> ((Block)ROUGH_JADE_BRICKS.get()).m_49966_(), SMProperties.Blocks.ROUGH_JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_BRICK_STAIRS = SMBlocks.createBlock("jade_brick_stairs", () -> new StairBlock(() -> ((Block)JADE_BRICKS.get()).m_49966_(), SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> ROUGH_JADE_BRICK_SLAB = SMBlocks.createBlock("rough_jade_brick_slab", () -> new SlabBlock(SMProperties.Blocks.ROUGH_JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_BRICK_SLAB = SMBlocks.createBlock("jade_brick_slab", () -> new SlabBlock(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> ROUGH_JADE_BRICK_WALL = SMBlocks.createBlock("rough_jade_brick_wall", () -> new WallBlock(SMProperties.Blocks.ROUGH_JADE_BLOCKS));
    public static final RegistryObject<Block> JADE_BRICK_WALL = SMBlocks.createBlock("jade_brick_wall", () -> new WallBlock(SMProperties.Blocks.JADE_BLOCKS));
    public static final RegistryObject<Block> COPPER_BUTTON = SMBlocks.createBlock("copper_button", () -> new WeatheringCopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 10, true, WeatheringCopper.WeatherState.UNAFFECTED));
    public static final RegistryObject<Block> EXPOSED_COPPER_BUTTON = SMBlocks.createBlock("exposed_copper_button", () -> new WeatheringCopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 20, true, WeatheringCopper.WeatherState.EXPOSED));
    public static final RegistryObject<Block> WEATHERED_COPPER_BUTTON = SMBlocks.createBlock("weathered_copper_button", () -> new WeatheringCopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 30, true, WeatheringCopper.WeatherState.WEATHERED));
    public static final RegistryObject<Block> OXIDIZED_COPPER_BUTTON = SMBlocks.createBlock("oxidized_copper_button", () -> new WeatheringCopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 40, true, WeatheringCopper.WeatherState.OXIDIZED));
    public static final RegistryObject<Block> WAXED_COPPER_BUTTON = SMBlocks.createBlock("waxed_copper_button", () -> new CopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 10, true));
    public static final RegistryObject<Block> WAXED_EXPOSED_COPPER_BUTTON = SMBlocks.createBlock("waxed_exposed_copper_button", () -> new CopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 20, true));
    public static final RegistryObject<Block> WAXED_WEATHERED_COPPER_BUTTON = SMBlocks.createBlock("waxed_weathered_copper_button", () -> new CopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 30, true));
    public static final RegistryObject<Block> WAXED_OXIDIZED_COPPER_BUTTON = SMBlocks.createBlock("waxed_oxidized_copper_button", () -> new CopperButtonBlock(SMProperties.Blocks.COPPER_BUTTONS, SMBlocksetTypes.COPPER_BLOCKSET.get(), 40, true));
    public static final RegistryObject<Block> AMBER = SMBlocks.createBlock("amber", () -> new AmberBlock(SMProperties.Blocks.AMBER));
    public static final RegistryObject<Block> AMBER_BRICKS = SMBlocks.createBlock("amber_bricks", () -> new SolidAmberBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<Block> AMBER_BRICK_STAIRS = SMBlocks.createBlock("amber_brick_stairs", () -> new AmberStairBlock(() -> ((Block)AMBER_BRICKS.get()).m_49966_(), SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<Block> AMBER_BRICK_SLAB = SMBlocks.createBlock("amber_brick_slab", () -> new AmberSlabBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<Block> AMBER_BRICK_WALL = SMBlocks.createBlock("amber_brick_wall", () -> new AmberWallBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<Block> ROUGH_AMBER = SMBlocks.createBlock("rough_amber", () -> new SolidAmberBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<Block> CHISELED_AMBER = SMBlocks.createBlock("chiseled_amber", () -> new SolidAmberBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<Block> AMBER_PILLAR = SMBlocks.createBlock("amber_pillar", () -> new AmberRotatedPillarBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS));
    public static final RegistryObject<LiquidBlock> MOLTEN_AMBER_BLOCK = SMBlocks.createBlockNoItem("molten_amber_block", () -> new LiquidBlock(SMFluids.SOURCE_MOLTEN_AMBER, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49991_).m_60956_(0.5f).m_60953_(blockState -> 0)));
    public static final RegistryObject<Block> AMBER_CAULDRON = SMBlocks.createBlockNoItem("amber_cauldron", () -> new AmberLayeredCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_)));
    public static final RegistryObject<Block> AMBER_LANTERN = SMBlocks.createBlock("amber_lantern", () -> new SolidAmberBlock(SMProperties.Blocks.AMBER_BUILDING_BLOCKS.m_60953_(state -> 15)));
    public static final RegistryObject<Block> JADE_LANTERN = SMBlocks.createBlock("jade_lantern", () -> new Block(SMProperties.Blocks.JADE_BLOCKS.m_60953_(state -> 15)));
    public static final RegistryObject<Block> DIAMOND_LANTERN = SMBlocks.createBlock("diamond_lantern", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60953_(state -> 15)));
    public static final RegistryObject<Block> EMERALD_LANTERN = SMBlocks.createBlock("emerald_lantern", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50268_).m_60953_(state -> 15)));
    public static final RegistryObject<Block> LAPIS_LANTERN = SMBlocks.createBlock("lapis_lantern", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50060_).m_60953_(state -> 15)));
    public static final RegistryObject<Block> AMETHYST_LANTERN = SMBlocks.createBlock("amethyst_lantern", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60953_(state -> 15)));
    public static final RegistryObject<Block> QUARTZ_LANTERN = SMBlocks.createBlock("quartz_lantern", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50333_).m_60953_(state -> 15)));
    public static final RegistryObject<Block> PETRIFIED_PLANKS = SMBlocks.createBlock("petrified_planks", () -> new Block(SMProperties.Blocks.petrified().m_60999_()));
    public static final RegistryObject<Block> STRIPPED_PETRIFIED_LOG = SMBlocks.createBlock("stripped_petrified_log", () -> SMBlocks.strippedLog(MapColor.f_283895_, MapColor.f_283895_));
    public static final RegistryObject<Block> PETRIFIED_LOG = SMBlocks.createBlock("petrified_log", () -> SMBlocks.log(STRIPPED_PETRIFIED_LOG, MapColor.f_283895_, MapColor.f_283748_));
    public static final RegistryObject<Block> STRIPPED_PETRIFIED_WOOD = SMBlocks.createBlock("stripped_petrified_wood", () -> new RotatedPillarBlock(SMProperties.Blocks.petrified().m_60999_().m_284180_(MapColor.f_283895_)));
    public static final RegistryObject<Block> PETRIFIED_WOOD = SMBlocks.createBlock("petrified_wood", () -> new PetrifiedLog((Supplier<Block>)STRIPPED_PETRIFIED_WOOD, SMProperties.Blocks.petrified().m_60999_().m_284180_(MapColor.f_283748_)));
    public static final Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> PETRIFIED_SIGN = SMBlocks.createSignBlock("petrified", SMBlocksetTypes.PETRIFIED_WOOD_TYPE.get(), SMProperties.Blocks.PETRIFIED_SIGNS);
    public static final Pair<RegistryObject<BlueprintCeilingHangingSignBlock>, RegistryObject<BlueprintWallHangingSignBlock>> PETRIFIED_HANGING_SIGN = SMBlocks.createHangingSignBlock("petrified", SMBlocksetTypes.PETRIFIED_WOOD_TYPE.get(), SMProperties.Blocks.PETRIFIED_SIGNS);
    public static final RegistryObject<Block> PETRIFIED_PRESSURE_PLATE = SMBlocks.createBlock("petrified_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, SMProperties.Blocks.PETRIFIED_PRESSURE_PLATE, SMBlocksetTypes.PETRIFIED_BLOCKSET.get()));
    public static final RegistryObject<Block> PETRIFIED_TRAPDOOR = SMBlocks.createBlock("petrified_trapdoor", () -> new TrapDoorBlock(SMProperties.Blocks.PETRIFIED_TRAPDOOR, SMBlocksetTypes.PETRIFIED_BLOCKSET.get()));
    public static final RegistryObject<Block> PETRIFIED_STAIRS = SMBlocks.createBlock("petrified_stairs", () -> new StairBlock(() -> ((Block)PETRIFIED_PLANKS.get()).m_49966_(), SMProperties.Blocks.petrified().m_60999_()));
    public static final RegistryObject<Block> PETRIFIED_SLAB = SMBlocks.createBlock("petrified_slab", () -> new SlabBlock(SMProperties.Blocks.petrified().m_60999_()));
    public static final RegistryObject<Block> PETRIFIED_BUTTON = SMBlocks.createBlock("petrified_button", () -> new ButtonBlock(SMProperties.Blocks.PETRIFIED_BUTTON, SMBlocksetTypes.PETRIFIED_BLOCKSET.get(), 20, false));
    public static final RegistryObject<Block> PETRIFIED_FENCE_GATE = SMBlocks.createBlock("petrified_fence_gate", () -> new FenceGateBlock(SMProperties.Blocks.petrified().m_60999_().m_280606_(), SMBlocksetTypes.PETRIFIED_WOOD_TYPE.get()));
    public static final RegistryObject<Block> PETRIFIED_FENCE = SMBlocks.createBlock("petrified_fence", () -> new FenceBlock(SMProperties.Blocks.petrified().m_60999_()));
    public static final RegistryObject<Block> PETRIFIED_DOOR = SMBlocks.createBlock("petrified_door", () -> new DoorBlock(SMProperties.Blocks.petrified().m_60999_().m_60955_().m_60978_(0.35f), SMBlocksetTypes.PETRIFIED_BLOCKSET.get()));
    public static final RegistryObject<Block> PETRIFIED_SAPLING = SMBlocks.createBlock("petrified_sapling", () -> new PetrifiedSapling(SMProperties.Blocks.PETRIFIED_SAPLING));
    public static final RegistryObject<Block> POTTED_PETRIFIED_SAPLING = SMBlocks.createBlockNoItem("potted_petrified_sapling", () -> new FlowerPotBlock(null, PETRIFIED_SAPLING, PropertyUtil.flowerPot((FeatureFlag[])new FeatureFlag[0])));
    public static final RegistryObject<Block> TORTOISE_EGG = SMBlocks.createBlock("tortoise_egg", () -> new TortoiseEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50578_)));
    public static final RegistryObject<Block> ITEM_STAND = SMBlocks.createBlock("item_stand", () -> new ItemStandBlock(SMProperties.Blocks.ITEM_STAND));
    public static List<Supplier<Block>> ANCIENT_SKULLS = new ArrayList<Supplier<Block>>();
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> CRACKED_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.CRACKED, "The head of a giant ancient creature, it has a noticeable amount of cracks", 43);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> CRESTED_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.CRESTED, "The large head of a now extinct animal, the beak seems more hollow than others", 40);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> FLATBILLED_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.FLATBILLED, "The head of an animal that went extinct long ago", 37);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> GIGANTIC_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.GIGANTIC, "The gigantic head of an ancient creature, it feels familiar", 43);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> HORNED_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.HORNED, "The head of an extinct creature with a broken off horn on its head", 36);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> LONG_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.LONG, "A long head from an extinct animals, it has a large overbite", 34);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> TINY_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.TINY, "The head of a small chicken sized critter that lived long ago", 30);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> WIDE_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.WIDE, "The head of an extinct animal with a strangely wide head and giant eye sockets", 37);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> RIBBED_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.RIBBED, "Has a small ribcage directly attached to the skull", 37);
    public static final Pair<RegistryObject<Block>, RegistryObject<Block>> UNICORN_ANCIENT_SKULL = SMBlocks.registerAncientSkull(AncientSkullBlock.Types.UNICORN, "A normal horse skull, but with a large horn protruding from it", 25);

    public static Pair<RegistryObject<Block>, RegistryObject<Block>> registerAncientSkull(AncientSkullBlock.Types type, String description, int price) {
        String typeName = SMTextUtil.convertSkullTypeToString(type);
        String skullName = typeName + "_ancient_skull";
        RegistryObject<Block> skull = SMBlocks.createBlockNoItemNoLang(skullName, () -> new AncientSkullBlock(type, SMProperties.Blocks.ancientSkulls()));
        RegistryObject<Block> wallSkull = SMBlocks.createBlockNoItemNoLang(typeName + "_ancient_wall_skull", () -> new AncientWallSkullBlock(type, SMProperties.Blocks.ancientSkulls().lootFrom((Supplier)skull)));
        ANCIENT_SKULLS.add((Supplier<Block>)skull);
        RegistryObject skullItem = SMItems.ITEMS.register(skullName, () -> new StandingAndWallBlockItem((Block)skull.get(), (Block)wallSkull.get(), SMProperties.Items.artifacts(), Direction.DOWN));
        SMItems.ARTIFACT_DESC_MAP.put((RegistryObject<Item>)skullItem, (Component)SMTextUtil.addSMTranslatable("artifact." + skullName + ".desc", description).m_130948_(SMTextDefinitions.ARTIFACT_DESC_STYLE));
        SMItems.TRADES.put((Supplier<Item>)skullItem, price);
        return Pair.of(skull, wallSkull);
    }

    private static PetrifiedLog log(Supplier<Block> strippedBlock, MapColor pTopMapColor, MapColor pSideMapColor) {
        return new PetrifiedLog(strippedBlock, SMProperties.Blocks.petrified().m_60999_().m_284495_(blockState -> blockState.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? pTopMapColor : pSideMapColor));
    }

    private static RotatedPillarBlock strippedLog(MapColor pTopMapColor, MapColor pSideMapColor) {
        return new RotatedPillarBlock(SMProperties.Blocks.petrified().m_60999_().m_284495_(blockState -> blockState.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? pTopMapColor : pSideMapColor));
    }

    public static Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> createSignBlock(String name, WoodType woodType, BlockBehaviour.Properties properties) {
        RegistryObject<BlueprintStandingSignBlock> standing = SMBlocks.createBlockNoItem(name + "_sign", () -> new BlueprintStandingSignBlock(properties, woodType));
        RegistryObject<BlueprintWallSignBlock> wall = SMBlocks.createBlockNoItemNoLang(name + "_wall_sign", () -> new BlueprintWallSignBlock(properties.lootFrom((Supplier)standing), woodType));
        SMItems.ITEMS.register(name + "_sign", () -> new SignItem(new Item.Properties(), (Block)standing.get(), (Block)wall.get()));
        return Pair.of(standing, wall);
    }

    public static Pair<RegistryObject<BlueprintCeilingHangingSignBlock>, RegistryObject<BlueprintWallHangingSignBlock>> createHangingSignBlock(String name, WoodType woodType, BlockBehaviour.Properties properties) {
        RegistryObject<BlueprintCeilingHangingSignBlock> ceiling = SMBlocks.createBlockNoItem(name + "_hanging_sign", () -> new BlueprintCeilingHangingSignBlock(properties, woodType));
        RegistryObject<BlueprintWallHangingSignBlock> wall = SMBlocks.createBlockNoItemNoLang(name + "_wall_hanging_sign", () -> new BlueprintWallHangingSignBlock(properties.lootFrom((Supplier)ceiling), woodType));
        SMItems.ITEMS.register(name + "_hanging_sign", () -> new HangingSignItem((Block)ceiling.get(), (Block)wall.get(), new Item.Properties()));
        return Pair.of(ceiling, wall);
    }

    private static <B extends Block> RegistryObject<B> createBlockNoItemNoLang(String name, Supplier<? extends B> supplier) {
        return BLOCKS.register(name, supplier);
    }

    private static <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        System.out.println(block.getId());
        AUTO_TRANSLATE.add((RegistryObject<? extends Block>)block);
        return block;
    }

    private static <B extends Block> RegistryObject<B> createBlockNoLang(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        SMItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    private static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        SMItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        AUTO_TRANSLATE.add((RegistryObject<? extends Block>)block);
        return block;
    }
}

