/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.other.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.uraneptus.sullysmod.core.SMFeatures;
import com.uraneptus.sullysmod.core.registry.SMLootItemConditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SMFeatureLootItemCondition
implements LootItemCondition {
    private final List<SMFeatures> condition;

    public SMFeatureLootItemCondition(List<SMFeatures> condition) {
        this.condition = condition;
    }

    public static LootItemCondition.Builder modFeatureCondition(List<SMFeatures> features) {
        return () -> new SMFeatureLootItemCondition(features);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)SMLootItemConditions.MOD_FEATURE_CONDITION_TYPE.get();
    }

    public boolean test(LootContext lootContext) {
        return this.condition.stream().allMatch(SMFeatures::isEnabled);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SMFeatureLootItemCondition> {
        public void serialize(JsonObject obj, SMFeatureLootItemCondition itemCondition, JsonSerializationContext context) {
            JsonArray values = new JsonArray();
            for (SMFeatures features : itemCondition.condition) {
                values.add(features.m_7912_());
            }
            obj.add("values", (JsonElement)values);
        }

        public SMFeatureLootItemCondition deserialize(JsonObject jsonObject, JsonDeserializationContext context) {
            ArrayList<SMFeatures> features = new ArrayList<SMFeatures>();
            for (JsonElement element : jsonObject.getAsJsonArray("values")) {
                SMFeatures feature = SMFeatures.byName(element.getAsString());
                features.add(feature);
            }
            return new SMFeatureLootItemCondition(features);
        }
    }
}

