/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.events;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.uraneptus.sullysmod.common.blocks.utilities.AmberUtil;
import com.uraneptus.sullysmod.common.blocks.utilities.PickaxeStrippable;
import com.uraneptus.sullysmod.common.recipes.GrindstonePolishingRecipe;
import com.uraneptus.sullysmod.core.SMConfig;
import com.uraneptus.sullysmod.core.SMFeatures;
import com.uraneptus.sullysmod.core.events.SMCommonForgeEvents;
import com.uraneptus.sullysmod.core.other.SMItemUtil;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import com.uraneptus.sullysmod.core.other.tags.SMBiomeTags;
import com.uraneptus.sullysmod.core.other.tags.SMItemTags;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(modid="sullysmod")
public class SMPlayerEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        RandomSource random = level.m_213780_();
        ItemStack itemInHand = player.m_21120_(hand);
        if (SMFeatures.isEnabled(SMFeatures.GRINDSTONE_POLISHING) && block instanceof GrindstoneBlock) {
            ArrayList<GrindstonePolishingRecipe> recipes = new ArrayList<GrindstonePolishingRecipe>(GrindstonePolishingRecipe.getRecipes(level));
            for (GrindstonePolishingRecipe polishingRecipe : recipes) {
                for (ItemStack ingredient : ((Ingredient)polishingRecipe.m_7527_().iterator().next()).m_43908_()) {
                    ItemStack result = polishingRecipe.result;
                    int resultCount = polishingRecipe.getResultCount();
                    int xpAmount = polishingRecipe.getExperience();
                    if (!itemInHand.m_150930_(ingredient.m_41720_())) continue;
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.FAIL);
                    ItemStack resultItem = result.m_41777_();
                    if (player.m_6144_()) {
                        int ingredientCount = itemInHand.m_41613_();
                        SMPlayerEvents.shrinkIngredientAddResults(player, itemInHand, resultItem, resultCount, ingredientCount);
                        if (xpAmount != 0) {
                            for (int i = 0; i <= ingredientCount; ++i) {
                                int dropXp = random.m_188503_(2);
                                if (dropXp >= 1) continue;
                                xpAmount += polishingRecipe.getExperience();
                            }
                            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), xpAmount));
                        }
                    } else {
                        int canDropXp;
                        resultItem.m_41764_(resultCount);
                        SMPlayerEvents.shrinkIngredientAddResults(player, itemInHand, resultItem, resultCount, 1);
                        if (xpAmount != 0 && (canDropXp = random.m_188503_(2)) < 1) {
                            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), xpAmount));
                        }
                    }
                    player.m_6674_(hand);
                    Direction face = event.getFace();
                    if (face != null) {
                        ParticleUtils.m_216318_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123797_, (IntProvider)UniformInt.m_146622_((int)1, (int)4), (Direction)face, () -> new Vec3(player.m_20154_().m_7096_() + Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5), 0.8, player.m_20154_().m_7094_() + Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5)), (double)0.55);
                        ParticleUtils.m_216318_((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemInHand), (IntProvider)UniformInt.m_146622_((int)1, (int)2), (Direction)face, () -> new Vec3(Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05), 0.0, Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05)), (double)0.55);
                    }
                    level.m_5594_(player, pos, (SoundEvent)SMSounds.POLISH_JADE.get(), SoundSource.BLOCKS, 0.5f, 0.0f);
                }
            }
        }
        if (block instanceof PickaxeStrippable) {
            PickaxeStrippable pickaxeStrippableBlock = (PickaxeStrippable)block;
            if (!(itemInHand.m_41720_() instanceof PickaxeItem)) {
                return;
            }
            level.m_7731_(pos, BlockUtil.transferAllBlockStates((BlockState)blockState, (BlockState)pickaxeStrippableBlock.getStrippedBlock().get().m_49966_()), 11);
            SMItemUtil.triggerItemUsedOnBlock(player, itemInHand, pos);
            SMItemUtil.damageItem(player, itemInHand, hand);
            level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.m_6674_(hand);
        }
        if (block instanceof CauldronBlock) {
            CauldronBlock cauldron = (CauldronBlock)block;
            if (itemInHand.m_150930_((Item)SMItems.MOLTEN_AMBER_BUCKET.get()) && SMFeatures.isEnabled(SMFeatures.AMBER)) {
                event.setCancellationResult(CauldronInteraction.m_175618_((Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)new ItemStack((ItemLike)SMItems.MOLTEN_AMBER_BUCKET.get()), (BlockState)((BlockState)((Block)SMBlocks.AMBER_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.f_11778_));
                event.setCanceled(true);
            }
        }
    }

    private static void shrinkIngredientAddResults(Player player, ItemStack itemInHand, ItemStack resultItem, int resultCount, int ingredientCount) {
        if (!player.m_150110_().f_35937_) {
            itemInHand.m_41774_(ingredientCount);
        }
        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount * ingredientCount))) {
            player.m_36176_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount * ingredientCount), false);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemInHand = event.getItemStack();
        Player player = event.getEntity();
        Level level = event.getLevel();
        if (itemInHand.m_150930_((Item)SMItems.LOST_RECIPE_BOOK.get()) && level.m_7654_() != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ArrayList<Recipe> unknownRecipes = new ArrayList<Recipe>();
            for (Recipe recipe : level.m_7654_().m_129894_().m_44051_()) {
                if (serverPlayer.m_8952_().m_12709_(recipe)) continue;
                unknownRecipes.add(recipe);
            }
            Recipe recipe = (Recipe)unknownRecipes.get(player.m_217043_().m_188503_(unknownRecipes.size()));
            serverPlayer.m_7281_(List.of(recipe));
            level.m_247517_(null, player.m_20183_(), SoundEvents.f_11713_, SoundSource.PLAYERS);
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(event.getHand(), ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        ItemStack itemstack = event.getItemStack();
        SMItems.ARTIFACT_DESC_MAP.forEach((item, desc) -> {
            if (itemstack.m_150930_((Item)item.get())) {
                event.getToolTip().add(desc);
            }
        });
        if ((itemstack.m_150930_((Item)SMItems.JADE_SHIELD.get()) || itemstack.m_204117_(SMItemTags.ARTIFACTS) && !itemstack.m_150930_((Item)SMItems.BROKEN_BOTTLE.get()) && !itemstack.m_150930_((Item)SMItems.PRIMITIVE_KNIFE.get())) && FMLEnvironment.production) {
            itemstack.m_41654_(ItemStack.TooltipPart.MODIFIERS);
        }
        if (player != null) {
            if (((Boolean)SMConfig.ENABLE_POLISHABLE_TOOLTIP.get()).booleanValue() && SMFeatures.isEnabled(SMFeatures.GRINDSTONE_POLISHING)) {
                ArrayList<GrindstonePolishingRecipe> recipes = new ArrayList<GrindstonePolishingRecipe>(GrindstonePolishingRecipe.getRecipes(player.m_9236_()));
                for (GrindstonePolishingRecipe polishingRecipe : recipes) {
                    for (ItemStack polishableItems : ((Ingredient)polishingRecipe.m_7527_().iterator().next()).m_43908_()) {
                        if (!itemstack.m_150930_(polishableItems.m_41720_())) continue;
                        event.getToolTip().add(SMTextDefinitions.POLISHABLE);
                    }
                }
            }
            if (itemstack.m_150930_((Item)SMItems.THROWING_KNIFE.get())) {
                event.getToolTip().add(CommonComponents.f_237098_);
                event.getToolTip().add(SMTextDefinitions.WHEN_THROWN_TOOLTIP);
                event.getToolTip().add(SMTextDefinitions.THROWING_KNIFE_DAMAGE);
                event.getToolTip().add(SMTextDefinitions.THROWING_KNIFE_AIR_DAMAGE);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        RandomSource random = player.m_217043_();
        if (((Boolean)SMConfig.ENABLE_MYSTERIOUS_EYES.get()).booleanValue()) {
            int chance;
            int randZ;
            int randX;
            int randY;
            if (level.m_220362_() == BuiltinDimensionTypes.f_223538_ && player.m_146904_() < -62) {
                randY = random.m_188503_(5);
                randX = random.m_188503_(20);
                randZ = random.m_188503_(20);
                chance = random.m_188503_(750);
                if (chance == 1) {
                    player.m_9236_().m_7106_((ParticleOptions)SMParticleTypes.BLOT_EYES.get(), (double)(player.m_146903_() + randX), (double)(player.m_146904_() - 3 - randY), (double)(player.m_146907_() + randZ), 0.0, 0.0, 0.0);
                }
            }
            if (level.m_220362_() == BuiltinDimensionTypes.f_223540_ && player.m_146904_() <= 60) {
                BlockPos blockPos;
                Block block;
                randY = random.m_188503_(5);
                randX = random.m_188503_(20);
                randZ = random.m_188503_(20);
                chance = random.m_188503_(1500);
                if (chance == 1 && ((block = level.m_8055_(blockPos = new BlockPos(player.m_146903_() + randX, player.m_146904_() - 3 - randY, player.m_146907_() + randZ)).m_60734_()) == Blocks.f_50016_ || block == Blocks.f_50626_)) {
                    player.m_9236_().m_7106_((ParticleOptions)SMParticleTypes.BLOT_EYES.get(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (((Boolean)SMConfig.ENABLE_MOUNTAIN_CALLS.get()).booleanValue() && level.m_204166_(new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_())).m_203656_(SMBiomeTags.SNOWY_MOUNTAINS) && player.m_146904_() > 100) {
            int randX = random.m_188503_(5);
            int randZ = random.m_188503_(5);
            int chance = random.m_188503_(25000);
            if (chance == 1) {
                if (player.m_6350_().m_122421_() == Direction.AxisDirection.POSITIVE) {
                    level.m_5594_(player, new BlockPos(player.m_146903_() - 5 - randX, player.m_146904_(), player.m_146907_() - 5 - randZ), (SoundEvent)SMSounds.MOUNTAIN_CALLS.get(), SoundSource.AMBIENT, 0.1f, 1.0f);
                } else if (player.m_6350_().m_122421_() == Direction.AxisDirection.NEGATIVE) {
                    level.m_5594_(player, new BlockPos(player.m_146903_() + 5 + randX, player.m_146904_(), player.m_146907_() + 5 + randZ), (SoundEvent)SMSounds.MOUNTAIN_CALLS.get(), SoundSource.AMBIENT, 0.1f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (SMCommonForgeEvents.SEND_BLOCK_REMOVAL_NOTIFY) {
                MutableComponent component = Component.m_237113_((String)"Important: Sully's Mod removed some jade blocks!\nTo not break things we replaced them with other jade blocks.").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                serverPlayer.m_213846_((Component)component);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        Level level = event.getEntity().m_9236_();
        BlockState state = event.getState();
        if (event.getPosition().isEmpty()) {
            return;
        }
        if (state.m_61138_((Property)AmberUtil.IS_MELTED)) {
            float breakSpeed = (Boolean)state.m_61143_((Property)AmberUtil.IS_MELTED) != false ? 2.0f : 6.0f;
            event.setNewSpeed(breakSpeed);
        }
    }
}

