/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core.events;

import com.uraneptus.sullysmod.common.blockentities.FlingerTotemBE;
import com.uraneptus.sullysmod.common.blocks.FlingerTotem;
import com.uraneptus.sullysmod.common.blocks.utilities.SMDirectionalBlock;
import com.uraneptus.sullysmod.common.entities.Piranha;
import com.uraneptus.sullysmod.common.entities.Tortoise;
import com.uraneptus.sullysmod.common.entities.goals.GenericMobAttackTortoiseEggGoal;
import com.uraneptus.sullysmod.common.particletypes.DirectionParticleOptions;
import com.uraneptus.sullysmod.core.SMConfig;
import com.uraneptus.sullysmod.core.SMFeatures;
import com.uraneptus.sullysmod.core.other.tags.SMBlockTags;
import com.uraneptus.sullysmod.core.other.tags.SMEntityTags;
import com.uraneptus.sullysmod.core.other.tags.SMItemTags;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SMEntityEvents {
    @SubscribeEvent
    public static void onProjectileHitsBlock(ProjectileImpactEvent event) {
        BlockState blockState;
        if (!SMFeatures.isEnabled(SMFeatures.JADE)) {
            return;
        }
        Projectile projectile = event.getProjectile();
        Level level = event.getEntity().m_9236_();
        HitResult hitResult = event.getRayTraceResult();
        Vec3 vec3 = projectile.m_20184_();
        float velocity = (float)vec3.m_82553_();
        if (!SMFeatures.isEnabled(SMFeatures.JADE)) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                FlingerTotemBE blockEntity;
                BlockEntity blockEntity2;
                BlockPos pos = blockHitResult.m_82425_();
                blockState = level.m_8055_(pos);
                Direction direction = blockHitResult.m_82434_();
                if (!blockState.m_204336_(SMBlockTags.PROJECTILES_BOUNCE_ON)) {
                    return;
                }
                if (SMEntityEvents.isFlingerAndFlings(projectile, blockState, direction) && (blockEntity2 = level.m_7702_(pos)) instanceof FlingerTotemBE && !(blockEntity = (FlingerTotemBE)blockEntity2).isFull()) {
                    blockEntity.addProjectile(projectile);
                } else if (!projectile.m_6095_().m_204039_(SMEntityTags.CANNOT_BOUNCE)) {
                    if ((projectile = SMEntityEvents.replaceProjectile(projectile, level)) == null) {
                        return;
                    }
                    switch (direction.m_122434_()) {
                        case X: {
                            projectile.m_6686_(vec3.m_82548_().f_82479_, vec3.f_82480_, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                            break;
                        }
                        case Y: {
                            projectile.m_6686_(vec3.f_82479_, vec3.m_82548_().f_82480_, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                            break;
                        }
                        case Z: {
                            projectile.m_6686_(vec3.f_82479_, vec3.f_82480_, vec3.m_82548_().f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                        }
                    }
                    level.m_7967_((Entity)projectile);
                    SMEntityEvents.handleParticleAndSound(level, (HitResult)blockHitResult, direction, projectile);
                }
                SMEntityEvents.handleCancellation(event);
            }
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (!projectile.m_6095_().m_204039_(SMEntityTags.CANNOT_BOUNCE)) {
                Horse horse;
                Entity direction;
                Player player;
                blockState = entityHitResult.m_82443_();
                if (blockState instanceof Player && (player = (Player)blockState).m_21254_() && player.m_21211_().m_150930_((Item)SMItems.JADE_SHIELD.get())) {
                    SMEntityEvents.handleCancellation(event);
                    direction = projectile.m_6350_();
                    Vec3 angle = player.m_20154_();
                    projectile = SMEntityEvents.replaceProjectile(projectile, level);
                    if (projectile == null) {
                        return;
                    }
                    projectile.m_6686_(angle.f_82479_, angle.f_82480_, angle.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                    level.m_7967_((Entity)projectile);
                    player.m_21211_().m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
                    SMEntityEvents.handleParticleAndSound(level, (HitResult)entityHitResult, (Direction)direction, projectile);
                }
                if ((direction = entityHitResult.m_82443_()) instanceof Horse && (horse = (Horse)direction).m_30722_().m_150930_((Item)SMItems.JADE_HORSE_ARMOR.get())) {
                    direction = projectile.m_6350_();
                    SMEntityEvents.handleCancellation(event);
                    projectile = SMEntityEvents.replaceProjectile(projectile, level);
                    if (projectile == null) {
                        return;
                    }
                    if (projectile.f_19855_ < horse.m_20191_().f_82292_) {
                        switch (direction.m_122434_()) {
                            case X: {
                                projectile.m_6686_(vec3.m_82548_().f_82479_, vec3.f_82480_, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                                break;
                            }
                            case Y: {
                                projectile.m_6686_(vec3.f_82479_, vec3.m_82548_().f_82480_ + 1.0, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                                break;
                            }
                            case Z: {
                                projectile.m_6686_(vec3.f_82479_, vec3.f_82480_, vec3.m_82548_().f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                            }
                        }
                        if (direction == Direction.SOUTH || direction == Direction.NORTH) {
                            direction = direction.m_122424_();
                        }
                        SMEntityEvents.handleParticleAndSound(level, (HitResult)entityHitResult, (Direction)direction, projectile);
                    } else {
                        projectile.m_6034_(projectile.m_20185_(), projectile.m_20186_() + 0.25, projectile.m_20189_());
                        RandomSource random = level.m_213780_();
                        switch (direction.m_122434_()) {
                            case X: {
                                projectile.m_6686_(vec3.m_82548_().m_272010_((RandomSource)random, (float)8.0f).f_82479_, vec3.f_82480_, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                                break;
                            }
                            case Y: {
                                projectile.m_6686_(vec3.f_82479_, vec3.m_82548_().f_82480_ + 1.0, vec3.f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                                break;
                            }
                            case Z: {
                                projectile.m_6686_(vec3.f_82479_, vec3.f_82480_, vec3.m_82548_().m_272010_((RandomSource)random, (float)8.0f).f_82481_, SMEntityEvents.calculateBounceVelocity(velocity), 0.0f);
                            }
                        }
                        SMEntityEvents.handleParticleAndSound(level, (HitResult)entityHitResult, Direction.UP, projectile);
                    }
                    level.m_7967_((Entity)projectile);
                }
            }
        }
    }

    @Nullable
    public static Projectile replaceProjectile(Projectile projectile, Level level) {
        Projectile oldProjectile = projectile;
        if ((projectile = (Projectile)projectile.m_6095_().m_20615_(level)) == null) {
            return null;
        }
        oldProjectile.m_142467_(Entity.RemovalReason.DISCARDED);
        CompoundTag compoundtag = oldProjectile.m_20240_(new CompoundTag());
        compoundtag.m_128473_("Motion");
        projectile.m_20258_(compoundtag);
        return projectile;
    }

    private static float calculateBounceVelocity(float velocity) {
        return (Boolean)SMConfig.ENABLE_DYNAMIC_VELOCITY.get() != false && velocity * 0.8f >= 0.5f ? velocity * 0.8f : 0.5f;
    }

    public static boolean isFlingerAndFlings(Projectile projectile, BlockState blockState, Direction direction) {
        return !projectile.m_6095_().m_204039_(SMEntityTags.CANNOT_BE_FLUNG) && blockState.m_60734_() instanceof FlingerTotem && !direction.equals((Object)blockState.m_61143_((Property)SMDirectionalBlock.f_54117_));
    }

    private static void handleParticleAndSound(Level level, HitResult hitResult, Direction direction, Projectile projectile) {
        Vec3 particlePos = Vec3.f_82478_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            particlePos = new Vec3(blockHitResult.m_82450_().f_82479_, blockHitResult.m_82450_().f_82480_, blockHitResult.m_82450_().f_82481_).m_231075_(direction, 0.1);
        } else if (hitResult instanceof EntityHitResult) {
            particlePos = new Vec3(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_()).m_231075_(direction, 0.1);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new DirectionParticleOptions((ParticleType<DirectionParticleOptions>)((ParticleType)SMParticleTypes.RICOCHET.get()), direction), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)SMSounds.JADE_RICOCHET.get(), SoundSource.BLOCKS, 1.0f, 0.0f);
        projectile.m_146850_(GameEvent.f_157778_);
    }

    private static void handleCancellation(ProjectileImpactEvent event) {
        DefaultArtifactVersion FORGE_VERSION = new DefaultArtifactVersion(FMLLoader.versionInfo().forgeVersion());
        if (new DefaultArtifactVersion("47.1.4").compareTo((ArtifactVersion)FORGE_VERSION) < 0) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.STOP_AT_CURRENT_NO_DAMAGE);
        } else {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_().m_204039_(SMEntityTags.ATTACKS_BABY_TORTOISES) && entity instanceof Mob) {
            TamableAnimal tamable;
            Mob mob = (Mob)entity;
            if (mob instanceof Ocelot) {
                Ocelot ocelot = (Ocelot)mob;
                ocelot.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Tortoise.class, 10, false, false, Turtle.f_30122_));
            } else if (mob instanceof TamableAnimal && !(tamable = (TamableAnimal)mob).m_21824_()) {
                tamable.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal(tamable, Tortoise.class, false, Turtle.f_30122_));
            } else {
                mob.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal(mob, Tortoise.class, 10, true, false, Turtle.f_30122_));
            }
        }
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.f_21345_.m_25352_(4, (Goal)new GenericMobAttackTortoiseEggGoal((PathfinderMob)zombie, 1.0, 3));
        }
    }

    @SubscribeEvent
    public static void onLivingDropEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Entity killer = event.getSource().m_7639_();
        if (livingEntity instanceof Player) {
            return;
        }
        if (killer instanceof Piranha || ((Boolean)SMConfig.ENABLE_WOLF_CARNIVORE.get()).booleanValue() && killer instanceof Wolf) {
            event.getDrops().removeIf(itemEntity -> itemEntity.m_32055_().m_204117_(SMItemTags.CARNIVORE_CONSUMABLES));
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        Zombie zombie;
        LivingEntity livingEntity = event.getEntity();
        Entity killer = event.getSource().m_7639_();
        Level level = event.getEntity().m_9236_();
        if (!SMFeatures.isEnabled(SMFeatures.PIRANHA)) {
            return;
        }
        if (!(livingEntity instanceof Zombie) || (zombie = (Zombie)livingEntity).m_6162_() || !(killer instanceof Piranha)) {
            return;
        }
        CompoundTag compoundtag = livingEntity.m_20240_(new CompoundTag());
        compoundtag.m_128473_("Health");
        livingEntity.m_142467_(Entity.RemovalReason.DISCARDED);
        livingEntity = (LivingEntity)EntityType.f_20524_.m_20615_(level);
        if (livingEntity != null) {
            livingEntity.m_20258_(compoundtag);
            level.m_7967_((Entity)livingEntity);
        }
    }

    @SubscribeEvent
    public static void onGetVisibilityPercent(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        if (lookingEntity.m_6095_() == EntityType.f_20524_ && event.getEntity().m_6844_(EquipmentSlot.HEAD).m_204117_(SMItemTags.ANCIENT_SKULLS)) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
    }
}

