/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.core;

import com.uraneptus.sullysmod.core.SMConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum SMFeatures implements StringRepresentable
{
    JADE,
    PETRIFIED_WOOD,
    AMBER,
    TORTOISE,
    LANTERNFISH,
    PIRANHA,
    BOULDERING_ZOMBIE,
    JUNGLE_SPIDER,
    ITEM_STAND,
    ARTIFACTS,
    UNLUCK_POTION,
    RESISTANCE_POTION,
    COPPER_BUTTONS,
    GEM_LANTERNS,
    GRINDSTONE_POLISHING;

    public static final StringRepresentable.EnumCodec<SMFeatures> CODEC;
    private static final Map<String, SMFeatures> BY_NAME;

    public static boolean isEnabled(SMFeatures feature) {
        return switch (feature) {
            default -> throw new IncompatibleClassChangeError();
            case JADE -> (Boolean)SMConfig.ENABLE_JADE.get();
            case PETRIFIED_WOOD -> (Boolean)SMConfig.ENABLE_PETRIFIED_WOOD.get();
            case AMBER -> (Boolean)SMConfig.ENABLE_AMBER.get();
            case TORTOISE -> (Boolean)SMConfig.ENABLE_TORTOISE.get();
            case LANTERNFISH -> (Boolean)SMConfig.ENABLE_LANTERNFISH.get();
            case PIRANHA -> (Boolean)SMConfig.ENABLE_PIRANHA.get();
            case BOULDERING_ZOMBIE -> (Boolean)SMConfig.ENABLE_BOULDERING_ZOMBIE.get();
            case JUNGLE_SPIDER -> (Boolean)SMConfig.ENABLE_JUNGLE_SPIDER.get();
            case ITEM_STAND -> (Boolean)SMConfig.ENABLE_ITEM_STAND.get();
            case ARTIFACTS -> (Boolean)SMConfig.ENABLE_ARTIFACTS.get();
            case UNLUCK_POTION -> (Boolean)SMConfig.ENABLE_UNLUCK_POTION.get();
            case RESISTANCE_POTION -> (Boolean)SMConfig.ENABLE_RESISTANCE_POTION.get();
            case COPPER_BUTTONS -> (Boolean)SMConfig.ENABLE_COPPER_BUTTONS.get();
            case GEM_LANTERNS -> (Boolean)SMConfig.ENABLE_GEM_LANTERNS.get();
            case GRINDSTONE_POLISHING -> (Boolean)SMConfig.ENABLE_GRINDSTONE_POLISHING.get();
        };
    }

    public static boolean isEnabled(String name) {
        return SMFeatures.isEnabled(SMFeatures.valueOf(name));
    }

    public static SMFeatures byName(String name) {
        return BY_NAME.get(name);
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.m_216439_(SMFeatures::values);
        BY_NAME = Arrays.stream(SMFeatures.values()).collect(Collectors.toMap(SMFeatures::m_7912_, mobCategory -> mobCategory));
    }
}

