/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.uraneptus.sullysmod.core.registry.SMRecipeSerializer;
import com.uraneptus.sullysmod.core.registry.SMRecipeTypes;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrindstonePolishingRecipe
implements Recipe<Container> {
    public static final String NAME = "grindstone_polishing";
    private final ResourceLocation id;
    private final String recipeGroup;
    private final NonNullList<Ingredient> ingredients;
    public final ItemStack result;
    private final int experience;

    public GrindstonePolishingRecipe(ResourceLocation id, String recipeGroup, NonNullList<Ingredient> pIngredients, ItemStack result, int experience) {
        this.id = id;
        this.recipeGroup = recipeGroup;
        this.ingredients = pIngredients;
        this.result = result;
        this.experience = experience;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getResultCount() {
        return this.result.m_41613_();
    }

    public boolean m_5598_() {
        return true;
    }

    public String m_6076_() {
        return this.recipeGroup;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)SMRecipeTypes.GRINDSTONE_POLISHING.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SMRecipeSerializer.GRINDSTONE_POLISHING_SERIALIZER.get();
    }

    public static List<GrindstonePolishingRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44013_((RecipeType)SMRecipeTypes.GRINDSTONE_POLISHING.get());
    }

    public static class Serializer
    implements RecipeSerializer<GrindstonePolishingRecipe> {
        public GrindstonePolishingRecipe fromJson(ResourceLocation pRecipeId, JsonObject jsonObject) {
            ItemStack result;
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for polishing recipe");
            }
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (jsonObject.get("result").isJsonObject()) {
                result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            } else {
                String resultItem = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(resultItem);
                result = new ItemStack((Holder)ForgeRegistries.ITEMS.getDelegate(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + resultItem + " does not exist")));
            }
            int experience = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"experience", (int)0);
            return new GrindstonePolishingRecipe(pRecipeId, group, nonnulllist, result, experience);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            int ingredientSize = pIngredientArray.size();
            for (int i = 0; i < ingredientSize; ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public GrindstonePolishingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            int i = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < i; ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack result = pBuffer.m_130267_();
            int experience = pBuffer.readInt();
            return new GrindstonePolishingRecipe(pRecipeId, group, (NonNullList<Ingredient>)nonnulllist, result, experience);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, GrindstonePolishingRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.recipeGroup);
            pBuffer.m_130130_(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.writeInt(pRecipe.experience);
        }
    }
}

