/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.levelgen;

import com.mojang.serialization.Codec;
import com.uraneptus.sullysmod.common.levelgen.PetrifiedTreeVariant;
import com.uraneptus.sullysmod.common.levelgen.configs.PetrifiedTreeConfig;
import com.uraneptus.sullysmod.core.other.loot.SMBuiltInLootTables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class PetrifiedTreeFeature
extends Feature<PetrifiedTreeConfig> {
    public PetrifiedTreeFeature(Codec<PetrifiedTreeConfig> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<PetrifiedTreeConfig> context) {
        PetrifiedTreeConfig config = (PetrifiedTreeConfig)context.m_159778_();
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        BlockPos.MutableBlockPos blockPos = origin.m_122032_();
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        int amount = config.variants().size();
        PetrifiedTreeVariant variant = config.variants().get(amount <= 1 ? 0 : random.m_188503_(amount - 1));
        ResourceLocation structure = variant.name();
        StructureTemplateManager templateManager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate template = templateManager.m_230359_(structure);
        ChunkPos chunkPos = new ChunkPos((BlockPos)blockPos);
        BoundingBox boundingbox = new BoundingBox(chunkPos.m_45604_() - 16, level.m_141937_(), chunkPos.m_45605_() - 16, chunkPos.m_45608_() + 16, level.m_151558_(), chunkPos.m_45609_() + 16);
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74381_(boundingbox).m_230324_(random).m_74379_(rotation).m_74383_((StructureProcessor)PetrifiedTreeFeature.randomGravelProcessor(SMBuiltInLootTables.GRAVEL_BIG_PETRIFIED_TREE, variant.susGravelLimit())).m_74383_((StructureProcessor)PetrifiedTreeFeature.setLoottableProcessor(SMBuiltInLootTables.GRAVEL_BIG_PETRIFIED_TREE));
        Vec3i size = template.m_163801_();
        BlockPos centerPos = blockPos.m_7918_(-size.m_123341_() / 2, -5, -size.m_123343_() / 2);
        BlockPos offsetPos = template.m_74583_(centerPos.m_175288_(blockPos.m_123342_()), Mirror.NONE, Rotation.NONE);
        return PetrifiedTreeFeature.place(context, template, level, offsetPos, placeSettings, random, variant, config);
    }

    private static boolean place(FeaturePlaceContext<PetrifiedTreeConfig> context, StructureTemplate template, WorldGenLevel level, BlockPos offsetPos, StructurePlaceSettings placeSettings, RandomSource random, PetrifiedTreeVariant variant, PetrifiedTreeConfig config) {
        if (template.m_230328_((ServerLevelAccessor)level, new BlockPos(offsetPos.m_123341_(), offsetPos.m_123342_() - 2, offsetPos.m_123343_()), offsetPos, placeSettings, random, 3) && variant.allowAmber()) {
            int radius = 2;
            int tries = 2;
            for (int i = 0; i < tries; ++i) {
                BlockPos amberPos = offsetPos.m_7918_(random.m_188503_(4) * radius - radius, 0, random.m_188503_(4) * radius - radius);
                ((PlacedFeature)config.amberBlobs().get()).m_226357_(level, context.m_159775_(), random, amberPos);
            }
            return true;
        }
        return false;
    }

    private static CappedProcessor randomGravelProcessor(ResourceLocation lootTable, int limit) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_49994_), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, Blocks.f_276445_.m_49966_(), (RuleBlockEntityModifier)new AppendLoot(lootTable)))), (IntProvider)ConstantInt.m_146483_((int)limit));
    }

    private static RuleProcessor setLoottableProcessor(ResourceLocation lootTable) {
        return new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_276445_), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, Blocks.f_276445_.m_49966_(), (RuleBlockEntityModifier)new AppendLoot(lootTable))));
    }
}

