/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.client.sound.FollowJukeboxEntitySoundInstance;
import com.uraneptus.sullysmod.core.other.SMItemUtil;
import com.uraneptus.sullysmod.core.other.tags.SMItemTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public interface WorkstationAttachable {
    public ItemStack getAppliedWorkstation();

    public void setAppliedWorkstation(ItemStack var1);

    public boolean hasAppliedWorkstation();

    default public boolean isCraftingTable() {
        return this.getAppliedWorkstation().m_204117_(SMItemTags.CRAFTING_TABLES);
    }

    default public boolean isJukebox() {
        return this.getAppliedWorkstation().m_204117_(SMItemTags.JUKEBOXES);
    }

    public ItemStack getRecordItem();

    public void setRecordItem(ItemStack var1);

    public long getRecordTickCount();

    public void setRecordTickCount(long var1);

    public long getRecordStartedTick();

    public void setRecordStartedTick(long var1);

    public boolean isRecordPlaying();

    public void setRecordPlaying(boolean var1);

    public int getTicksSinceLastEvent();

    public void setTicksSinceLastEvent(int var1);

    default public void addSaveData(@NotNull CompoundTag nbt) {
        nbt.m_128365_("AppliedWorkstation", (Tag)this.getAppliedWorkstation().m_41739_(new CompoundTag()));
        nbt.m_128365_("RecordItem", (Tag)this.getRecordItem().m_41739_(new CompoundTag()));
        nbt.m_128379_("IsPlaying", this.isRecordPlaying());
        nbt.m_128356_("RecordStartTick", this.getRecordStartedTick());
        nbt.m_128356_("TickCount", this.getRecordTickCount());
    }

    default public void readSaveData(@NotNull CompoundTag nbt) {
        this.setAppliedWorkstation(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("AppliedWorkstation")));
        this.setRecordItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("RecordItem")));
        this.setRecordPlaying(nbt.m_128471_("IsPlaying"));
        this.setRecordStartedTick(nbt.m_128454_("RecordStartTick"));
        this.setRecordTickCount(nbt.m_128454_("TickCount"));
    }

    public InteractionResult customInteraction(Player var1, @NotNull InteractionHand var2);

    default public InteractionResult workstationInteraction(Player pPlayer, @NotNull InteractionHand pHand, Entity entity) {
        boolean flag = false;
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (this.hasAppliedWorkstation()) {
            if (pPlayer.m_6144_()) {
                if (itemInHand.m_204117_(ItemTags.f_271207_)) {
                    if (this.isJukebox() && !this.getRecordItem().m_41619_() && !entity.m_9236_().m_5776_()) {
                        pPlayer.m_36356_(this.getRecordItem());
                        this.setRecordItem(ItemStack.f_41583_);
                        this.setRecordPlaying(false);
                        this.setRecordTickCount(0L);
                        this.setTicksSinceLastEvent(0);
                    }
                    SMItemUtil.nonCreativeAddItems(pPlayer, new ItemStack((ItemLike)this.getAppliedWorkstation().m_41720_()));
                    this.setAppliedWorkstation(ItemStack.f_41583_);
                    entity.m_6210_();
                    return InteractionResult.m_19078_((boolean)entity.m_9236_().m_5776_());
                }
                flag = true;
            } else {
                if (this.isCraftingTable()) {
                    if (!entity.m_9236_().m_5776_()) {
                        this.openCraftingMenu((ServerPlayer)pPlayer, entity);
                        pPlayer.m_36220_(Stats.f_12967_);
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.isJukebox()) {
                    if (itemInHand.m_41619_()) {
                        if (!this.getRecordItem().m_41619_()) {
                            if (!entity.m_9236_().m_5776_()) {
                                pPlayer.m_36356_(this.getRecordItem());
                                this.setRecordItem(ItemStack.f_41583_);
                                this.setRecordPlaying(false);
                                this.setRecordTickCount(0L);
                                this.setTicksSinceLastEvent(0);
                            }
                            return InteractionResult.m_19078_((boolean)entity.m_9236_().m_5776_());
                        }
                    } else {
                        Item item = itemInHand.m_41720_();
                        if (item instanceof RecordItem) {
                            RecordItem recordItem = (RecordItem)item;
                            if (this.getRecordItem().m_41619_()) {
                                this.setRecordItem(recordItem.m_7968_());
                                SMItemUtil.nonCreativeShrinkStack(pPlayer, itemInHand);
                                this.setRecordStartedTick(this.getRecordTickCount());
                                this.setRecordPlaying(true);
                                if (entity.m_9236_().m_5776_()) {
                                    this.startRecordPlaying(entity, recordItem);
                                }
                                return InteractionResult.m_19078_((boolean)entity.m_9236_().m_5776_());
                            }
                        }
                    }
                    return InteractionResult.m_19078_((boolean)entity.m_9236_().m_5776_());
                }
            }
        } else {
            if (itemInHand.m_204117_(SMItemTags.CRAFTING_TABLES) || itemInHand.m_204117_(SMItemTags.JUKEBOXES)) {
                this.setAppliedWorkstation(itemInHand.m_41777_());
                entity.m_6210_();
                if (!pPlayer.m_7500_()) {
                    itemInHand.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)entity.m_9236_().m_5776_());
                }
                return InteractionResult.SUCCESS;
            }
            flag = true;
        }
        if (flag) {
            return this.customInteraction(pPlayer, pHand);
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void startRecordPlaying(Entity entity, RecordItem recordItem) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91106_().m_120372_((TickableSoundInstance)new FollowJukeboxEntitySoundInstance(entity, recordItem.m_43051_()));
        mc.f_91065_.m_93055_((Component)recordItem.m_43050_());
    }

    default public void openCraftingMenu(ServerPlayer player, Entity entity) {
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inventory, mPlayer) -> new CraftingMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)entity.m_9236_(), (BlockPos)entity.m_20183_())){

            public boolean m_6875_(Player pPlayer) {
                return true;
            }
        }, (Component)entity.m_7755_().m_6881_().m_130946_(" Crafting")));
    }

    default public void handleJukeboxTick(Entity entity, Level level) {
        Item item;
        if (!this.isJukebox()) {
            return;
        }
        BlockPos pos = entity.m_20183_();
        this.setTicksSinceLastEvent(1 + this.getTicksSinceLastEvent());
        if (!this.getRecordItem().m_41619_() && this.isRecordPlaying() && (item = this.getRecordItem().m_41720_()) instanceof RecordItem) {
            RecordItem recorditem = (RecordItem)item;
            if (this.getRecordTickCount() >= this.getRecordStartedTick() + (long)recorditem.m_43036_() + 20L) {
                this.setRecordPlaying(false);
                level.m_220407_(GameEvent.f_238649_, pos, GameEvent.Context.m_223717_((Entity)entity));
                level.m_46796_(1011, pos, 0);
            } else if (this.getTicksSinceLastEvent() >= 20) {
                this.setTicksSinceLastEvent(0);
                level.m_220407_(GameEvent.f_238690_, pos, GameEvent.Context.m_223717_((Entity)entity));
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    Vec3 vec3 = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, (double)1.2f, 0.0);
                    float xOffset = (float)level.m_213780_().m_188503_(4) / 24.0f;
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, (double)xOffset, 0.0, 0.0, 1.0);
                }
            }
        }
        this.setRecordTickCount(1L + this.getRecordTickCount());
    }

    default public void handleServerRemoval(Entity entity) {
        if (this.hasAppliedWorkstation()) {
            entity.m_19983_(new ItemStack((ItemLike)this.getAppliedWorkstation().m_41720_()));
            if (!this.getRecordItem().m_41619_()) {
                entity.m_19983_(new ItemStack((ItemLike)this.getRecordItem().m_41720_()));
                this.setRecordItem(ItemStack.f_41583_);
            }
            this.setRecordPlaying(false);
            this.setRecordTickCount(0L);
            this.setTicksSinceLastEvent(0);
        }
    }
}

