/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.core.other.tags.SMEntityTags;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMSounds;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Piranha
extends AbstractSchoolingFish
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Piranha.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)5, (int)10);
    private static final EntityDataAccessor<Boolean> HAS_BOAT_TARGET = SynchedEntityData.m_135353_(Piranha.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LEAPING = SynchedEntityData.m_135353_(Piranha.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState swimState = new AnimationState();
    public final AnimationState angrySwimState = new AnimationState();
    @Nullable
    private UUID persistentAngerTarget;
    @Nullable
    private Boat boatTarget;

    public Piranha(EntityType<? extends AbstractSchoolingFish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.m_27495_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.7);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PiranhaLeapTowardsPlayerGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PiranhaJumpOnLandGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PiranhaAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PiranhaAttackBoatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(4, (Goal)new PiranhaSwimGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, this::piranhaAngryAtPlayer));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, this::isPiranhaAngry));
        this.f_21346_.m_25352_(2, (Goal)new PiranhaTargetBoatGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public int m_6031_() {
        return 5;
    }

    public boolean isPiranhaAngry(LivingEntity pTarget) {
        Bucketable bucketable;
        return (this.m_21674_(pTarget) || pTarget.m_21223_() < pTarget.m_21233_() || pTarget.m_6162_() || pTarget.m_6095_().m_204039_(SMEntityTags.PIRANHA_ALWAYS_ATTACKS)) && !(pTarget instanceof Piranha) && !pTarget.m_6095_().m_204039_(SMEntityTags.IS_LIVING_INORGANIC) && !pTarget.m_8077_() && (!(pTarget instanceof Bucketable) || !(bucketable = (Bucketable)pTarget).m_27487_()) || this.boatTarget != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean piranhaAngryAtPlayer(LivingEntity target) {
        if (this.m_21674_(target)) return true;
        if (target instanceof Player) {
            Player player = (Player)target;
            if (!player.m_150110_().f_35937_) return true;
        }
        if (!(target.m_21223_() < target.m_21233_())) return false;
        return true;
    }

    public static boolean checkPiranhaSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WaterAnimal.m_218282_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(HAS_BOAT_TARGET, (Object)false);
        this.f_19804_.m_135372_(IS_LEAPING, (Object)false);
    }

    public boolean getLeaping() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEAPING);
    }

    public void setLeaping(boolean bool) {
        this.m_20088_().m_135381_(IS_LEAPING, (Object)bool);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
        pCompound.m_128379_("hasBoatTarget", this.hasBoatTarget());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
        this.setHasBoatTarget(pCompound.m_128471_("hasBoatTarget"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            boolean angryFlag = this.m_6784_() > 0 || this.hasBoatTarget();
            this.swimState.m_246184_(this.m_20069_() && !angryFlag, this.f_19797_);
            this.angrySwimState.m_246184_(this.m_20069_() && angryFlag, this.f_19797_);
        }
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        if (this.m_6095_().m_204039_(EntityTypeTags.f_273841_)) {
            return 0;
        }
        MobEffectInstance mobeffectinstance = this.m_21124_(MobEffects.f_19603_);
        float f = mobeffectinstance == null ? 0.0f : (float)(mobeffectinstance.m_19564_() + 1);
        return Mth.m_14167_((float)((pFallDistance - 6.0f - f) * pDamageMultiplier));
    }

    @Nullable
    public BlockPos findWater() {
        for (BlockPos blockPos : BlockPos.m_235641_((RandomSource)this.m_217043_(), (int)2, (int)(this.m_146903_() - 5), (int)(this.m_146904_() - 5), (int)(this.m_146907_() - 5), (int)(this.m_146903_() + 5), (int)this.m_146904_(), (int)(this.m_146907_() + 5))) {
            if (!this.m_9236_().m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_)) continue;
            return blockPos;
        }
        for (BlockPos blockPos : BlockPos.m_235641_((RandomSource)this.m_217043_(), (int)2, (int)(this.m_146903_() - 20), (int)(this.m_146904_() - 5), (int)(this.m_146907_() - 20), (int)(this.m_146903_() + 20), (int)this.m_146904_(), (int)(this.m_146907_() + 20))) {
            if (!this.m_9236_().m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_)) continue;
            return blockPos;
        }
        return null;
    }

    public void leapTowardsWater(BlockPos blockPos) {
        this.m_21563_().m_24946_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        Vec3 vec3 = this.m_20275_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123341_()) < 5.0 ? new Vec3((double)blockPos.m_123341_() - this.m_20185_(), (double)blockPos.m_123342_() - this.m_20186_(), (double)blockPos.m_123343_() - this.m_20189_()).m_82541_() : new Vec3((double)blockPos.m_123341_() - (this.m_20185_() - 5.0), (double)blockPos.m_123342_() - this.m_20186_(), (double)blockPos.m_123343_() - (this.m_20189_() - 5.0)).m_82541_();
        double yVelocity = 0.2;
        if (this.m_20275_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123341_()) < 4.0) {
            yVelocity = 0.1;
        }
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, yVelocity, vec3.f_82481_));
        this.m_5496_(this.m_5699_(), this.m_6121_(), this.m_6100_());
    }

    public void m_8107_() {
        BlockPos blockPos;
        super.m_8107_();
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_ && (blockPos = this.findWater()) != null && (this.m_21223_() < this.m_21233_() / 2.0f || this.m_20146_() < this.m_6062_() / 2)) {
            this.leapTowardsWater(blockPos);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            this.setHasBoatTarget(this.getBoatTarget() != null);
        }
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)SMSounds.PIRANHA_FLOP.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SMSounds.PIRANHA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SMSounds.PIRANHA_DEATH.get();
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)SMItems.PIRANHA_BUCKET.get());
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public boolean hasBoatTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BOAT_TARGET);
    }

    public void setHasBoatTarget(boolean hasBoatTarget) {
        this.f_19804_.m_135381_(HAS_BOAT_TARGET, (Object)hasBoatTarget);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.boatTarget == null ? super.m_5448_() : null;
    }

    @Nullable
    public Boat getBoatTarget() {
        return this.boatTarget;
    }

    public void setBoatTarget(@Nullable Boat boatTarget) {
        this.boatTarget = boatTarget;
    }

    static class PiranhaLeapTowardsPlayerGoal
    extends JumpGoal {
        Piranha piranha;

        public PiranhaLeapTowardsPlayerGoal(Piranha pMob) {
            this.piranha = pMob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.piranha.m_5448_();
            if (this.piranha.m_217043_().m_188503_(4) != 0) {
                return false;
            }
            if (this.piranha.m_21223_() < this.piranha.m_21233_() / 2.0f) {
                return false;
            }
            if (this.piranha.m_20146_() < this.piranha.m_6062_() / 2) {
                return false;
            }
            if (this.piranha.m_20075_().m_60819_().m_192917_((Fluid)Fluids.f_76193_) || this.piranha.m_20075_().m_60795_()) {
                return false;
            }
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (target.m_6374_() != target.m_6350_()) {
                return false;
            }
            if (target.m_21223_() == target.m_21233_() || !this.piranha.isPiranhaAngry(target)) {
                return false;
            }
            boolean pathClear = this.isPathClear(this.piranha, target);
            if (!pathClear) {
                this.piranha.m_21573_().m_6570_((Entity)target, 0);
            }
            return pathClear;
        }

        protected boolean isPathClear(Piranha piranha, LivingEntity pLivingEntity) {
            double d0 = pLivingEntity.m_20189_() - piranha.m_20189_();
            double d1 = pLivingEntity.m_20185_() - piranha.m_20185_();
            double d2 = d0 / d1;
            int i = 6;
            for (int j = 0; j < 6; ++j) {
                double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
                double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
                for (int k = 1; k < 4; ++k) {
                    if (piranha.m_9236_().m_8055_(BlockPos.m_274561_((double)(piranha.m_20185_() + d4), (double)(piranha.m_20186_() + (double)k), (double)(piranha.m_20189_() + d3))).m_247087_()) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean m_8045_() {
            LivingEntity target = this.piranha.m_5448_();
            if (this.piranha.m_217043_().m_188503_(4) != 0) {
                return false;
            }
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (this.piranha.m_20075_().m_60819_().m_192917_((Fluid)Fluids.f_76193_) || this.piranha.m_20075_().m_60795_()) {
                return false;
            }
            double yMovement = this.piranha.m_20184_().f_82480_;
            return !(yMovement * yMovement < (double)0.05f) || !(Math.abs(this.piranha.m_146909_()) < 15.0f) || !this.piranha.m_20096_();
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.piranha.m_6862_(true);
            this.piranha.setLeaping(true);
            LivingEntity target = this.piranha.m_5448_();
            if (target != null) {
                double yVelocity = 0.3;
                if (this.piranha.m_20270_((Entity)target) < 5.0f) {
                    yVelocity = 0.2;
                }
                this.piranha.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
                Vec3 vec3 = new Vec3(target.m_20185_() - this.piranha.m_20185_(), target.m_20186_() - this.piranha.m_20186_(), target.m_20189_() - this.piranha.m_20189_()).m_82541_();
                this.piranha.m_20256_(this.piranha.m_20184_().m_82520_(vec3.f_82479_, yVelocity, vec3.f_82481_));
            }
        }

        public void m_8041_() {
            this.piranha.m_6862_(false);
            this.piranha.setLeaping(false);
        }

        public void m_8037_() {
            LivingEntity target = this.piranha.m_5448_();
            if (target != null) {
                this.piranha.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
            }
            Vec3 vec3 = this.piranha.m_20184_();
            if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.piranha.m_146909_() != 0.0f) {
                this.piranha.m_146926_(Mth.m_14189_((float)0.2f, (float)this.piranha.m_146909_(), (float)0.0f));
            } else {
                double d0 = vec3.m_165924_();
                double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 57.2957763671875;
                this.piranha.m_146926_((float)d1);
            }
            if (target != null && this.piranha.m_20270_((Entity)target) <= 2.0f) {
                this.piranha.m_7327_((Entity)target);
            } else if (this.piranha.m_146909_() > 0.0f && this.piranha.m_20096_() && (float)this.piranha.m_20184_().f_82480_ != 0.0f) {
                this.piranha.m_146926_(60.0f);
                this.piranha.m_6710_(null);
            }
        }
    }

    static class PiranhaJumpOnLandGoal
    extends JumpGoal {
        Piranha piranha;

        public PiranhaJumpOnLandGoal(Piranha pMob) {
            this.piranha = pMob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.piranha.m_5448_();
            if (!this.piranha.m_9236_().m_6425_(this.piranha.m_20097_().m_7494_()).m_192917_((Fluid)Fluids.f_76193_)) {
                return false;
            }
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (target.m_20069_() || !this.piranha.m_20069_()) {
                return false;
            }
            if (target.m_6374_() != target.m_6350_()) {
                return false;
            }
            if (target.m_21223_() == target.m_21233_() || !this.piranha.isPiranhaAngry(target)) {
                return false;
            }
            boolean pathClear = this.isPathClear(this.piranha, target);
            if (!pathClear) {
                this.piranha.m_21573_().m_6570_((Entity)target, 0);
            }
            return pathClear;
        }

        protected boolean isPathClear(Piranha piranha, LivingEntity pLivingEntity) {
            double d0 = pLivingEntity.m_20189_() - piranha.m_20189_();
            double d1 = pLivingEntity.m_20185_() - piranha.m_20185_();
            double d2 = d0 / d1;
            int i = 6;
            for (int j = 0; j < 6; ++j) {
                double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
                double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
                for (int k = 1; k < 4; ++k) {
                    if (piranha.m_9236_().m_8055_(BlockPos.m_274561_((double)(piranha.m_20185_() + d4), (double)(piranha.m_20186_() + (double)k), (double)(piranha.m_20189_() + d3))).m_247087_()) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean m_8045_() {
            LivingEntity target = this.piranha.m_5448_();
            if (target == null || !target.m_6084_()) {
                return false;
            }
            if (target.m_20069_() || !this.piranha.m_20069_()) {
                return false;
            }
            double yMovement = this.piranha.m_20184_().f_82480_;
            return !(yMovement * yMovement < (double)0.05f) || !(Math.abs(this.piranha.m_146909_()) < 15.0f) || !this.piranha.m_20096_();
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.piranha.m_6862_(true);
            this.piranha.setLeaping(true);
            LivingEntity target = this.piranha.m_5448_();
            if (target != null) {
                double yVelocity = 0.5;
                if (this.piranha.m_20270_((Entity)target) < 5.0f) {
                    yVelocity = 0.4;
                }
                this.piranha.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
                Vec3 vec3 = new Vec3(target.m_20185_() - this.piranha.m_20185_(), target.m_20186_() - this.piranha.m_20186_(), target.m_20189_() - this.piranha.m_20189_()).m_82541_();
                this.piranha.m_20256_(this.piranha.m_20184_().m_82520_(vec3.f_82479_, yVelocity, vec3.f_82481_));
            }
            this.piranha.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.piranha.m_6862_(false);
            this.piranha.setLeaping(false);
        }

        public void m_8037_() {
            LivingEntity target = this.piranha.m_5448_();
            if (target != null) {
                this.piranha.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
            }
            Vec3 vec3 = this.piranha.m_20184_();
            if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.piranha.m_146909_() != 0.0f) {
                this.piranha.m_146926_(Mth.m_14189_((float)0.2f, (float)this.piranha.m_146909_(), (float)0.0f));
            } else {
                double d0 = vec3.m_165924_();
                double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 57.2957763671875;
                this.piranha.m_146926_((float)d1);
            }
            if (target != null && this.piranha.m_20270_((Entity)target) <= 2.0f) {
                this.piranha.m_7327_((Entity)target);
            } else if (this.piranha.m_146909_() > 0.0f && this.piranha.m_20096_() && (float)this.piranha.m_20184_().f_82480_ != 0.0f) {
                this.piranha.m_146926_(60.0f);
                this.piranha.m_6710_(null);
            }
        }
    }

    static class PiranhaAttackGoal
    extends MeleeAttackGoal {
        Piranha piranha;

        PiranhaAttackGoal(Piranha pMob) {
            super((PathfinderMob)pMob, 1.5, true);
            this.piranha = pMob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.piranha.m_5448_();
            return super.m_8036_() && target != null && (target.m_21223_() == target.m_21233_() || this.piranha.isPiranhaAngry(target)) && this.piranha.m_20069_() && Objects.requireNonNull(this.piranha.m_5448_()).m_20069_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.piranha.m_20069_() && Objects.requireNonNull(this.piranha.m_5448_()).m_20069_();
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.piranha.m_5448_();
            if (target != null && (this.piranha.m_21188_() == null || !this.piranha.m_21188_().m_7306_((Entity)target)) && target.m_21223_() >= target.m_21233_()) {
                this.piranha.m_21662_();
            }
        }
    }

    static class PiranhaAttackBoatGoal
    extends Goal {
        Piranha piranha;
        private final double speedModifier;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;

        public PiranhaAttackBoatGoal(Piranha pMob) {
            this.piranha = pMob;
            this.speedModifier = 1.5;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long gameTime = this.piranha.m_9236_().m_46467_();
            Boat boatTarget = this.piranha.getBoatTarget();
            if (gameTime - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = gameTime;
            if (boatTarget == null || !boatTarget.m_6084_() || !boatTarget.m_20069_()) {
                return false;
            }
            this.path = this.piranha.m_21573_().m_6570_((Entity)boatTarget, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(boatTarget) >= this.piranha.m_20275_(boatTarget.m_20185_(), boatTarget.m_20186_(), boatTarget.m_20189_());
        }

        public boolean m_8045_() {
            Boat boat = this.piranha.getBoatTarget();
            if (boat == null || !boat.m_6084_()) {
                return false;
            }
            return this.piranha.m_21444_(boat.m_20183_());
        }

        public void m_8056_() {
            this.piranha.m_21573_().m_26536_(this.path, this.speedModifier);
            this.piranha.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            this.piranha.m_6710_(null);
            this.piranha.m_21561_(false);
            this.piranha.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            Boat boatTarget = this.piranha.getBoatTarget();
            if (boatTarget != null) {
                this.piranha.m_21563_().m_24960_((Entity)boatTarget, 30.0f, 30.0f);
                double d0 = this.piranha.m_20238_(boatTarget.m_20182_());
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if (this.piranha.m_21574_().m_148306_((Entity)boatTarget) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || boatTarget.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.piranha.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = boatTarget.m_20185_();
                    this.pathedTargetY = boatTarget.m_20186_();
                    this.pathedTargetZ = boatTarget.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.piranha.m_217043_().m_188503_(7);
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.piranha.m_21573_().m_5624_((Entity)boatTarget, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(boatTarget, d0);
            }
        }

        protected void checkAndPerformAttack(Boat pEnemy, double pDistToEnemySqr) {
            double d0 = this.getAttackReachSqr(pEnemy);
            if (pDistToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                float damage = (float)this.piranha.m_21133_(Attributes.f_22281_);
                pEnemy.m_6469_(this.piranha.m_269291_().m_269333_((LivingEntity)this.piranha), damage * 1.3f);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected double getAttackReachSqr(Boat pAttackTarget) {
            return this.piranha.m_20205_() * 2.0f * this.piranha.m_20205_() * 2.0f + pAttackTarget.m_20205_();
        }
    }

    static class PiranhaSwimGoal
    extends RandomSwimmingGoal {
        private final Piranha fish;

        public PiranhaSwimGoal(Piranha pFish) {
            super((PathfinderMob)pFish, 1.0, 40);
            this.fish = pFish;
        }

        public boolean m_8036_() {
            return this.fish.m_6004_() && super.m_8036_();
        }
    }

    static class PiranhaTargetBoatGoal
    extends Goal {
        Piranha piranha;
        protected final int randomInterval;
        @Nullable
        protected Boat target;
        private int unseenTicks;
        protected int unseenMemoryTicks = 60;

        public PiranhaTargetBoatGoal(Piranha pMob) {
            this.piranha = pMob;
            this.randomInterval = PiranhaTargetBoatGoal.m_186073_((int)10);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.piranha.m_5448_() != null && this.randomInterval > 0 && this.piranha.m_217043_().m_188503_(this.randomInterval) != 0) {
                return false;
            }
            this.findTarget();
            return true;
        }

        public boolean m_8045_() {
            Boat boatTarget = this.piranha.getBoatTarget();
            if (boatTarget == null) {
                boatTarget = this.target;
            }
            if (boatTarget == null) {
                return false;
            }
            if (boatTarget.m_213877_() || boatTarget.m_20147_() || !boatTarget.m_20069_()) {
                return false;
            }
            double d0 = this.getFollowDistance();
            if (this.piranha.m_20280_((Entity)boatTarget) > d0 * d0) {
                return false;
            }
            if (this.piranha.m_21574_().m_148306_((Entity)boatTarget)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > PiranhaTargetBoatGoal.m_186073_((int)this.unseenMemoryTicks)) {
                return false;
            }
            this.piranha.setBoatTarget(boatTarget);
            return true;
        }

        protected AABB getTargetSearchArea(double pTargetDistance) {
            return this.piranha.m_20191_().m_82377_(pTargetDistance, 4.0, pTargetDistance);
        }

        protected void findTarget() {
            this.target = this.getNearestBoat(this.piranha.m_9236_().m_6443_(Boat.class, this.getTargetSearchArea(this.getFollowDistance()), p_148152_ -> true), this.piranha.m_20185_(), this.piranha.m_20188_(), this.piranha.m_20189_());
        }

        @Nullable
        private <T extends Boat> T getNearestBoat(List<? extends T> pEntities, double pX, double pY, double pZ) {
            double d0 = -1.0;
            Boat target = null;
            for (Boat possibleTarget : pEntities) {
                double distanceToTarget = possibleTarget.m_20275_(pX, pY, pZ);
                if (d0 != -1.0 && !(distanceToTarget < d0) || !possibleTarget.m_20069_()) continue;
                d0 = distanceToTarget;
                target = possibleTarget;
            }
            return (T)target;
        }

        protected double getFollowDistance() {
            return this.piranha.m_21133_(Attributes.f_22277_);
        }

        public void m_8056_() {
            this.piranha.setBoatTarget(this.target);
            this.unseenTicks = 0;
        }

        public void m_8041_() {
            this.piranha.setBoatTarget(null);
            this.target = null;
        }
    }
}

