/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.common.entities;

import com.uraneptus.sullysmod.core.registry.SMSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class BoulderingZombie
extends Zombie {
    private static final EntityDataAccessor<Byte> CLIMBING_DATA = SynchedEntityData.m_135353_(BoulderingZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected final WallClimberNavigation climberNavigation;
    protected final GroundPathNavigation groundNavigation;
    public final AnimationState climbAnimationState = new AnimationState();

    public BoulderingZombie(EntityType<? extends BoulderingZombie> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.climberNavigation = new WallClimberNavigation((Mob)this, pLevel);
        this.groundNavigation = new GroundPathNavigation((Mob)this, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22276_, 23.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public static boolean checkBoulderingZombieSpawnRules(EntityType<? extends BoulderingZombie> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return BoulderingZombie.isInDeepslateLayer(pos, random) && Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isInDeepslateLayer(BlockPos pos, RandomSource random) {
        int chance = random.m_188503_(100);
        double y = pos.m_123342_();
        return y <= -4.0 && y >= -15.0 && chance < 50 || y <= -16.0 && y >= -30.0 && chance < 68 || y <= -31.0 && y >= -39.0 && chance < 80 || y <= -40.0 && y >= -63.0 && chance < 90;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.5f : 1.0625f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING_DATA, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (CLIMBING_DATA.equals(pKey)) {
            if (this.m_6147_()) {
                this.climbAnimationState.m_216977_(this.f_19797_);
            } else {
                this.climbAnimationState.m_216973_();
            }
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_5448_() != null) {
                this.f_21344_ = this.climberNavigation;
                this.setClimbing(this.f_19862_);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.setClimbing(false);
            }
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_269533_(DamageTypeTags.f_268745_)) {
            pAmount *= 1.5f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6147_() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING_DATA) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING_DATA);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING_DATA, (Object)b0);
    }

    protected ItemStack m_5728_() {
        return ItemStack.f_41583_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SMSounds.BOULDERING_ZOMBIE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SMSounds.BOULDERING_ZOMBIE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SMSounds.BOULDERING_ZOMBIE_DEATH.get();
    }
}

