/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.uraneptus.sullysmod.SullysMod;
import com.uraneptus.sullysmod.client.model.TortoiseShellModel;
import com.uraneptus.sullysmod.common.entities.TortoiseShell;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class TortoiseShellRenderer<E extends TortoiseShell>
extends EntityRenderer<E> {
    public static final ResourceLocation TEXTURE_CRAFTING = SullysMod.modPrefix("textures/entity/tortoise/tortoise_crafting.png");
    public static final ResourceLocation TEXTURE_JUKEBOX = SullysMod.modPrefix("textures/entity/tortoise/tortoise_jukebox.png");
    protected final TortoiseShellModel<E> model;

    public TortoiseShellRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.75f;
        this.model = new TortoiseShellModel(context.m_174023_(TortoiseShellModel.LAYER_LOCATION));
    }

    public void render(E pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, -1.0, 0.0);
        float spinTime = (float)((TortoiseShell)pEntity).f_19797_ + pPartialTicks;
        if (((TortoiseShell)pEntity).getSpinTicksEntityData() > 0) {
            pMatrixStack.m_252781_(new Quaternionf().rotateY(spinTime * 0.56f));
        }
        float hurtTime = (float)((TortoiseShell)pEntity).getHurtTime() - pPartialTicks;
        float damage = ((TortoiseShell)pEntity).getDamage() - pPartialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)hurtTime) * hurtTime * damage / 96.0f * (float)((TortoiseShell)pEntity).getHurtDir()));
        }
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        this.model.root().m_171324_((String)"workstationSaddle").f_104207_ = ((TortoiseShell)pEntity).hasAppliedWorkstation();
        this.model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(E pEntity) {
        return pEntity.isCraftingTable() ? TEXTURE_CRAFTING : TEXTURE_JUKEBOX;
    }
}

