/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.uraneptus.sullysmod.common.particletypes.DirectionParticleOptions;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RicochetParticle
extends TextureSheetParticle {
    private final SpriteSet animatedSprite;
    private final Direction face;

    public RicochetParticle(SpriteSet animatedSprite, ClientLevel level, double posX, double posY, double posZ, Direction face) {
        super(level, posX, posY, posZ);
        this.f_107663_ = 0.45f;
        this.animatedSprite = animatedSprite;
        this.f_107225_ = 5;
        this.f_107219_ = false;
        this.m_108339_(animatedSprite);
        this.face = face;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.animatedSprite);
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.m_90583_();
        float posX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float posY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float posZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        Quaternionf quaternion = this.face.m_253075_();
        quaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        float roll = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
        quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(roll));
        Vector3f spriteNormal = new Vector3f(-1.0f, -1.0f, 0.0f);
        spriteNormal.rotate((Quaternionfc)quaternion);
        Vector3f[] faces = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float quadSize = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f face = faces[i];
            face.rotate((Quaternionfc)quaternion);
            face.mul(quadSize);
            face.add(posX, posY, posZ);
        }
        int light = this.m_6355_(partialTicks);
        vertexConsumer.m_5483_((double)faces[0].x(), (double)faces[0].y(), (double)faces[0].z()).m_7421_(this.m_5952_(), this.m_5950_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)faces[1].x(), (double)faces[1].y(), (double)faces[1].z()).m_7421_(this.m_5952_(), this.m_5951_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)faces[2].x(), (double)faces[2].y(), (double)faces[2].z()).m_7421_(this.m_5970_(), this.m_5951_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)faces[3].x(), (double)faces[3].y(), (double)faces[3].z()).m_7421_(this.m_5970_(), this.m_5950_()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RicochetParticleProvider
    implements ParticleProvider<DirectionParticleOptions> {
        private final SpriteSet sprites;

        public RicochetParticleProvider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(DirectionParticleOptions pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new RicochetParticle(this.sprites, pLevel, pX, pY, pZ, pType.getFace());
        }
    }
}

