/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.sullysmod;

import com.mojang.logging.LogUtils;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.uraneptus.sullysmod.common.caps.SMEntityCap;
import com.uraneptus.sullysmod.common.entities.BoulderingZombie;
import com.uraneptus.sullysmod.common.entities.JungleSpider;
import com.uraneptus.sullysmod.common.entities.Lanternfish;
import com.uraneptus.sullysmod.common.entities.Piranha;
import com.uraneptus.sullysmod.common.entities.Tortoise;
import com.uraneptus.sullysmod.common.networking.SMPacketHandler;
import com.uraneptus.sullysmod.common.recipes.SMFeatureRecipeCondition;
import com.uraneptus.sullysmod.core.SMConfig;
import com.uraneptus.sullysmod.core.other.SMTextDefinitions;
import com.uraneptus.sullysmod.core.registry.SMBiomeModifiers;
import com.uraneptus.sullysmod.core.registry.SMBlockEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMBlocks;
import com.uraneptus.sullysmod.core.registry.SMBrewingRecipes;
import com.uraneptus.sullysmod.core.registry.SMCreativeModeTabs;
import com.uraneptus.sullysmod.core.registry.SMDispenseBehaviors;
import com.uraneptus.sullysmod.core.registry.SMEntityTypes;
import com.uraneptus.sullysmod.core.registry.SMFeatures;
import com.uraneptus.sullysmod.core.registry.SMFluidTypes;
import com.uraneptus.sullysmod.core.registry.SMFluids;
import com.uraneptus.sullysmod.core.registry.SMItems;
import com.uraneptus.sullysmod.core.registry.SMLootItemConditions;
import com.uraneptus.sullysmod.core.registry.SMNoteBlockInstruments;
import com.uraneptus.sullysmod.core.registry.SMPaintingVariants;
import com.uraneptus.sullysmod.core.registry.SMParticleTypes;
import com.uraneptus.sullysmod.core.registry.SMPetrifiedTreeVariants;
import com.uraneptus.sullysmod.core.registry.SMPotions;
import com.uraneptus.sullysmod.core.registry.SMRecipeSerializer;
import com.uraneptus.sullysmod.core.registry.SMRecipeTypes;
import com.uraneptus.sullysmod.core.registry.SMTreeDecoratorTypes;
import com.uraneptus.sullysmod.data.client.SMBlockStateProvider;
import com.uraneptus.sullysmod.data.client.SMItemModelProvider;
import com.uraneptus.sullysmod.data.client.SMLangProvider;
import com.uraneptus.sullysmod.data.client.SMSoundDefinitionsProvider;
import com.uraneptus.sullysmod.data.client.SMSpriteSourceProvider;
import com.uraneptus.sullysmod.data.server.SMRecipeProvider;
import com.uraneptus.sullysmod.data.server.advancements.SMAdvancementProvider;
import com.uraneptus.sullysmod.data.server.builtin.SMBuiltinEntriesProvider;
import com.uraneptus.sullysmod.data.server.loot.SMLootTableProvider;
import com.uraneptus.sullysmod.data.server.modifiers.SMAdvancementModifiersProvider;
import com.uraneptus.sullysmod.data.server.modifiers.SMLootModifierProvider;
import com.uraneptus.sullysmod.data.server.tags.SMBiomeTagsProvider;
import com.uraneptus.sullysmod.data.server.tags.SMBlockTagsProvider;
import com.uraneptus.sullysmod.data.server.tags.SMEntityTagsProvider;
import com.uraneptus.sullysmod.data.server.tags.SMFluidTagsProvider;
import com.uraneptus.sullysmod.data.server.tags.SMItemTagsProvider;
import com.uraneptus.sullysmod.data.server.tags.SMPaintingVariantTagsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="sullysmod")
@Mod.EventBusSubscriber(modid="sullysmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SullysMod {
    public static final String MOD_ID = "sullysmod";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("sullysmod");
    public static final Logger LOGGER = LogUtils.getLogger();

    public SullysMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::gatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SMConfig.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SMConfig.COMMON);
        SMTextDefinitions.init();
        SMPetrifiedTreeVariants.init();
        REGISTRY_HELPER.register(bus);
        SMBlocks.BLOCKS.register(bus);
        SMItems.ITEMS.register(bus);
        SMBlockEntityTypes.BLOCK_ENTITY.register(bus);
        SMParticleTypes.PARTICLES.register(bus);
        SMPotions.POTIONS.register(bus);
        SMRecipeTypes.RECIPE_TYPES.register(bus);
        SMRecipeSerializer.SERIALIZERS.register(bus);
        SMLootItemConditions.ITEM_CONDITIONS.register(bus);
        SMPaintingVariants.PAINTINGS.register(bus);
        SMBiomeModifiers.BIOME_MODIFIERS.register(bus);
        SMTreeDecoratorTypes.TREE_DECORATORS.register(bus);
        SMFeatures.FEATURES.register(bus);
        SMCreativeModeTabs.TABS.register(bus);
        SMFluids.FLUIDS.register(bus);
        SMFluidTypes.FLUID_TYPES.register(bus);
        CraftingHelper.register((IConditionSerializer)new SMFeatureRecipeCondition.Serializer());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation modPrefix(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation blueprintPrefix(String path) {
        return new ResourceLocation("blueprint", path);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SMEntityTypes.LANTERNFISH.get(), Lanternfish.createAttributes().m_22265_());
        event.put((EntityType)SMEntityTypes.TORTOISE.get(), Tortoise.createAttributes().m_22265_());
        event.put((EntityType)SMEntityTypes.BOULDERING_ZOMBIE.get(), BoulderingZombie.createAttributes().m_22265_());
        event.put((EntityType)SMEntityTypes.JUNGLE_SPIDER.get(), JungleSpider.createAttributes().m_22265_());
        event.put((EntityType)SMEntityTypes.PIRANHA.get(), Piranha.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(SMEntityCap.class);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SMBrewingRecipes.register();
            SMDispenseBehaviors.register();
            SMNoteBlockInstruments.register();
            SMPacketHandler.register();
        });
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new SMBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SMItemModelProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SMSoundDefinitionsProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SMLangProvider(packOutput, MOD_ID));
        generator.addProvider(includeClient, (DataProvider)new SMSpriteSourceProvider(packOutput, fileHelper));
        SMBlockTagsProvider blockTagProvider = new SMBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        generator.addProvider(includeServer, (DataProvider)new SMEntityTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)blockTagProvider);
        generator.addProvider(includeServer, (DataProvider)new SMItemTagsProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SMBiomeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SMPaintingVariantTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SMAdvancementModifiersProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new SMLootTableProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new SMAdvancementProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SMRecipeProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new SMLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new SMBuiltinEntriesProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new SMFluidTagsProvider(packOutput, lookupProvider, MOD_ID, fileHelper));
    }
}

