/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.block_entity.IRotatable;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.UpdateBuildingToolPacket;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.SoundActions;

public abstract class BuildingToolMode {
    private static final String MESSAGE_PRE = "info.structure_gel.building_tool.message.";
    protected static final String SET_POS_KEY = "info.structure_gel.building_tool.message.set_pos";
    protected static final String SIZE_KEY = "info.structure_gel.building_tool.message.size";
    protected static final String CLEAR_POSES_KEY = "info.structure_gel.building_tool.message.clear_poses";
    protected static final String MISSING_POS_KEY = "info.structure_gel.building_tool.message.missing_pos";
    protected static final String POS_UNLOADED_KEY = "info.structure_gel.building_tool.message.pos_unloaded";
    protected static final String SELECT_STATE_KEY = "info.structure_gel.building_tool.message.select_state";
    protected static final String SELECT_PALLETE_KEY = "info.structure_gel.building_tool.message.select_pallete";
    protected static final String MISSING_STATE_KEY = "info.structure_gel.building_tool.message.missing_state";
    public static final String SET_REACH_KEY = "info.structure_gel.building_tool.message.set_reach";
    protected static final String PLACE_BLOCKS_KEY = "info.structure_gel.building_tool.message.place_blocks";
    protected static final String PLACE_BLOCK_KEY = "info.structure_gel.building_tool.message.place_block";
    protected static final String PLACE_BLOCKS_WITH_KEY = "info.structure_gel.building_tool.message.place_blocks_with";
    protected static final String REPLACE_BLOCKS_WITH_KEY = "info.structure_gel.building_tool.message.replace_blocks_with";
    protected static final String REPLACE_BLOCKS_KEY = "info.structure_gel.building_tool.message.replace_blocks";
    protected static final String REPLACE_BLOCK_KEY = "info.structure_gel.building_tool.message.replace_block";
    protected static final String CLONE_BLOCKS_KEY = "info.structure_gel.building_tool.message.clone_blocks";
    protected static final String CLIPBOARD_MISSING_KEY = "info.structure_gel.building_tool.message.clipboard_missing";
    protected static final String MOVE_BLOCKS_KEY = "info.structure_gel.building_tool.message.move_blocks";
    protected static final String GRABBED_CORNER_KEY = "info.structure_gel.building_tool.message.grabbed_corner";
    protected static final String PLACED_CORNER_KEY = "info.structure_gel.building_tool.message.placed_corner";
    protected static final String GRABBED_BOUNDS_KEY = "info.structure_gel.building_tool.message.grabbed_bounds";
    protected static final String PLACED_BOUNDS_KEY = "info.structure_gel.building_tool.message.placed_bounds";
    protected static final String SELECT_CORNERS = "item.structure_gel.building_tool.mode.select_corners";
    protected static final String SELECT_POSITIONS = "item.structure_gel.building_tool.mode.select_positions";
    protected static final String LENGTH_KEY = "info.structure_gel.building_tool.message.length";
    public static final Codec<BuildingToolMode> CODEC = ResourceLocation.f_135803_.xmap(name -> BuildingToolModes.REGISTRY.get((ResourceLocation)name), mode -> mode.getName());
    protected final ResourceLocation name;
    private final int modelIndex;
    private final ResourceLocation iconTexture;
    private final Component component;
    private final String descKey;
    private final Map<String, ToolModeProperty<?>> properties;

    public BuildingToolMode(String name, int modelIndex) {
        this(StructureGelMod.locate(name), modelIndex);
    }

    private BuildingToolMode(ResourceLocation name, int modelIndex) {
        this.name = name;
        this.modelIndex = modelIndex;
        this.iconTexture = new ResourceLocation(name.m_135827_(), "textures/item/building_tool_" + name.m_135815_() + ".png");
        this.component = Component.m_237115_((String)("item.structure_gel.building_tool.mode." + name.toString()));
        this.descKey = "item.structure_gel.building_tool.mode.description." + name.toString();
        ArrayList props = new ArrayList();
        this.addProperties(props);
        this.properties = (Map)props.stream().collect(ImmutableMap.toImmutableMap(ToolModeProperty::getKey, Function.identity()));
    }

    public void onSelect(ItemStack stack, Level level, Player player) {
    }

    public void onReleaseCorner(ItemStack stack, Level level, Player player) {
    }

    public abstract boolean hasBlockPalette();

    public boolean targetsSpecificPos() {
        return true;
    }

    public int getSpamDelay() {
        return 0;
    }

    public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
    }

    public void onRightClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
    }

    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
    }

    public void onMiddleClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.readPalleteFrom(level, clickedPos);
            BuildingToolItem.setPallete(stack, pallete);
            SGPacketHandler.sendToClient(UpdateBuildingToolPacket.builder().toClient().pallete(pallete).build(), serverPlayer);
            BuildingToolMode.sendMessage(player, pallete.m_146338_().size() == 1 ? SELECT_STATE_KEY : SELECT_PALLETE_KEY, ((BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_()).m_60734_().m_49954_().getString());
            BuildingToolMode.playSound(player, SoundEvents.f_12019_);
        }
    }

    public void onMiddleClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
    }

    public void addProperties(List<ToolModeProperty<?>> properties) {
    }

    protected boolean setBlock(Level level, BlockPos pos, BlockState state, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, state, null, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, BlockState state, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, (BlockState old) -> state, blockEntityTag, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, modifyState, null, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, modifyState, blockEntityTag, actionBuilder, Mirror.NONE, Rotation.NONE);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder, Mirror mirror, Rotation rotation) {
        CompoundTag oldBETag;
        BlockState oldState = level.m_8055_(pos);
        BlockState newState = modifyState.apply(oldState);
        if (newState == null) {
            return false;
        }
        BlockEntity oldBlockEntity = level.m_7702_(pos);
        if (oldBlockEntity != null) {
            oldBETag = oldBlockEntity.m_187482_();
            Clearable.m_18908_((Object)oldBlockEntity);
            level.m_7731_(pos, Blocks.f_50375_.m_49966_(), 2);
        } else {
            oldBETag = null;
        }
        int flags = 3;
        if (newState.m_61138_((Property)BlockStateProperties.f_61401_) || newState.m_61138_((Property)BlockStateProperties.f_61391_)) {
            flags += 16;
        }
        boolean ret = level.m_7731_(pos, newState, flags);
        BlockEntity newBlockEntity = level.m_7702_(pos);
        if (newBlockEntity != null) {
            if (blockEntityTag != null) {
                newBlockEntity.m_142466_(blockEntityTag);
            }
            if (newBlockEntity instanceof IRotatable) {
                IRotatable r = (IRotatable)newBlockEntity;
                r.transform(mirror, rotation);
            }
        }
        if (ret) {
            actionBuilder.changeBlock(pos, oldState, oldBETag, newState, blockEntityTag);
        }
        return ret;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int modelIndex() {
        return this.modelIndex;
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    public Component getComponent() {
        return this.component;
    }

    public String getDescKey() {
        return this.descKey;
    }

    public abstract Object[] getDescArgs();

    public Map<String, ToolModeProperty<?>> getProperties() {
        return this.properties;
    }

    public int getReachDistance(ItemStack stack) {
        return 2;
    }

    public int forPosesWithin(Vec3i cornerA, Vec3i cornerB, Function<BlockPos, Boolean> action) {
        int total = 0;
        BoundingBox area = BoundingBox.m_162375_((Vec3i)cornerA, (Vec3i)cornerB);
        for (int x = area.m_162395_(); x <= area.m_162399_(); ++x) {
            for (int z = area.m_162398_(); z <= area.m_162401_(); ++z) {
                for (int y = area.m_162396_(); y <= area.m_162400_(); ++y) {
                    if (!action.apply(new BlockPos(x, y, z)).booleanValue()) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    protected void setPos(ItemStack stack, int index, BlockPos pos, Player player, boolean message) {
        if (BuildingToolItem.setPos(stack, index, (Vec3i)pos) && message) {
            MutableComponent msg = Component.m_237110_((String)SET_POS_KEY, (Object[])new Object[]{Component.m_237113_((String)Integer.toString(index + 1)).m_130948_(index == 0 ? SGText.X_LABEL_STYLE : (index == 1 ? SGText.Z_LABEL_STYLE : SGText.Y_LABEL_STYLE)), Component.m_237113_((String)("" + pos.m_123341_())).m_130948_(SGText.X_LABEL_STYLE), Component.m_237113_((String)("" + pos.m_123342_())).m_130948_(SGText.Y_LABEL_STYLE), Component.m_237113_((String)("" + pos.m_123343_())).m_130948_(SGText.Z_LABEL_STYLE)});
            BuildingToolMode.sendMessage(player, (Component)msg);
            BuildingToolMode.playSound(player, pos, SoundEvents.f_12632_, 1.0f - 0.6f * (float)index);
        }
    }

    @Nullable
    public Component getHudMessage(ItemStack stack) {
        return null;
    }

    public void clearPoses(ItemStack stack, Player player) {
        if (BuildingToolItem.getPos(stack, 0).isPresent() || BuildingToolItem.getPos(stack, 1).isPresent()) {
            BuildingToolMode.sendMessage(player, CLEAR_POSES_KEY, new Object[0]);
            BuildingToolMode.playSound(player, player.m_20183_(), SoundEvents.f_11681_);
        }
        BuildingToolItem.clearPoses(stack);
    }

    protected static void sendMessage(Player player, String translationKey, Object ... args) {
        BuildingToolMode.sendMessage(player, translationKey, Style.f_131099_, args);
    }

    protected static void sendMessage(Player player, String translationKey, Style style, Object ... args) {
        BuildingToolMode.sendMessage(player, (Component)Component.m_237110_((String)translationKey, (Object[])args).m_6270_(style));
    }

    protected static void sendMessage(Player player, Component component) {
        player.m_5661_(component, true);
    }

    protected static void playSound(Player player, SoundEvent sound) {
        BuildingToolMode.playSound(player, player.m_20183_(), sound);
    }

    protected static void playSound(Player player, BlockPos pos, SoundEvent sound) {
        BuildingToolMode.playSound(player, pos, sound, 1.0f + player.m_9236_().m_213780_().m_188501_() * 0.2f);
    }

    protected static void playSound(Player player, BlockPos pos, SoundEvent sound, float pitch) {
        player.m_9236_().m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.8f, pitch);
    }

    protected static void playSound(Player player, BlockState state) {
        LiquidBlock liquidBlock;
        SoundEvent emptySound;
        Block block = state.m_60734_();
        SoundEvent sound = block instanceof LiquidBlock ? ((emptySound = (liquidBlock = (LiquidBlock)block).getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) == null ? SoundEvents.f_11778_ : emptySound) : state.m_60827_().m_56777_();
        BuildingToolMode.playSound(player, sound);
    }

    public String toString() {
        return "BuildingToolMode[" + this.name + "]";
    }

    protected static void sendPlaceMessage(Player player, ToolModeProperty.Replace replaceMode, int placedBlocks, WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete) {
        int palleteSize;
        BuildingToolMode.sendPlaceMessage(player, replaceMode, placedBlocks, palleteSize, (palleteSize = pallete.m_146338_().size()) > 0 ? (BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_() : Blocks.f_50069_.m_49966_());
    }

    protected static void sendPlaceMessage(Player player, ToolModeProperty.Replace replaceMode, int placedBlocks, int palleteSize, BlockState messageState) {
        String message = replaceMode.usePlaceMessage ? (palleteSize == 1 ? PLACE_BLOCKS_WITH_KEY : (placedBlocks > 1 ? PLACE_BLOCKS_KEY : PLACE_BLOCK_KEY)) : (palleteSize == 1 ? REPLACE_BLOCKS_WITH_KEY : (placedBlocks > 1 ? REPLACE_BLOCKS_KEY : REPLACE_BLOCK_KEY));
        BuildingToolMode.sendMessage(player, message, placedBlocks, palleteSize == 1 ? messageState.m_60734_().m_49954_().getString() : "");
        if (placedBlocks > 0) {
            BuildingToolMode.playSound(player, messageState);
        }
    }

    public static abstract class ForCorners
    extends BuildingToolMode {
        private final boolean resetPosesAfterAction;

        public ForCorners(String name, int modelIndex, boolean resetPosesAfterAction) {
            super(name, modelIndex);
            this.resetPosesAfterAction = resetPosesAfterAction;
        }

        public boolean hasAllCorners() {
            return true;
        }

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            this.setPosition(player, clickedPos, stack, true);
        }

        @Override
        public void onRightClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
            this.setPosition(player, clickedPos, stack, true);
        }

        public void setPosition(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            if (!player.m_6144_()) {
                this.setPositionA(player, clickedPos, stack, message);
            } else {
                this.setPositionB(player, clickedPos, stack, message);
            }
        }

        public void setPositionA(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            this.setPos(stack, 0, clickedPos, player, message);
        }

        public void setPositionB(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            this.setPos(stack, 1, clickedPos, player, message);
        }

        @Override
        public void onMiddleClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
            this.clearPoses(stack, player);
        }

        public boolean requiresSelectionLoaded() {
            return true;
        }

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            if (pos0.isPresent() && pos1.isPresent()) {
                if (this.resetPosesAfterAction) {
                    BuildingToolItem.clearPoses(stack);
                }
                if (!this.requiresSelectionLoaded() || level.m_46749_(pos0.get()) && level.m_46749_(pos1.get())) {
                    this.performAction(level, player, clickedPos, stack, pos0.get(), pos1.get());
                } else {
                    ForCorners.sendMessage(player, BuildingToolMode.POS_UNLOADED_KEY, new Object[0]);
                }
                return;
            }
            ArrayList<String> missingPoses = new ArrayList<String>(1);
            if (pos0.isEmpty()) {
                missingPoses.add(Integer.toString(1));
            }
            if (pos1.isEmpty()) {
                missingPoses.add(Integer.toString(2));
            }
            ForCorners.sendMessage(player, BuildingToolMode.MISSING_POS_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[]{"[" + String.join((CharSequence)", ", missingPoses) + "]"});
        }

        protected abstract void performAction(Level var1, Player var2, BlockPos var3, ItemStack var4, BlockPos var5, BlockPos var6);

        @Override
        public Component getHudMessage(ItemStack stack) {
            Optional<BlockPos> p1 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> p2 = BuildingToolItem.getPos(stack, 1);
            if (p1.isPresent() && p2.isPresent()) {
                BoundingBox bounds = BoundingBox.m_162375_((Vec3i)((Vec3i)p1.get()), (Vec3i)((Vec3i)p2.get()));
                return Component.m_237110_((String)BuildingToolMode.SIZE_KEY, (Object[])new Object[]{Component.m_237113_((String)("" + bounds.m_71056_())).m_6270_(SGText.X_LABEL_STYLE), Component.m_237113_((String)("" + bounds.m_71057_())).m_6270_(SGText.Y_LABEL_STYLE), Component.m_237113_((String)("" + bounds.m_71058_())).m_6270_(SGText.Z_LABEL_STYLE)});
            }
            return null;
        }
    }
}

