/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.client.widget.TexturedEditBox;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class PropertyEditBox<T>
extends TexturedEditBox {
    private final ToolModeProperty<T> property;
    private final String prefix;

    public PropertyEditBox(Font font, int x, int y, ToolModeProperty<T> property, String prefix, T currentVal) {
        super(font, x, y, 100, 24, 50, 0, BuildingToolScreen.WIDGETS, property.getNameComponent());
        this.property = property;
        this.prefix = prefix;
        this.m_94144_(property.write(currentVal));
        this.setTextColor(0xCDCDCD, 0xFFFFFF);
        this.m_94199_(100);
    }

    public PropertyEditBox(Font font, int x, int y, ToolModeProperty<T> property, T currentVal) {
        this(font, x, y, property, property.getNameComponent().getString(), currentVal);
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String oldValue = this.m_94155_();
        int color = this.property.canRead(oldValue) ? 0xE0E0E0 : 14703708;
        this.setTextColor(color, color);
        this.m_94144_(this.prefix + ": " + oldValue);
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        this.m_94144_(oldValue);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        ToolModeProperty<T> toolModeProperty;
        if (this.m_198029_() && (toolModeProperty = this.property) instanceof ToolModeProperty.NumberProp) {
            ToolModeProperty.NumberProp numProp = (ToolModeProperty.NumberProp)toolModeProperty;
            boolean up = scroll > 0.0;
            Object val = numProp.read(this.m_94155_());
            if (numProp.getNumberClass() == Integer.class) {
                int scale = Screen.m_96637_() ? 5 : 1;
                Integer newVal = numProp.clamp(((Number)val).intValue() + (up ? scale : -scale));
                if (numProp.isValid(newVal)) {
                    this.m_94144_(numProp.write(newVal));
                }
            } else if (numProp.getNumberClass() == Double.class) {
                double scale = Screen.m_96637_() ? 0.05 : 0.01;
                Double newVal = numProp.clamp(((Number)val).doubleValue() + (up ? scale : -scale));
                if (numProp.isValid(Double.valueOf(newVal))) {
                    this.m_94144_(numProp.write(newVal));
                }
            }
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public ToolModeProperty<T> getProperty() {
        return this.property;
    }

    public void setValue(T val) {
        super.m_94144_(this.property.write(val));
    }
}

