/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.menues;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.items.WandItem;

public class WandMenu
extends AbstractContainerMenu {
    public ItemStack wand;
    public final Inventory playerInventory;
    private final SimpleContainer simplecontainer;

    public WandMenu(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, packetByteBuf.m_130267_());
    }

    public WandMenu(int syncId, Inventory playerInventory, ItemStack _wand) {
        super((MenuType)WandsMod.WAND_CONTAINER.get(), syncId);
        int o;
        this.wand = _wand;
        this.playerInventory = playerInventory;
        ListTag tag = this.wand.m_41784_().m_128437_("Tools", 10);
        this.simplecontainer = new SimpleContainer(9){

            public void m_6596_() {
                WandMenu.this.wand.m_41784_().m_128365_("Tools", (Tag)WandMenu.toTag(this));
                super.m_6596_();
            }
        };
        WandMenu.fromTag(tag, this.simplecontainer);
        int k = 0;
        for (o = 0; o < 9; ++o) {
            this.m_38897_(new Slot((Container)playerInventory, k++, 8 + o * 18, 142));
        }
        for (o = 0; o < 3; ++o) {
            for (int n = 0; n < 9; ++n) {
                this.m_38897_(new Slot((Container)playerInventory, k++, 8 + n * 18, 84 + o * 18));
            }
        }
        for (o = 0; o < 9; ++o) {
            this.m_38897_(new WandSlot((Container)this.simplecontainer, o, 8 + o * 18, 32));
        }
    }

    public boolean m_6875_(Player player) {
        return this.wand.m_41720_() instanceof WandItem;
    }

    boolean mayPlace(ItemStack itemStack) {
        return (itemStack.m_41720_() instanceof DiggerItem || itemStack.m_41720_() instanceof ShearsItem) && !(itemStack.m_41720_() instanceof WandItem);
    }

    boolean insert(ItemStack itemStack, int s, int e) {
        for (int o = s; o < e; ++o) {
            Slot slot = (Slot)this.f_38839_.get(o);
            if (slot.m_6657_() || !this.mayPlace(itemStack)) continue;
            slot.m_5852_(itemStack);
            slot.m_6654_();
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (index >= 0 && index < 36) {
            if (this.insert(slot.m_7993_(), 36, 45)) {
                slot.m_5852_(ItemStack.f_41583_);
            }
        } else if (index >= 36 && index < 45 && this.insert(slot.m_7993_(), 0, 36)) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static ListTag toTag(SimpleContainer inventory) {
        ListTag list = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_("Slot", i);
            ItemStack tool = inventory.m_8020_(i);
            if (tool.m_41619_()) continue;
            stackTag.m_128365_("Tool", (Tag)tool.m_41739_(new CompoundTag()));
            list.add((Object)stackTag);
        }
        return list;
    }

    public static void fromTag(ListTag tag, SimpleContainer inventory) {
        inventory.m_6211_();
        tag.forEach(element -> {
            CompoundTag stackTag = (CompoundTag)element;
            int slot = stackTag.m_128451_("Slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Tool"));
            inventory.m_6836_(slot, stack);
        });
    }

    class WandSlot
    extends Slot {
        public WandSlot(Container container, int i, int j, int k) {
            super(container, i, j, k);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return (itemStack.m_41720_() instanceof DiggerItem || itemStack.m_41720_() instanceof ShearsItem) && !(itemStack.m_41720_() instanceof WandItem);
        }
    }
}

