/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nicguzzo.wands.utils.Compat;
import org.jetbrains.annotations.Nullable;

public class PaletteItem
extends Item {
    public static Component mode_val_random = Compat.translatable("item.wands.random");
    public static Component mode_val_rr = Compat.translatable("item.wands.round_robin");

    public PaletteItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag tag = stack.m_41784_();
        ListTag inventory = tag.m_128437_("Palette", 10);
        int s = inventory.size();
        for (int i = 0; i < s; ++i) {
            CompoundTag stackTag = (CompoundTag)inventory.get(i);
            ItemStack stack2 = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Block"));
            if (stack2.m_41619_()) continue;
            list.add((Component)Compat.translatable(stack2.m_41778_()).m_130940_(ChatFormatting.GREEN));
        }
        PaletteMode mode = PaletteItem.getMode(stack);
        MutableComponent mode_val = mode == PaletteMode.ROUND_ROBIN ? Compat.literal("mode: " + mode_val_rr.getString()) : Compat.literal("mode: " + mode_val_random.getString());
        list.add((Component)mode_val);
        list.add((Component)Compat.literal("rotate: " + (tag.m_128471_("rotate") ? "on" : "off")));
    }

    public static PaletteMode getMode(ItemStack stack) {
        CompoundTag tag;
        int mode;
        if (stack != null && !stack.m_41619_() && (mode = (tag = stack.m_41784_()).m_128451_("mode")) < PaletteMode.values().length) {
            return PaletteMode.values()[mode];
        }
        return PaletteMode.RANDOM;
    }

    public static boolean getRotate(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            return tag.m_128471_("rotate");
        }
        return false;
    }

    public static void toggleRotate(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag;
            boolean rotate = (tag = stack.m_41784_()).m_128471_("rotate");
            tag.m_128379_("rotate", !rotate);
        }
    }

    public static void nextMode(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            int mode = (tag.m_128451_("mode") + 1) % 2;
            tag.m_128405_("mode", mode);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand interactionHand) {
        ItemStack paletteItemStack = player.m_21120_(interactionHand);
        if (!world.m_5776_()) {
            Compat.open_menu((ServerPlayer)player, paletteItemStack, 1);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(interactionHand));
    }

    public static enum PaletteMode {
        RANDOM,
        ROUND_ROBIN;

    }
}

