/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nicguzzo.wands.utils.Compat;
import org.jetbrains.annotations.Nullable;

public class MagicBagItem
extends Item {
    public int tier;
    public int limit = Integer.MAX_VALUE;

    public MagicBagItem(int tier, int limit, Item.Properties properties) {
        super(properties);
        this.tier = tier;
        if (limit > 0) {
            this.limit = limit;
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand interactionHand) {
        ItemStack magic_bag = player.m_21120_(interactionHand);
        if (!world.m_5776_()) {
            Compat.open_menu((ServerPlayer)player, magic_bag, 2);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(interactionHand));
    }

    public static int getTotal(ItemStack bag) {
        if (bag != null && bag.m_41720_() instanceof MagicBagItem) {
            return bag.m_41784_().m_128451_("total");
        }
        return 0;
    }

    public static boolean inc(ItemStack bag, int n) {
        if (bag != null && bag.m_41720_() instanceof MagicBagItem) {
            int lim = ((MagicBagItem)bag.m_41720_()).limit;
            int total = bag.m_41784_().m_128451_("total");
            if (total + n < lim) {
                bag.m_41784_().m_128405_("total", total + n);
                return true;
            }
        }
        return false;
    }

    public static void dec(ItemStack bag, int n) {
        if (bag != null && bag.m_41720_() instanceof MagicBagItem) {
            int total = bag.m_41784_().m_128451_("total");
            if (total - n >= 0) {
                bag.m_41784_().m_128405_("total", total - n);
            } else {
                bag.m_41784_().m_128405_("total", 0);
            }
        }
    }

    public static void setItem(ItemStack bag, ItemStack item) {
        if (bag != null && item != null && bag.m_41720_() instanceof MagicBagItem) {
            ItemStack item2 = item.m_41777_();
            item2.m_41764_(1);
            bag.m_41784_().m_128365_("item", (Tag)item2.m_41739_(new CompoundTag()));
        }
    }

    public static ItemStack getItem(ItemStack bag) {
        if (bag != null && bag.m_41720_() instanceof MagicBagItem) {
            CompoundTag tag = bag.m_41784_();
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        ItemStack i = MagicBagItem.getItem(stack);
        if (i.m_41619_()) {
            list.add((Component)Compat.literal("item: none"));
        } else {
            list.add((Component)Compat.literal("item: ").m_7220_((Component)Compat.translatable(i.m_41778_())));
        }
        list.add((Component)Compat.literal("total: " + MagicBagItem.getTotal(stack)));
    }

    public Component m_7626_(ItemStack itemStack) {
        ItemStack item;
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof MagicBagItem && !(item = MagicBagItem.getItem(itemStack)).m_41619_()) {
            return Compat.literal("Bag of ").m_7220_((Component)Compat.translatable(item.m_41778_())).m_130946_(" - Tier " + (this.tier + 1));
        }
        return super.m_7626_(itemStack);
    }
}

