/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.menues.MagicBagMenu;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.menues.WandMenu;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.PlayerWand;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsMod {
    public static int platform = -1;
    public static final WandsConfig config = WandsConfig.get_instance();
    public static final String MOD_ID = "wands";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean has_opac = false;
    public static boolean has_ftbchunks = false;
    public static boolean has_flan = false;
    public static boolean has_goml = false;
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"wands", (ResourceKey)Registries.f_279569_);
    public static final RegistrySupplier<CreativeModeTab> WANDS_TAB = TABS.register("wands_tab", () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"itemGroup.wands.wands_tab"), () -> new ItemStack((ItemLike)DIAMOND_WAND_ITEM.get())));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"wands", (ResourceKey)Registries.f_256913_);
    public static final DeferredRegister<MenuType<?>> MENUES = DeferredRegister.create((String)"wands", (ResourceKey)Registries.f_256798_);
    public static final RegistrySupplier<Item> STONE_WAND_ITEM = ITEMS.register("stone_wand", () -> new WandItem((Tier)Tiers.STONE, WandsMod.config.stone_wand_limit, false, false, false, false, new Item.Properties().m_41503_(WandsMod.config.stone_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> IRON_WAND_ITEM = ITEMS.register("iron_wand", () -> new WandItem((Tier)Tiers.IRON, WandsMod.config.iron_wand_limit, false, false, false, false, new Item.Properties().m_41503_(WandsMod.config.iron_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> DIAMOND_WAND_ITEM = ITEMS.register("diamond_wand", () -> new WandItem((Tier)Tiers.DIAMOND, WandsMod.config.diamond_wand_limit, true, false, false, false, new Item.Properties().m_41503_(WandsMod.config.diamond_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> NETHERITE_WAND_ITEM = ITEMS.register("netherite_wand", () -> new WandItem((Tier)Tiers.NETHERITE, WandsMod.config.netherite_wand_limit, true, true, false, true, new Item.Properties().m_41486_().m_41503_(WandsMod.config.netherite_wand_durability).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> CREATIVE_WAND_ITEM = ITEMS.register("creative_wand", () -> new WandItem((Tier)Tiers.NETHERITE, WandsMod.config.creative_wand_limit, true, true, true, true, new Item.Properties().m_41486_().m_41487_(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> PALETTE_ITEM = ITEMS.register("palette", () -> new PaletteItem(new Item.Properties().m_41487_(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> MAGIC_BAG_1 = ITEMS.register("magic_bag_1", () -> new MagicBagItem(0, WandsMod.config.magic_bag_1_limit, new Item.Properties().m_41487_(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> MAGIC_BAG_2 = ITEMS.register("magic_bag_2", () -> new MagicBagItem(1, WandsMod.config.magic_bag_2_limit, new Item.Properties().m_41487_(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<Item> MAGIC_BAG_3 = ITEMS.register("magic_bag_3", () -> new MagicBagItem(2, Integer.MAX_VALUE, new Item.Properties().m_41487_(1).arch$tab(WANDS_TAB)));
    public static final RegistrySupplier<MenuType<PaletteMenu>> PALETTE_CONTAINER = MENUES.register("palette_menu", () -> MenuRegistry.ofExtended(PaletteMenu::new));
    public static final RegistrySupplier<MenuType<WandMenu>> WAND_CONTAINER = MENUES.register("wand_menu", () -> MenuRegistry.ofExtended(WandMenu::new));
    public static final RegistrySupplier<MenuType<MagicBagMenu>> MAGIC_WAND_CONTANIER = MENUES.register("magic_bag_menu", () -> MenuRegistry.ofExtended(MagicBagMenu::new));
    public static ResourceLocation KB_PACKET = new ResourceLocation("wands", "key_packet");
    public static ResourceLocation SND_PACKET = new ResourceLocation("wands", "sound_packet");
    public static ResourceLocation PALETTE_PACKET = new ResourceLocation("wands", "palette_packet");
    public static ResourceLocation STATE_PACKET = new ResourceLocation("wands", "state_packet");
    public static ResourceLocation WAND_PACKET = new ResourceLocation("wands", "wand_packet");
    public static ResourceLocation POS_PACKET = new ResourceLocation("wands", "pos_packet");
    public static ResourceLocation CONF_PACKET = new ResourceLocation("wands", "conf_packet");
    public static ResourceLocation GLOBAL_SETTINGS_PACKET = new ResourceLocation("wands", "global_settings_packet");
    public static boolean is_forge = false;

    public static void init() {
        ITEMS.register();
        MENUES.register();
        TABS.register();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)KB_PACKET, (packet, context) -> {
            int key = packet.readInt();
            boolean shift = packet.readBoolean();
            boolean alt = packet.readBoolean();
            context.queue(() -> WandsMod.process_keys(context.getPlayer(), key, shift, alt));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PALETTE_PACKET, (packet, context) -> {
            boolean mode = packet.readBoolean();
            boolean rotate = packet.readBoolean();
            context.queue(() -> WandsMod.process_palette(context.getPlayer(), mode, rotate));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)WAND_PACKET, (packet, context) -> {
            ItemStack item = packet.m_130267_();
            context.queue(() -> {
                ItemStack wand_stack = context.getPlayer().m_21205_();
                CompoundTag tag = item.m_41783_();
                if (tag != null) {
                    wand_stack.m_41751_(tag);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)POS_PACKET, (packet, context) -> {
            Player player = context.getPlayer();
            if (player == null) {
                LOGGER.error("player is null");
                return;
            }
            Level level = Compat.player_level(player);
            ItemStack stack = context.getPlayer().m_21205_();
            if (!WandUtils.is_wand(stack)) {
                LOGGER.error("player doesn't have a wand in main hand");
                return;
            }
            Wand wand = PlayerWand.get(player);
            if (wand == null) {
                LOGGER.error("wand is null");
                return;
            }
            int d = packet.readInt();
            Direction side = Direction.values()[d];
            if (!packet.readBoolean()) {
                Object p1 = null;
                LOGGER.info("needs at least 1 position");
                return;
            }
            BlockPos p1 = packet.m_130135_();
            BlockPos p2 = packet.readBoolean() ? packet.m_130135_() : null;
            double hit_x = packet.readDouble();
            double hit_y = packet.readDouble();
            double hit_z = packet.readDouble();
            long seed = packet.readLong();
            Vec3 hit = new Vec3(hit_x, hit_y, hit_z);
            context.queue(() -> {
                BlockPos pos;
                BlockState block_state;
                if (p2 != null) {
                    block_state = level.m_8055_(p2);
                    pos = p2;
                } else {
                    block_state = level.m_8055_(p1);
                    pos = p1;
                }
                wand.setP1(p1);
                wand.setP2(p2);
                wand.palette.seed = seed;
                wand.do_or_preview(player, level, block_state, pos, side, hit, stack, (WandItem)stack.m_41720_(), true);
                wand.clear();
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)GLOBAL_SETTINGS_PACKET, (packet, context) -> {
            boolean drop_pos = packet.readBoolean();
            context.queue(() -> {
                Wand wand;
                Player player = context.getPlayer();
                if (player != null && (wand = PlayerWand.get(player)) != null) {
                    wand.drop_on_player = drop_pos;
                }
            });
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            LOGGER.info("PLAYER_JOIN");
            Wand wand = null;
            wand = PlayerWand.get((Player)player);
            if (wand == null) {
                PlayerWand.add_player((Player)player);
                wand = PlayerWand.get((Player)player);
            }
            if (!Compat.player_level((Player)player).m_5776_() && config != null) {
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeFloat(WandsMod.config.blocks_per_xp);
                packet.writeBoolean(WandsMod.config.destroy_in_survival_drop);
                packet.writeBoolean(WandsMod.config.survival_unenchanted_drops);
                packet.writeBoolean(WandsMod.config.allow_wand_to_break);
                packet.writeBoolean(WandsMod.config.allow_offhand_to_break);
                packet.writeBoolean(WandsMod.config.mend_tools);
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CONF_PACKET, (FriendlyByteBuf)packet);
                LOGGER.info("config sent");
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> PlayerWand.remove_player((Player)player));
    }

    public static void send_state(ServerPlayer player, Wand wand) {
        ItemStack wand_stack;
        if (wand != null && player != null && !Compat.player_level((Player)player).m_5776_() && (wand_stack = player.m_21205_()).m_41720_() instanceof WandItem) {
            WandProps.Mode mode = WandProps.getMode(wand_stack);
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            int slot = 0;
            if (wand.palette.palette_slots.size() != 0) {
                slot = (wand.palette.slot + 1) % wand.palette.palette_slots.size();
            }
            float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
            packet.writeInt(mode.ordinal());
            packet.writeInt(slot);
            packet.writeBoolean(BLOCKS_PER_XP != 0.0f);
            packet.writeInt(player.f_36078_);
            packet.writeFloat(player.f_36080_);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)STATE_PACKET, (FriendlyByteBuf)packet);
        }
    }

    public static void process_palette(Player player, boolean mode, boolean rotate) {
        ItemStack item_stack = player.m_21205_();
        ItemStack palette = null;
        if (!item_stack.m_41619_() && item_stack.m_41720_() instanceof PaletteItem) {
            palette = item_stack;
        } else {
            ItemStack offhand_stack = player.m_21206_();
            if (!offhand_stack.m_41619_() && offhand_stack.m_41720_() instanceof PaletteItem) {
                palette = offhand_stack;
            }
        }
        if (palette != null) {
            if (mode) {
                PaletteItem.nextMode(palette);
            }
            if (rotate) {
                PaletteItem.toggleRotate(palette);
            }
        }
    }

    public static void process_keys(Player player, int key, boolean shift, boolean alt) {
        Wand wand;
        ItemStack main_stack = player.m_21205_();
        ItemStack offhand_stack = player.m_21206_();
        boolean is_wand = main_stack.m_41720_() instanceof WandItem;
        boolean is_palette = main_stack.m_41720_() instanceof PaletteItem || offhand_stack.m_41720_() instanceof PaletteItem;
        boolean creative = Compat.is_creative(player);
        if (is_palette && key >= 0 && key < WandKeys.values().length) {
            switch (WandKeys.values()[key].ordinal()) {
                case 17: {
                    if (offhand_stack.m_41720_() instanceof PaletteItem) {
                        Compat.open_menu((ServerPlayer)player, offhand_stack, 1);
                        break;
                    }
                    ItemStack mainhand_stack = player.m_21205_();
                    if (!(mainhand_stack.m_41720_() instanceof PaletteItem)) break;
                    Compat.open_menu((ServerPlayer)player, mainhand_stack, 1);
                    break;
                }
                case 16: {
                    if (offhand_stack.m_41619_() || !(offhand_stack.m_41720_() instanceof PaletteItem)) break;
                    PaletteItem.nextMode(offhand_stack);
                    player.m_5661_((Component)Compat.literal("Palette mode: " + String.valueOf((Object)PaletteItem.getMode(offhand_stack))), false);
                }
            }
        }
        if (is_wand) {
            int inc;
            wand = PlayerWand.get(player);
            WandItem wand_item = (WandItem)main_stack.m_41720_();
            if (wand == null) {
                return;
            }
            WandProps.Mode mode = WandProps.getMode(main_stack);
            int n = inc = shift ? 10 : 1;
            if (key >= 0 && key < WandKeys.values().length) {
                block4 : switch (WandKeys.values()[key].ordinal()) {
                    case 15: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INCSELBLOCK);
                        break;
                    }
                    case 14: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.DIAGSPREAD);
                        break;
                    }
                    case 13: {
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        WandProps.toggleFlag(main_stack, WandProps.Flag.STAIRSLAB);
                        break;
                    }
                    case 11: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.incGrid(main_stack, WandProps.Value.GRIDN, inc, wand_item.limit);
                        break;
                    }
                    case 12: {
                        if (mode != WandProps.Mode.GRID) break;
                        WandProps.decVal(main_stack, WandProps.Value.GRIDN, inc);
                        break;
                    }
                    case 9: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.incVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.incVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.incGrid(main_stack, WandProps.Value.GRIDM, inc, wand_item.limit);
                                break;
                            }
                            case AREA: {
                                WandProps.incVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (mode) {
                            case DIRECTION: {
                                WandProps.decVal(main_stack, WandProps.Value.MULTIPLIER, inc);
                                break;
                            }
                            case ROW_COL: {
                                WandProps.decVal(main_stack, WandProps.Value.ROWCOLLIM, inc);
                                break;
                            }
                            case GRID: {
                                WandProps.decVal(main_stack, WandProps.Value.GRIDM, inc);
                                break;
                            }
                            case AREA: {
                                WandProps.decVal(main_stack, WandProps.Value.AREALIM, inc);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (shift) {
                            WandProps.prevAction(main_stack);
                        } else {
                            WandProps.nextAction(main_stack);
                        }
                        player.m_5661_((Component)Compat.literal("Wand Action: ").m_7220_((Component)Compat.translatable(WandProps.getAction(main_stack).toString())), false);
                        break;
                    }
                    case 0: {
                        Compat.open_menu((ServerPlayer)player, main_stack, 0);
                        break;
                    }
                    case 1: {
                        if (shift) {
                            WandProps.prevMode(main_stack, wand_item.can_blast);
                            break;
                        }
                        WandProps.nextMode(main_stack, wand_item.can_blast);
                        break;
                    }
                    case 3: {
                        switch (mode) {
                            case CIRCLE: 
                            case FILL: {
                                WandProps.nextPlane(main_stack);
                                player.m_5661_((Component)Compat.literal("Wand Plane: " + String.valueOf((Object)WandProps.getPlane(main_stack))), false);
                                WandsMod.send_state((ServerPlayer)player, wand);
                                break block4;
                            }
                            case DIRECTION: 
                            case PASTE: {
                                break block4;
                            }
                        }
                        WandProps.nextOrientation(main_stack);
                        player.m_5661_((Component)Compat.literal("Wand Orientation: ").m_7220_((Component)Compat.translatable(WandProps.getOrientation(main_stack).toString())), false);
                        break;
                    }
                    case 5: {
                        WandProps.toggleFlag(main_stack, WandProps.Flag.INVERTED);
                        player.m_5661_((Component)Compat.literal("Wand inverted: " + WandProps.getFlag(main_stack, WandProps.Flag.INVERTED)), false);
                        break;
                    }
                    case 6: {
                        switch (wand.mode) {
                            case FILL: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.RFILLED);
                                player.m_5661_((Component)Compat.literal("Wand fill rect: " + WandProps.getFlag(main_stack, WandProps.Flag.RFILLED)), false);
                                break;
                            }
                            case CIRCLE: {
                                WandProps.toggleFlag(main_stack, WandProps.Flag.CFILLED);
                                player.m_5661_((Component)Compat.literal("Wand circle fill: " + WandProps.getFlag(main_stack, WandProps.Flag.CFILLED)), false);
                            }
                        }
                        break;
                    }
                    case 7: {
                        WandProps.nextRotation(main_stack);
                        WandProps.setStateMode(main_stack, WandProps.StateMode.APPLY);
                        break;
                    }
                    case 4: {
                        if (!creative || Compat.player_level(player).m_5776_() || wand == null) break;
                        int n2 = 1;
                        if (alt) {
                            n2 = 10;
                        }
                        if (shift) {
                            wand.redo(n2);
                            break;
                        }
                        wand.undo(n2);
                        break;
                    }
                    case 18: {
                        if (wand != null) {
                            wand.clear();
                        }
                        if (player == null) break;
                        player.m_5661_((Component)Compat.literal("wand cleared"), false);
                    }
                }
            }
        }
        if (!main_stack.m_41619_() && main_stack.m_41720_() instanceof PaletteItem && key >= 0 && key < WandKeys.values().length && Objects.requireNonNull(WandKeys.values()[key]) == WandKeys.PALETTE_MODE) {
            PaletteItem.nextMode(main_stack);
            player.m_5661_((Component)Compat.literal("Palette mode: " + String.valueOf((Object)PaletteItem.getMode(main_stack))), false);
        }
        if (is_wand && key < 0) {
            wand = null;
            if (!Compat.player_level(player).m_5776_() && (wand = PlayerWand.get(player)) == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
            }
            if (wand != null) {
                wand.is_alt_pressed = alt;
                wand.is_shift_pressed = shift;
            }
        }
    }

    public static void log(String s, boolean b) {
        if (b) {
            LOGGER.info(s);
        }
    }

    public static enum WandKeys {
        MENU,
        MODE,
        ACTION,
        ORIENTATION,
        UNDO,
        INVERT,
        FILL,
        ROTATE,
        CONF,
        M_INC,
        M_DEC,
        N_INC,
        N_DEC,
        TOGGLE_STAIRSLAB,
        DIAGONAL_SPREAD,
        INC_SEL_BLK,
        PALETTE_MODE,
        PALETTE_MENU,
        CLEAR;

    }
}

