/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.datatypes;

import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketSendPasteBatches;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class PasteData {
    private final int totalChunks;
    private final Map<Integer, FriendlyByteBuf> receivedChunks = new HashMap<Integer, FriendlyByteBuf>();

    public PasteData(int totalChunks) {
        this.totalChunks = totalChunks;
    }

    public boolean isComplete() {
        return this.receivedChunks.size() == this.totalChunks;
    }

    public void addChunk(int position, FriendlyByteBuf chunk) {
        this.receivedChunks.put(position, chunk);
    }

    public FriendlyByteBuf assembleData() {
        FriendlyByteBuf fullData = new FriendlyByteBuf(Unpooled.buffer());
        for (int i = 0; i < this.totalChunks; ++i) {
            fullData.writeBytes((ByteBuf)this.receivedChunks.get(i));
        }
        return fullData;
    }

    public static List<FriendlyByteBuf> splitBuffer(FriendlyByteBuf buffer, int chunkSize) {
        ArrayList<FriendlyByteBuf> chunks = new ArrayList<FriendlyByteBuf>();
        while (buffer.readableBytes() > 0) {
            int size = Math.min(buffer.readableBytes(), chunkSize);
            FriendlyByteBuf chunkBuffer = new FriendlyByteBuf(Unpooled.buffer((int)size));
            buffer.readBytes((ByteBuf)chunkBuffer, size);
            chunks.add(chunkBuffer);
        }
        return chunks;
    }

    public static void sendCompoundTag(CompoundTag tag) {
        FriendlyByteBuf fullBuffer = new FriendlyByteBuf(Unpooled.buffer());
        fullBuffer.m_130079_(tag);
        List<FriendlyByteBuf> chunks = PasteData.splitBuffer(fullBuffer, 30000);
        UUID copyUUID = UUID.randomUUID();
        for (int i = 0; i < chunks.size(); ++i) {
            PacketSendPasteBatches packet = new PacketSendPasteBatches(copyUUID, chunks.size(), i, chunks.get(i));
            PacketHandler.sendToServer(packet);
        }
    }
}

