/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.network.packet;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.stopMaster.StopMasterBlockEntity;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateStopMasterC2SPacket {
    public final int toggledChannel;
    public final String newMapping;
    public final BlockPos pos;

    public static UpdateStopMasterC2SPacket createPacket(int toggledChannel, String newMapping, BlockPos pos) {
        return new UpdateStopMasterC2SPacket(toggledChannel, newMapping, pos);
    }

    protected UpdateStopMasterC2SPacket(int toggledChannel, String newMapping, BlockPos pos) {
        this.toggledChannel = toggledChannel;
        this.newMapping = newMapping;
        this.pos = pos;
    }

    public static UpdateStopMasterC2SPacket decodePacket(FriendlyByteBuf buf) {
        try {
            int channels = buf.readInt();
            int length = buf.readInt();
            byte[] receivedBytes = new byte[length];
            buf.readBytes(receivedBytes);
            String mapping = new String(receivedBytes, StandardCharsets.UTF_8);
            PipeOrgans.LOGGER.info(mapping);
            BlockPos pos = buf.m_130135_();
            return new UpdateStopMasterC2SPacket(channels, mapping, pos);
        }
        catch (IndexOutOfBoundsException e) {
            PipeOrgans.LOGGER.error("MidiMessagePacket did not contain enough bytes: {}", (Object)String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(UpdateStopMasterC2SPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.toggledChannel);
        byte[] mappingArray = packet.newMapping.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(mappingArray.length);
        buf.writeBytes(mappingArray);
        buf.m_130064_(packet.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            BlockEntity patt2609$temp = level.m_7702_(this.pos);
            if (patt2609$temp instanceof StopMasterBlockEntity) {
                StopMasterBlockEntity sm = (StopMasterBlockEntity)patt2609$temp;
                sm.toggleChannel(this.toggledChannel);
                sm.setMapping(this.newMapping);
            }
        });
    }
}

