/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.network.packet;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlockEntity;
import com.finchy.pipeorgans.midi.server.MidiMessageServerObject;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MidiMessageC2SPacket {
    public final Byte channel;
    public final Byte note;
    public final Byte velocity;
    public final UUID player;
    public final BlockPos pos;

    public static MidiMessageC2SPacket createNotePacket(Byte channel, Byte note, Byte velocity, UUID player, BlockPos pos) {
        return new MidiMessageC2SPacket(channel, note, velocity, player, pos);
    }

    protected MidiMessageC2SPacket(Byte channel, Byte note, Byte velocity, UUID player, BlockPos pos) {
        this.channel = channel;
        this.note = note;
        this.velocity = velocity;
        this.player = player;
        this.pos = pos;
    }

    public static MidiMessageC2SPacket decodePacket(FriendlyByteBuf buf) {
        try {
            byte channel = buf.readByte();
            byte note = buf.readByte();
            byte velocity = buf.readByte();
            UUID player = buf.m_130259_();
            BlockPos pos = buf.m_130135_();
            return new MidiMessageC2SPacket(channel, note, velocity, player, pos);
        }
        catch (IndexOutOfBoundsException e) {
            PipeOrgans.LOGGER.error("MidiMessagePacket did not contain enough bytes: {}", (Object)String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(MidiMessageC2SPacket packet, FriendlyByteBuf buf) {
        buf.writeByte((int)packet.channel.byteValue());
        buf.writeByte((int)packet.note.byteValue());
        buf.writeByte((int)packet.velocity.byteValue());
        buf.m_130077_(packet.player);
        buf.m_130064_(packet.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            KeyboardRelayBlockEntity kbr;
            BlockEntity patt2626$temp;
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            BlockPos pos = KeyboardRelayBlockEntity.playerUsingKBRPos((Player)player);
            if (pos != null && (patt2626$temp = level.m_7702_(pos)) instanceof KeyboardRelayBlockEntity && (kbr = (KeyboardRelayBlockEntity)patt2626$temp).isUsedBy((Player)player)) {
                kbr.handleMidiObject(new MidiMessageServerObject(this.channel.byteValue(), this.note.byteValue(), this.velocity.byteValue()));
            }
        });
    }
}

