/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FramingRecipe
extends CustomRecipe {
    public static final RecipeSerializer<FramingRecipe> SERIALIZER = new Serializer();
    final Ingredient ingredient;
    final boolean includeFront;

    public FramingRecipe(ResourceLocation idIn, Ingredient ingredient, boolean includeFront) {
        super(idIn, CraftingBookCategory.MISC);
        this.ingredient = ingredient;
        this.includeFront = includeFront;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return !this.assemble(inv, null).m_41619_();
    }

    private static CompoundTag materialNbt(ItemStack stack) {
        if (stack.m_41613_() != 1) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
        }
        return stack.m_41739_(new CompoundTag());
    }

    public ItemStack assemble(CraftingContainer inv, @Nullable RegistryAccess access) {
        int drawerIndex = -1;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!this.ingredient.test(inv.m_8020_(i))) continue;
            if (drawerIndex == -1) {
                drawerIndex = i;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (drawerIndex == -1) {
            return ItemStack.f_41583_;
        }
        int drawerX = drawerIndex % inv.m_39347_();
        int drawerY = drawerIndex / inv.m_39346_();
        if (drawerX < 1 || drawerY < 1) {
            return ItemStack.f_41583_;
        }
        int sideSlot = (drawerY - 1) * inv.m_39346_() + drawerX - 1;
        int trimSlot = (drawerY - 1) * inv.m_39346_() + drawerX;
        int frontSlot = drawerY * inv.m_39346_() + drawerX - 1;
        IntOpenHashSet applicable = new IntOpenHashSet(new int[]{drawerIndex, sideSlot, trimSlot, frontSlot});
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (applicable.contains(i) || inv.m_8020_(i).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        ItemStack sideStack = inv.m_8020_(sideSlot);
        if (sideStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack frontStack = inv.m_8020_(frontSlot);
        if (!this.includeFront && !frontStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack trimStack = inv.m_8020_(trimSlot);
        ItemStack out = inv.m_8020_(drawerIndex).m_41777_();
        out.m_41764_(1);
        CompoundTag tag = out.m_41784_();
        tag.m_128365_("MatS", (Tag)FramingRecipe.materialNbt(sideStack));
        tag.m_128365_("MatT", (Tag)FramingRecipe.materialNbt(trimStack));
        if (this.includeFront) {
            tag.m_128365_("MatF", (Tag)FramingRecipe.materialNbt(frontStack));
        }
        return out;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<FramingRecipe> {
        public FramingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new FramingRecipe(recipeId, Ingredient.m_43917_((JsonElement)json.get("ingredient")), json.has("includeFront") && json.get("includeFront").getAsBoolean());
        }

        public FramingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new FramingRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buffer, FramingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.writeBoolean(recipe.includeFront);
        }
    }
}

