/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.block;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.storagedrawers.client.renderer.BlockEntityDrawersRenderer;
import eutros.framedcompactdrawers.block.BlockCompDrawersCustom;
import eutros.framedcompactdrawers.block.BlockControllerCustom;
import eutros.framedcompactdrawers.block.BlockDrawersStandardCustom;
import eutros.framedcompactdrawers.block.BlockSlaveCustom;
import eutros.framedcompactdrawers.block.BlockTrimCustom;
import eutros.framedcompactdrawers.block.tile.TileCompDrawersCustom;
import eutros.framedcompactdrawers.block.tile.TileControllerCustom;
import eutros.framedcompactdrawers.block.tile.TileDrawersStandardCustom;
import eutros.framedcompactdrawers.block.tile.TileSlaveCustom;
import eutros.framedcompactdrawers.block.tile.TileTrimCustom;
import eutros.framedcompactdrawers.item.ItemDrawersCustom;
import eutros.framedcompactdrawers.item.ItemOtherCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class ModBlocks {
    public static BlockCompDrawersCustom framedCompactDrawer;
    public static BlockControllerCustom framedDrawerController;
    public static BlockSlaveCustom framedSlave;
    public static BlockTrimCustom framedTrim;
    public static BlockDrawersStandardCustom framedFullOne;
    public static BlockDrawersStandardCustom framedFullTwo;
    public static BlockDrawersStandardCustom framedFullFour;
    public static BlockDrawersStandardCustom framedHalfOne;
    public static BlockDrawersStandardCustom framedHalfTwo;
    public static BlockDrawersStandardCustom framedHalfFour;

    public static void registerBlocks(RegisterEvent event) {
        if (!Registries.f_256747_.equals(event.getRegistryKey())) {
            return;
        }
        IForgeRegistry r = ForgeRegistries.BLOCKS;
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 4.0f).m_60918_(SoundType.f_56736_).m_60960_((_1, _2, _3) -> false).m_60924_((_1, _2, _3) -> false).m_60955_();
        framedCompactDrawer = new BlockCompDrawersCustom(properties);
        r.register(ModBlocks.res("framed_compact_drawer"), (Object)framedCompactDrawer);
        framedDrawerController = new BlockControllerCustom(properties);
        r.register(ModBlocks.res("framed_drawer_controller"), (Object)framedDrawerController);
        framedSlave = new BlockSlaveCustom(properties);
        r.register(ModBlocks.res("framed_slave"), (Object)framedSlave);
        framedTrim = new BlockTrimCustom(properties);
        r.register(ModBlocks.res("framed_trim"), (Object)framedTrim);
        framedFullOne = new BlockDrawersStandardCustom(1, false, properties);
        r.register(ModBlocks.res("framed_full_one"), (Object)framedFullOne);
        framedFullTwo = new BlockDrawersStandardCustom(2, false, properties);
        r.register(ModBlocks.res("framed_full_two"), (Object)framedFullTwo);
        framedFullFour = new BlockDrawersStandardCustom(4, false, properties);
        r.register(ModBlocks.res("framed_full_four"), (Object)framedFullFour);
        framedHalfOne = new BlockDrawersStandardCustom(1, true, properties);
        r.register(ModBlocks.res("framed_half_one"), (Object)framedHalfOne);
        framedHalfTwo = new BlockDrawersStandardCustom(2, true, properties);
        r.register(ModBlocks.res("framed_half_two"), (Object)framedHalfTwo);
        framedHalfFour = new BlockDrawersStandardCustom(4, true, properties);
        r.register(ModBlocks.res("framed_half_four"), (Object)framedHalfFour);
    }

    public static void registerItems(RegisterEvent event) {
        if (!Registries.f_256913_.equals(event.getRegistryKey())) {
            return;
        }
        IForgeRegistry r = ForgeRegistries.ITEMS;
        Item.Properties properties = new Item.Properties();
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedCompactDrawer), (Object)new ItemDrawersCustom((Block)framedCompactDrawer, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedDrawerController), (Object)new ItemOtherCustom((Block)framedDrawerController, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedSlave), (Object)new ItemOtherCustom((Block)framedSlave, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedTrim), (Object)new ItemOtherCustom((Block)framedTrim, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedFullOne), (Object)new ItemDrawersCustom((Block)framedFullOne, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedFullTwo), (Object)new ItemDrawersCustom((Block)framedFullTwo, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedFullFour), (Object)new ItemDrawersCustom((Block)framedFullFour, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedHalfOne), (Object)new ItemDrawersCustom((Block)framedHalfOne, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedHalfTwo), (Object)new ItemDrawersCustom((Block)framedHalfTwo, properties));
        r.register(ForgeRegistries.BLOCKS.getKey((Object)framedHalfFour), (Object)new ItemDrawersCustom((Block)framedHalfFour, properties));
    }

    public static void registerCreativeTab(RegisterEvent event) {
        event.register(Registries.f_279569_, helper -> helper.register(ModBlocks.res("framedcompactdrawers"), (Object)CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)framedCompactDrawer)).m_257941_((Component)Component.m_237115_((String)"itemGroup.framed_compacting_drawers")).m_257501_((params, output) -> ModBlocks.fill(output)).m_257652_()));
    }

    @NotNull
    private static ResourceLocation res(String name) {
        return new ResourceLocation("framedcompactdrawers", name);
    }

    public static void setGeometryData() {
        framedCompactDrawer.setGeometryData();
        for (BlockDrawersStandardCustom bdsc : new BlockDrawersStandardCustom[]{framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            bdsc.setGeometryData();
        }
    }

    public static void fill(CreativeModeTab.Output out) {
        for (Block block : new Block[]{framedCompactDrawer, framedDrawerController, framedSlave, framedTrim, framedFullOne, framedFullTwo, framedFullFour, framedHalfOne, framedHalfTwo, framedHalfFour}) {
            out.m_246326_((ItemLike)block);
        }
    }

    public static class Tile {
        public static BlockEntityType<TileCompDrawersCustom.Slot3> fractionalDrawers3;
        public static BlockEntityType<TileControllerCustom> controllerCustom;
        public static BlockEntityType<TileSlaveCustom> slaveCustom;
        public static BlockEntityType<TileTrimCustom> trimCustom;
        public static BlockEntityType<TileDrawersStandardCustom.Slot1> standardDrawers1;
        public static BlockEntityType<TileDrawersStandardCustom.Slot2> standardDrawers2;
        public static BlockEntityType<TileDrawersStandardCustom.Slot4> standardDrawers4;

        @SubscribeEvent
        public void registerTiles(RegisterEvent evt) {
            if (!Registries.f_256922_.equals(evt.getRegistryKey())) {
                return;
            }
            IForgeRegistry r = ForgeRegistries.BLOCK_ENTITY_TYPES;
            fractionalDrawers3 = this.registerTile(r, TileCompDrawersCustom.Slot3::new, new Block[]{framedCompactDrawer});
            controllerCustom = this.registerTile(r, TileControllerCustom::new, new Block[]{framedDrawerController});
            slaveCustom = this.registerTile(r, TileSlaveCustom::new, new Block[]{framedSlave});
            trimCustom = this.registerTile(r, TileTrimCustom::new, new Block[]{framedTrim});
            standardDrawers1 = this.registerTile(r, TileDrawersStandardCustom.Slot1::new, new Block[]{framedFullOne, framedHalfOne});
            standardDrawers2 = this.registerTile(r, TileDrawersStandardCustom.Slot2::new, new Block[]{framedFullTwo, framedHalfTwo});
            standardDrawers4 = this.registerTile(r, TileDrawersStandardCustom.Slot4::new, new Block[]{framedFullFour, framedHalfFour});
        }

        private <T extends BlockEntity> BlockEntityType<T> registerTile(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.BlockEntitySupplier<T> supplier, Block ... blocks) {
            BlockEntityType type = BlockEntityType.Builder.m_155273_(supplier, (Block[])blocks).m_58966_(null);
            registry.register(ForgeRegistries.BLOCKS.getKey((Object)blocks[0]), (Object)type);
            return type;
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerTERs(EntityRenderersEvent.RegisterRenderers evt) {
            for (BlockEntityType drawer : ImmutableList.of(fractionalDrawers3, standardDrawers1, standardDrawers2, standardDrawers4)) {
                evt.registerBlockEntityRenderer(drawer, BlockEntityDrawersRenderer::new);
            }
        }
    }
}

