/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DefaultGridBalanceHandler
implements GridBalanceHandler<AbstractContainerMenu> {
    @Override
    public void balanceGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
            ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
            if (itemStack.m_41619_() || itemStack.m_41741_() <= 1) continue;
            ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            Object key = Objects.toString(registryName);
            if (itemStack.m_41783_() != null) {
                key = (String)key + "@" + String.valueOf(itemStack.m_41783_());
            }
            itemMap.put(key, (Object)itemStack);
            itemCount.add(key, itemStack.m_41613_());
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (ItemStack itemStack : balanceList) {
                itemStack.m_41764_(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack itemStack;
                itemStack = (ItemStack)balanceList.get(idx);
                if (itemStack.m_41613_() < itemStack.m_41741_()) {
                    itemStack.m_41769_(1);
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        menu.m_38946_();
    }

    @Override
    public void spreadGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
        boolean emptyBiggestSlot;
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        do {
            ItemStack biggestSlotStack = null;
            int biggestSlotSize = 1;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                if (itemStack.m_41619_() || itemStack.m_41613_() <= biggestSlotSize) continue;
                biggestSlotStack = itemStack;
                biggestSlotSize = itemStack.m_41613_();
            }
            if (biggestSlotStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.f_38839_.get(i)).m_150661_();
                ItemStack itemStack = craftMatrix.m_8020_(slotIndex);
                if (!itemStack.m_41619_()) continue;
                if (biggestSlotStack.m_41613_() > 1) {
                    craftMatrix.m_6836_(slotIndex, biggestSlotStack.m_41620_(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceGrid(grid, player, menu);
    }
}

