/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.RotationMirror;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import com.minecolonies.api.colony.buildingextensions.plantation.IPlantationModule;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.tileentities.AbstractTileEntityPlantationField;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPlantationField
extends AbstractTileEntityPlantationField {
    private final Map<String, List<BlockPos>> workingPositions = new HashMap<String, List<BlockPos>>();
    private String schematicName = "";
    private String schematicPath = "";
    private String packName = "";
    private BlockPos corner1 = BlockPos.f_121853_;
    private BlockPos corner2 = BlockPos.f_121853_;
    private RotationMirror rotMir = RotationMirror.NONE;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private IColony currentColony;
    private Set<BuildingExtensionRegistries.BuildingExtensionEntry> plantationFieldTypes;

    public TileEntityPlantationField(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityPlantationField>)((BlockEntityType)MinecoloniesTileEntities.PLANTATION_FIELD.get()), pos, state);
    }

    @Override
    public Set<BuildingExtensionRegistries.BuildingExtensionEntry> getPlantationFieldTypes() {
        if (this.plantationFieldTypes == null) {
            this.plantationFieldTypes = this.tagPosMap.values().stream().flatMap(Collection::stream).map(this::getPlantationFieldEntryFromFieldTag).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return this.plantationFieldTypes;
    }

    @Override
    public List<BlockPos> getWorkingPositions(String tag) {
        this.workingPositions.computeIfAbsent(tag, newTag -> this.tagPosMap.entrySet().stream().filter(f -> ((List)f.getValue()).contains(newTag)).distinct().map(Map.Entry::getKey).map(arg_0 -> ((BlockPos)this.f_58858_).m_121955_(arg_0)).toList());
        return this.workingPositions.get(tag);
    }

    @Override
    public IColony getCurrentColony() {
        if (this.currentColony == null && this.f_58857_ != null) {
            this.currentColony = IColonyManager.getInstance().getIColony(this.f_58857_, this.f_58858_);
        }
        return this.currentColony;
    }

    @Override
    @Nullable
    public ResourceKey<Level> getDimension() {
        IColony colony = this.getCurrentColony();
        if (colony != null) {
            return colony.getDimension();
        }
        return null;
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public Rotation getRotation() {
        return this.rotMir.rotation();
    }

    @Override
    public boolean getMirror() {
        return this.rotMir.isMirrored();
    }

    private BuildingExtensionRegistries.BuildingExtensionEntry getPlantationFieldEntryFromFieldTag(String fieldTag) {
        return BuildingExtensionRegistries.getBuildingExtensionRegistry().getValues().stream().filter(fieldEntry -> {
            List<IPlantationModule> modules = fieldEntry.getExtensionModuleProducers().stream().map(m -> (IBuildingExtensionModule)m.apply(null)).filter(IPlantationModule.class::isInstance).map(m -> (IPlantationModule)m).toList();
            return modules.stream().anyMatch(module -> module.getFieldTag().equals(fieldTag));
        }).findFirst().orElse(null);
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String s) {
        this.schematicName = s;
        this.m_6596_();
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.m_6596_();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.f_121853_ || this.corner2 == BlockPos.f_121853_) {
            return new Tuple((Object)this.f_58858_, (Object)this.f_58858_);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
        this.m_6596_();
    }

    public void readSchematicDataFromNBT(CompoundTag compound) {
        super.readSchematicDataFromNBT(compound);
        CompoundTag blueprintDataProvider = compound.m_128469_("blueprintDataProvider");
        if (compound.m_128441_("pack")) {
            String path = blueprintDataProvider.m_128461_("name");
            this.schematicPath = path + File.separator + this.schematicName + ".blueprint";
        } else {
            String[] split;
            if (compound.m_128441_("name")) {
                this.schematicPath = compound.m_128461_("name");
                split = Utils.splitPath(this.schematicPath);
                this.schematicName = split[split.length - 1].replace(".blueprint", "");
            }
            if ((split = Utils.splitPath(this.schematicPath)).length >= 4) {
                this.packName = BlueprintMapping.getStyleMapping(split[2]);
            }
            if (this.packName == null || this.packName.isEmpty()) {
                this.packName = "Colonial";
            }
            if (this.schematicName.contains("/") || this.schematicName.contains("\\")) {
                String[] splitName = Utils.splitPath(this.schematicPath);
                this.schematicName = splitName[splitName.length - 1].replace(".blueprint", "");
            }
            this.schematicPath = StructurePacks.hasPack((String)this.packName) ? StructurePacks.getStructurePack((String)this.packName).getSubPath(StructurePacks.findBlueprint((String)this.packName, (String)this.schematicName)) : this.schematicName;
            if (!this.schematicPath.endsWith(".blueprint")) {
                this.schematicPath = this.schematicPath + ".blueprint";
            }
        }
        if (blueprintDataProvider.m_128441_("pack")) {
            this.packName = blueprintDataProvider.m_128461_("pack");
        }
        if (this.packName == null) {
            this.packName = "Colonial";
        }
    }

    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    public void rotate(Rotation rotationIn) {
        this.rotMir = this.rotMir.rotate(rotationIn);
    }

    public void mirror(Mirror mirror) {
        this.rotMir = this.rotMir.mirrorate(mirror);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        super.readSchematicDataFromNBT(compound);
        this.rotMir = RotationMirror.of((Rotation)Rotation.values()[compound.m_128451_("rotation")], (Mirror)(compound.m_128471_("mirror") ? Mirror.FRONT_BACK : Mirror.NONE));
        if (compound.m_128441_("path")) {
            this.schematicPath = compound.m_128461_("path");
        }
        if (compound.m_128441_("name")) {
            this.schematicName = compound.m_128461_("name");
            if (this.schematicPath == null || this.schematicPath.isEmpty()) {
                this.schematicPath = this.schematicName;
                this.schematicName = "";
            }
        }
        this.packName = compound.m_128461_("pack");
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSchematicDataToNBT(compound);
        compound.m_128405_("rotation", this.rotMir.rotation().ordinal());
        compound.m_128379_("mirror", this.rotMir.isMirrored());
        compound.m_128359_("name", this.schematicName == null ? "" : this.schematicName);
        compound.m_128359_("path", this.schematicPath == null ? "" : this.schematicPath);
        compound.m_128359_("pack", this.packName == null || this.packName.isEmpty() ? "" : this.packName);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void setBlueprintPath(String filePath) {
        this.schematicPath = filePath;
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
        this.m_6596_();
    }

    public void setPackName(String packName) {
        this.packName = packName;
        this.m_6596_();
    }

    public String getBlueprintPath() {
        return this.schematicPath;
    }

    public String getPackName() {
        return this.packName;
    }
}

