/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.core.util.TeleportHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class TeleportToColonyMessage
extends AbstractColonyServerMessage {
    private BlockPos pos;

    public TeleportToColonyMessage() {
    }

    public TeleportToColonyMessage(ResourceKey<Level> dimensionId, int colonyId, BlockPos pos) {
        super(dimensionId, colonyId);
        this.pos = pos;
    }

    @Override
    @Nullable
    public Action permissionNeeded() {
        return null;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (ctxIn.getSender() == null) {
            return;
        }
        if (colony.getPermissions().getRank(ctxIn.getSender().m_20148_()) != colony.getPermissions().getRankNeutral()) {
            TeleportHelper.colonyTeleport(ctxIn.getSender(), colony, this.pos);
        }
    }

    @Override
    protected void toBytesOverride(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    protected void fromBytesOverride(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }
}

