/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class InteractionClose
extends AbstractColonyServerMessage {
    private int citizenId;
    private Component key;

    public InteractionClose() {
    }

    public InteractionClose(int colonyId, int citizenId, ResourceKey<Level> dimension, @NotNull Component key) {
        super(dimension, colonyId);
        this.citizenId = citizenId;
        this.key = key;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.citizenId = buf.readInt();
        this.key = buf.m_130238_();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.citizenId);
        buf.m_130083_(this.key);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            citizenData = colony.getVisitorManager().getVisitor(this.citizenId);
        }
        if (citizenData != null && ctxIn.getSender() != null) {
            citizenData.onInteractionClosed(this.key, ctxIn.getSender());
        }
    }
}

