/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.client.render.worldevent.PathfindingDebugRenderer;
import com.minecolonies.core.entity.pathfinding.MNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPathMessage
implements IMessage {
    public Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public Set<MNode> lastDebugNodesPath = new HashSet<MNode>();
    public Set<MNode> debugNodesVisitedLater = new HashSet<MNode>();
    public Set<MNode> debugNodesOrgPath = new HashSet<MNode>();
    public Set<MNode> debugNodesExtra = new HashSet<MNode>();

    public SyncPathMessage() {
    }

    public SyncPathMessage(Set<MNode> lastDebugNodesVisited, Set<MNode> lastDebugNodesNotVisited, Set<MNode> lastDebugNodesPath, Set<MNode> debugNodesVisitedLater, Set<MNode> debugNodesOrgPath, Set<MNode> debugNodesExtra) {
        this.lastDebugNodesVisited = lastDebugNodesVisited;
        this.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        this.lastDebugNodesPath = lastDebugNodesPath;
        this.debugNodesVisitedLater = debugNodesVisitedLater;
        this.debugNodesOrgPath = debugNodesOrgPath;
        this.debugNodesExtra = debugNodesExtra;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.lastDebugNodesVisited.size());
        for (MNode node : this.lastDebugNodesVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesNotVisited.size());
        for (MNode node : this.lastDebugNodesNotVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesPath.size());
        for (MNode node : this.lastDebugNodesPath) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.debugNodesVisitedLater.size());
        for (MNode node : this.debugNodesVisitedLater) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.debugNodesOrgPath.size());
        for (MNode node : this.debugNodesOrgPath) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.debugNodesExtra.size());
        for (MNode node : this.debugNodesExtra) {
            node.serializeToBuf(buf);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesNotVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.lastDebugNodesPath.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.debugNodesVisitedLater.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.debugNodesOrgPath.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.debugNodesExtra.add(new MNode(buf));
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        PathfindingDebugRenderer.lastDebugNodesVisited = this.lastDebugNodesVisited;
        PathfindingDebugRenderer.lastDebugNodesNotVisited = this.lastDebugNodesNotVisited;
        PathfindingDebugRenderer.lastDebugNodesPath = this.lastDebugNodesPath;
        PathfindingDebugRenderer.lastDebugNodesVisitedLater = this.debugNodesVisitedLater;
        PathfindingDebugRenderer.debugNodesOrgPath = this.debugNodesOrgPath;
        PathfindingDebugRenderer.debugNodesExtra = this.debugNodesExtra;
    }
}

