/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.util.Log;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CitizenColonyHandler
implements ICitizenColonyHandler {
    protected final AbstractEntityCitizen citizen;
    protected int colonyId = 0;
    @Nullable
    protected IColony colony;
    protected boolean registered = false;
    private boolean needsClientUpdate = false;

    public CitizenColonyHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    @Nullable
    public IBuilding getWorkBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getWorkBuilding();
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getHomeBuilding();
    }

    @Override
    public void registerWithColony(int colonyID, int citizenID) {
        if (this.registered) {
            return;
        }
        if (this.citizen.f_19853_.m_6815_(this.citizen.m_19879_()) != this.citizen) {
            Log.getLogger().warn("Registering too early, entity not added to world!", (Throwable)new Exception());
            this.citizen.m_146870_();
            return;
        }
        this.colonyId = colonyID;
        this.citizen.setCitizenId(citizenID);
        if (this.colonyId == 0 || this.citizen.getCivilianID() == 0) {
            this.citizen.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.citizen.f_19853_);
        if (colony == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.citizen.m_20148_(), this.colonyId));
            this.citizen.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (colony.getWorld() == null) {
            return;
        }
        this.colony = colony;
        colony.getCitizenManager().registerCivilian(this.citizen);
        this.registered = true;
    }

    @Override
    public void updateColonyClient() {
        if (this.needsClientUpdate) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_COLONY_ID);
            }
            if (this.colonyId == 0) {
                this.citizen.m_146870_();
                return;
            }
            this.colony = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.citizen.f_19853_.m_46472_());
            if (this.citizen.getCivilianID() == 0) {
                this.citizen.setCitizenId((Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_CITIZEN_ID));
            }
            this.citizen.setFemale((Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_IS_FEMALE) != 0);
            this.citizen.setIsChild((Boolean)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_IS_CHILD));
            this.citizen.setModelId(new ResourceLocation((String)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_MODEL)));
            this.citizen.setTextureId((Integer)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_TEXTURE));
            this.citizen.setRenderMetadata((String)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_RENDER_METADATA));
            this.citizen.setTexture();
            this.needsClientUpdate = false;
        }
    }

    @Override
    public void onSyncDataUpdate(EntityDataAccessor<?> data) {
        if (data.equals(AbstractEntityCitizen.DATA_COLONY_ID) || data.equals(AbstractEntityCitizen.DATA_CITIZEN_ID) || data.equals(AbstractEntityCitizen.DATA_IS_FEMALE) || data.equals(AbstractEntityCitizen.DATA_IS_CHILD) || data.equals(AbstractEntityCitizen.DATA_MODEL) || data.equals(AbstractEntityCitizen.DATA_TEXTURE) || data.equals(AbstractEntityCitizen.DATA_TEXTURE_SUFFIX) || data.equals(AbstractEntityCitizen.DATA_STYLE) || data.equals(AbstractEntityCitizen.DATA_RENDER_METADATA)) {
            this.needsClientUpdate = true;
        }
    }

    @Override
    public boolean registered() {
        return this.registered;
    }

    @Override
    public double getPerBuildingFoodCost() {
        return this.getWorkBuilding() == null || this.getWorkBuilding().getBuildingLevelEquivalent() == 0 ? 1.0 : 0.02 * Math.pow(2.0, this.getWorkBuilding().getBuildingLevelEquivalent());
    }

    @Override
    @Nullable
    public IColony getColonyOrRegister() {
        if (this.colony == null && !this.citizen.f_19853_.f_46443_) {
            this.registerWithColony(this.getColonyId(), this.citizen.getCivilianID());
        }
        return this.colony;
    }

    @Override
    @Nullable
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public void setColonyId(int colonyId) {
        this.colonyId = colonyId;
    }

    @Override
    public void onCitizenRemoved() {
        if (this.citizen.getCitizenData() != null && this.registered && this.colony != null) {
            this.colony.getCitizenManager().unregisterCivilian(this.citizen);
            this.citizen.getCitizenData().setLastPosition(this.citizen.m_20183_());
        }
    }
}

