/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.ITickingStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Arrays;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAISkeleton<J extends IJob<?>>
implements ITickingStateAI {
    @NotNull
    protected final J job;
    @NotNull
    protected final AbstractEntityCitizen worker;
    protected final Level world;
    @NotNull
    private final ITickRateStateMachine<IAIState> stateMachine;

    protected AbstractAISkeleton(@NotNull J job) {
        if (!job.getCitizen().getEntity().isPresent()) {
            throw new IllegalArgumentException("Cannot instantiate a AI from a Job that is attached to a Citizen without entity.");
        }
        this.job = job;
        this.worker = this.job.getCitizen().getEntity().get();
        this.world = CompatibilityUtils.getWorldFromCitizen(this.worker);
        this.stateMachine = new TickRateStateMachine<AIWorkerState>(AIWorkerState.INIT, this::onException, 5);
    }

    @Override
    public void tick() {
        this.stateMachine.tick();
    }

    public void registerTarget(TickingTransition<IAIState> target) {
        this.stateMachine.addTransition(target);
    }

    protected final void registerTargets(TickingTransition<IAIState> ... targets) {
        Arrays.asList(targets).forEach(this::registerTarget);
    }

    protected void onException(RuntimeException e) {
    }

    @Override
    public final IAIState getState() {
        return (IAIState)this.stateMachine.getState();
    }

    public int getTickRate() {
        return this.stateMachine.getTickRate();
    }

    public boolean canBeInterrupted() {
        return this.getState().isOkayToEat();
    }

    @Override
    public void resetAI() {
        this.stateMachine.reset();
        this.worker.setRenderMetadata("");
    }

    @Override
    public ITickRateStateMachine<IAIState> getStateAI() {
        return this.stateMachine;
    }

    @Override
    public void onRemoval() {
        this.worker.m_8061_(EquipmentSlot.CHEST, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.FEET, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.HEAD, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.LEGS, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
        this.worker.m_8061_(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
        this.worker.getInventoryCitizen().moveArmorToInventory(EquipmentSlot.CHEST);
        this.worker.getInventoryCitizen().moveArmorToInventory(EquipmentSlot.FEET);
        this.worker.getInventoryCitizen().moveArmorToInventory(EquipmentSlot.HEAD);
        this.worker.getInventoryCitizen().moveArmorToInventory(EquipmentSlot.LEGS);
    }

    public void setCurrentDelay(int ticksToNextUpdate) {
        this.stateMachine.setCurrentDelay(ticksToNextUpdate);
    }
}

