/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.blockui.UiRenderMacros;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.CitizenData;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.compatibility.jei.JeiFakeLevel;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobBasedRecipeCategory<T>
implements IRecipeCategory<T> {
    protected static final JeiFakeLevel FAKE_LEVEL = new JeiFakeLevel();
    protected static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/jei_recipe.png");
    @NotNull
    protected final IJob<?> job;
    @NotNull
    private final RecipeType<T> type;
    @NotNull
    private final ItemStack catalyst;
    @NotNull
    private final IDrawableStatic background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    protected final IDrawableStatic slot;
    @NotNull
    protected final IDrawableStatic chanceSlot;
    @NotNull
    private final List<FormattedText> description;
    @NotNull
    private final LoadingCache<T, List<InfoBlock>> infoBlocksCache;
    private static final Cache<IJob<?>, EntityCitizen> citizenCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(2L)).build();
    protected static final int WIDTH = 167;
    protected static final int HEIGHT = 120;
    protected static final int CITIZEN_X = 2;
    protected static final int CITIZEN_Y = 46;
    protected static final int CITIZEN_W = 47;
    protected static final int CITIZEN_H = 71;

    protected JobBasedRecipeCategory(@NotNull IJob<?> job, @NotNull RecipeType<T> type, @NotNull ItemStack icon, @NotNull IGuiHelper guiHelper) {
        this.job = job;
        this.type = type;
        this.catalyst = icon;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 167, 120);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
        this.slot = guiHelper.getSlotDrawable();
        this.chanceSlot = guiHelper.createDrawable(TEXTURE, 0, 121, 18, 18);
        this.description = JobBasedRecipeCategory.wordWrap(JobBasedRecipeCategory.breakLines(JobBasedRecipeCategory.translateDescription("com.minecolonies.coremod.jei." + this.job.getJobRegistryEntry().getKey().m_135815_())));
        this.infoBlocksCache = CacheBuilder.newBuilder().maximumSize(6L).build(new CacheLoader<T, List<InfoBlock>>(){

            @NotNull
            public List<InfoBlock> load(@NotNull T key) {
                return JobBasedRecipeCategory.this.calculateInfoBlocks(key);
            }
        });
    }

    @NotNull
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @NotNull
    protected static ItemStack getCatalyst(@NotNull BuildingEntry building) {
        return new ItemStack(building.getBuildingBlock());
    }

    @NotNull
    public IJob<?> getJob() {
        return this.job;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    @NotNull
    public Component getTitle() {
        return this.getTitleAsTextComponent();
    }

    @NotNull
    public Component getTitleAsTextComponent() {
        return Component.m_237115_((String)this.job.getJobRegistryEntry().getTranslationKey());
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public List<T> findRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull List<Animal> animals, @NotNull Level world) {
        return Collections.emptyList();
    }

    protected void addToolSlot(@NotNull IRecipeLayoutBuilder builder, @NotNull EquipmentTypeEntry requiredTool, int x, int y, boolean withBackground) {
        if (requiredTool != ModEquipmentTypes.none.get()) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, x, y).setSlotName("tool");
            if (withBackground) {
                slot.setBackground((IDrawable)this.slot, -1, -1);
            }
            slot.addItemStacks(MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(requiredTool::checkIsEquipment).sorted(Comparator.comparing(requiredTool::getMiningLevel)).toList());
        }
    }

    public void draw(@NotNull T recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        float scale = 29.583332f;
        int citizen_cx = 25;
        int citizen_cy = 81;
        int citizen_by = 117;
        int offsetY = 4;
        EntityCitizen citizen = JobBasedRecipeCategory.createCitizenWithJob(this.job);
        if (citizen != null) {
            float headYaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 40.0f;
            float yaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 20.0f;
            float pitch = (float)Math.atan((77.0 - mouseY) / 40.0) * 20.0f;
            Lighting.m_84930_();
            UiRenderMacros.drawEntity((PoseStack)stack.m_280168_(), (int)25, (int)113, (double)29.583332061767578, (float)headYaw, (float)yaw, (float)pitch, (Entity)citizen);
            Lighting.m_84931_();
        }
        int y = 0;
        Minecraft mc = Minecraft.m_91087_();
        for (FormattedText line : this.description) {
            boolean x = false;
            stack.m_280649_(mc.f_91062_, Language.m_128107_().m_5536_(line), 0, y, ChatFormatting.BLACK.m_126665_().intValue(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9 + 2;
        }
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            stack.m_280614_(mc.f_91062_, block.text, block.bounds.m_110085_(), block.bounds.m_110086_(), ChatFormatting.YELLOW.m_126665_().intValue(), true);
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull T recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            if (block.tip == null || !block.bounds.m_110087_((int)mouseX, (int)mouseY)) continue;
            tooltips.add(block.tip);
        }
        return tooltips;
    }

    @NotNull
    private List<InfoBlock> calculateInfoBlocks(@NotNull T recipe) {
        List<Component> lines = this.generateInfoBlocks(recipe);
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<InfoBlock> result = new ArrayList<InfoBlock>();
        int y = 46;
        for (Component line : lines) {
            TranslatableContents contents;
            String key;
            int width = (int)mc.f_91062_.m_92865_().m_92353_(line.getString());
            Objects.requireNonNull(mc.f_91062_);
            int height = 9;
            int x = 167 - width;
            MutableComponent tip = null;
            ComponentContents componentContents = line.m_214077_();
            if (componentContents instanceof TranslatableContents && I18n.m_118936_((String)(key = (contents = (TranslatableContents)componentContents).m_237508_() + ".tip"))) {
                tip = Component.m_237110_((String)key, (Object[])contents.m_237523_());
            }
            result.add(new InfoBlock(line, (Component)tip, new Rect2i(x, y, width, height)));
            y += height + 2;
        }
        return result;
    }

    @NotNull
    protected abstract List<Component> generateInfoBlocks(@NotNull T var1);

    @Nullable
    private static EntityCitizen createCitizenWithJob(@NotNull IJob<?> job) {
        try {
            return (EntityCitizen)citizenCache.get(job, () -> {
                EntityCitizen citizen = new EntityCitizen(ModEntities.CITIZEN, (Level)FAKE_LEVEL);
                citizen.setFemale(citizen.m_217043_().m_188499_());
                citizen.setTextureId(citizen.m_217043_().m_188503_(255));
                citizen.m_20088_().m_135381_(EntityCitizen.DATA_TEXTURE_SUFFIX, (Object)CitizenData.SUFFIXES.get(citizen.m_217043_().m_188503_(CitizenData.SUFFIXES.size())));
                citizen.setModelId(job.getModel());
                return citizen;
            });
        }
        catch (Throwable e) {
            Log.getLogger().error("Error creating citizen for {}", (Object)job.getJobRegistryEntry().getTranslationKey(), (Object)e);
            return null;
        }
    }

    @NotNull
    private static List<FormattedText> translateDescription(String ... keys) {
        return Arrays.stream(keys).map(Component::m_237115_).collect(Collectors.toList());
    }

    @NotNull
    private static List<FormattedText> breakLines(@NotNull List<FormattedText> input) {
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        for (FormattedText component : input) {
            Optional expanded = component.m_5651_(line -> Optional.of(line.split("\\\\n")));
            expanded.ifPresent(e -> lines.addAll(Arrays.stream(e).map(Component::m_237113_).collect(Collectors.toList())));
        }
        return lines;
    }

    @NotNull
    private static List<FormattedText> wordWrap(@NotNull List<FormattedText> input) {
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        for (FormattedText component : input) {
            lines.addAll(mc.f_91062_.m_92865_().m_92414_(component, 167, Style.f_131099_));
        }
        return lines;
    }

    private record InfoBlock(@NotNull Component text, @Nullable Component tip, @NotNull Rect2i bounds) {
    }

    protected static class LootTableTooltipCallback
    implements IRecipeSlotTooltipCallback {
        private final LootTableAnalyzer.LootDrop drop;
        private final ResourceLocation id;

        public LootTableTooltipCallback(LootTableAnalyzer.LootDrop drop, ResourceLocation id) {
            this.drop = drop;
            this.id = id;
        }

        public void onTooltip(@NotNull IRecipeSlotView recipeSlotView, @NotNull List<Component> tooltip) {
            boolean showAdvanced;
            String key = "com.minecolonies.coremod.jei." + (this.drop.getQuality() < 0.0f ? "chancenegskill.tip" : (this.drop.getQuality() > 0.0f ? "chanceskill.tip" : "chance.tip"));
            float probability = this.drop.getProbability() * 100.0f;
            if (probability >= 1.0f) {
                tooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{Math.round(probability)}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{Float.valueOf((float)Math.round(probability * 100.0f) / 100.0f)}));
            }
            if (this.drop.getConditional()) {
                tooltip.add((Component)Component.m_237115_((String)"com.minecolonies.coremod.jei.conditions.tip"));
            }
            boolean bl = showAdvanced = Minecraft.m_91087_().f_91066_.f_92125_ || Screen.m_96638_();
            if (showAdvanced) {
                MutableComponent recipeId = Component.m_237110_((String)"com.minecolonies.coremod.jei.loottableid", (Object[])new Object[]{this.id.toString()});
                tooltip.add((Component)recipeId.m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    protected static class RecipeIdTooltipCallback
    implements IRecipeSlotTooltipCallback {
        private final ResourceLocation id;
        private final IModIdHelper modIdHelper;

        public RecipeIdTooltipCallback(ResourceLocation id, IModIdHelper modIdHelper) {
            this.id = id;
            this.modIdHelper = modIdHelper;
        }

        public void onTooltip(@NotNull IRecipeSlotView recipeSlotView, @NotNull List<Component> tooltip) {
            boolean showAdvanced;
            String ingredientModId;
            String recipeModId;
            ItemStack ingredient = recipeSlotView.getDisplayedIngredient().flatMap(d -> d.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK)).orElse(ItemStack.f_41583_);
            if (this.modIdHelper.isDisplayingModNameEnabled() && !(recipeModId = this.id.m_135827_()).equals(ingredientModId = ingredient.m_41720_().getCreatorModId(ingredient))) {
                String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                MutableComponent recipeBy = Component.m_237110_((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
                tooltip.add((Component)recipeBy.m_130940_(ChatFormatting.GRAY));
            }
            boolean bl = showAdvanced = Minecraft.m_91087_().f_91066_.f_92125_ || Screen.m_96638_();
            if (showAdvanced) {
                MutableComponent recipeId = Component.m_237110_((String)"jei.tooltip.recipe.id", (Object[])new Object[]{this.id.toString()});
                tooltip.add((Component)recipeId.m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

