/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.resolvers.PickupRequestResolver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class PickupRequestResolverFactory
implements IRequestResolverFactory<PickupRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends PickupRequestResolver> getFactoryOutputType() {
        return TypeToken.of(PickupRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public PickupRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new PickupRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull PickupRequestResolver pickupRequestResolver) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(pickupRequestResolver.getId()));
        compound.m_128365_(NBT_LOCATION, (Tag)controller.serialize(pickupRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public PickupRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserialize(nbt.m_128469_(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.m_128469_(NBT_LOCATION));
        return new PickupRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, PickupRequestResolver input, FriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public PickupRequestResolver deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new PickupRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return 16;
    }
}

