/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.CitizenData;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.eventhooks.citizenEvents.CitizenBornEvent;
import com.minecolonies.core.util.AdvancementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ReproductionManager
implements IReproductionManager {
    private static final int MIN_TIME_BEFORE_SPAWNTRY = 6000;
    private static final int CHILD_SPAWN_INTERVAL = 12000;
    private static final int MIN_SIZE_FOR_REPRO = 2;
    private int childCreationTimer;
    private final Colony colony;
    private Random random = new Random();

    public ReproductionManager(Colony colony) {
        this.colony = colony;
        this.childCreationTimer = this.random.nextInt(12000) + 6000;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if ((this.childCreationTimer -= 500) <= 0) {
            this.childCreationTimer = (6000 + this.random.nextInt(12000)) * (colony.getCitizenManager().getCurrentCitizenCount() / Math.max(4, colony.getCitizenManager().getMaxCitizens()));
            this.trySpawnChild();
        }
    }

    public void trySpawnChild() {
        if (this.colony.canMoveIn() && this.colony.getCitizenManager().getCurrentCitizenCount() < this.colony.getCitizenManager().getMaxCitizens() && this.colony.getCitizenManager().getCurrentCitizenCount() >= Math.min(2, (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().initialCitizenAmount.get())) {
            Object building;
            ICitizen secondParent;
            ICitizenData firstParent;
            if (!this.checkForBioParents()) {
                return;
            }
            IBuilding newHome = this.colony.getBuildingManager().getHouseWithSpareBed();
            if (newHome == null) {
                return;
            }
            LivingBuildingModule module = (LivingBuildingModule)newHome.getFirstModuleOccurance(LivingBuildingModule.class);
            List<ICitizenData> assignedCitizens = module.getAssignedCitizen();
            assignedCitizens.removeIf(ICitizen::isChild);
            boolean isOnlyChildInColony = true;
            for (ICitizenData data : this.colony.getCitizenManager().getCitizens()) {
                if (!data.isChild()) continue;
                isOnlyChildInColony = false;
                break;
            }
            ICitizenData newCitizen = this.colony.getCitizenManager().createAndRegisterCivilianData();
            if (!assignedCitizens.isEmpty()) {
                firstParent = assignedCitizens.get(this.random.nextInt(assignedCitizens.size()));
                secondParent = firstParent.getPartner();
                if (secondParent == null) {
                    assignedCitizens.removeIf(cit -> cit.getPartner() != null || cit.getName().equals(firstParent.getName()) || cit.isRelatedTo(firstParent) || cit.isChild());
                    if (assignedCitizens.size() > 0 && this.random.nextBoolean()) {
                        secondParent = assignedCitizens.get(this.random.nextInt(assignedCitizens.size()));
                    } else {
                        BlockPos altPos = this.colony.getBuildingManager().getRandomBuilding(b -> b.hasModule(LivingBuildingModule.class) && !b.getPosition().equals((Object)newHome.getPosition()) && BlockPosUtil.getDistance2D(b.getPosition(), newHome.getPosition()) < 50L);
                        if (altPos != null) {
                            building = this.colony.getBuildingManager().getBuilding(altPos);
                            LivingBuildingModule altModule = (LivingBuildingModule)building.getFirstModuleOccurance(LivingBuildingModule.class);
                            List<ICitizenData> newAssignedCitizens = altModule.getAssignedCitizen();
                            newAssignedCitizens.removeIf(cit -> cit.isChild() || cit.getPartner() != null || cit.isRelatedTo(firstParent));
                            if (newAssignedCitizens.size() > 0) {
                                secondParent = newAssignedCitizens.get(this.random.nextInt(newAssignedCitizens.size()));
                            }
                        }
                    }
                }
            } else {
                firstParent = null;
                secondParent = null;
            }
            if (secondParent != null) {
                firstParent.setPartner(secondParent.getId());
                secondParent.setPartner(firstParent.getId());
            }
            newCitizen.getCitizenSkillHandler().init(this.colony, firstParent, (ICitizenData)secondParent, this.random);
            newCitizen.setIsChild(true);
            ArrayList<String> possibleSuffixes = new ArrayList<String>();
            if (firstParent != null) {
                newCitizen.addSiblings(firstParent.getChildren().toArray(new Integer[0]));
                firstParent.addChildren(newCitizen.getId());
                possibleSuffixes.add(firstParent.getTextureSuffix());
            }
            if (secondParent != null) {
                newCitizen.addSiblings(secondParent.getChildren().toArray(new Integer[0]));
                secondParent.addChildren(newCitizen.getId());
                possibleSuffixes.add(secondParent.getTextureSuffix());
            }
            newCitizen.setParents(firstParent == null ? "" : firstParent.getName(), secondParent == null ? "" : secondParent.getName());
            newCitizen.generateName(this.random, firstParent == null ? "" : firstParent.getName(), secondParent == null ? "" : secondParent.getName(), this.colony.getCitizenNameFile());
            module.assignCitizen(newCitizen);
            building = newCitizen.getSiblings().iterator();
            while (building.hasNext()) {
                int sibling = (Integer)building.next();
                ICitizenData siblingData = this.colony.getCitizenManager().getCivilian(sibling);
                if (siblingData == null) continue;
                siblingData.addSiblings(newCitizen.getId());
            }
            if (possibleSuffixes.contains("_w") && possibleSuffixes.contains("_d")) {
                possibleSuffixes.add("_b");
            }
            if (possibleSuffixes.isEmpty()) {
                possibleSuffixes.addAll(CitizenData.SUFFIXES);
            }
            newCitizen.setSuffix((String)possibleSuffixes.get(this.random.nextInt(possibleSuffixes.size())));
            int populationCount = this.colony.getCitizenManager().getCurrentCitizenCount();
            AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, playerMP -> AdvancementTriggers.COLONY_POPULATION.trigger((ServerPlayer)playerMP, populationCount));
            this.colony.getCitizenManager().spawnOrCreateCitizen(newCitizen, this.colony.getWorld(), newHome.getPosition());
            if (isOnlyChildInColony) {
                MessageUtils.format("com.minecolonies.coremod.progress.newchild", newCitizen.getName(), this.colony.getName()).sendTo(this.colony).forManagers();
            }
            this.colony.getEventDescriptionManager().addEventDescription(new CitizenBornEvent(newHome.getPosition(), newCitizen.getName()));
            this.colony.getStatisticsManager().increment("birth", this.colony.getDay());
        }
    }

    private boolean checkForBioParents() {
        boolean hasMale = false;
        boolean hasFemale = false;
        for (ICitizenData iCitizenData : this.colony.getCitizenManager().getCitizens()) {
            if (iCitizenData.isFemale()) {
                hasFemale = true;
            } else {
                hasMale = true;
            }
            if (!hasFemale || !hasMale) continue;
            return true;
        }
        for (ICivilianData iCivilianData : this.colony.getVisitorManager().getCivilianDataMap().values()) {
            if (iCivilianData.isFemale()) {
                hasFemale = true;
            } else {
                hasMale = true;
            }
            if (!hasFemale || !hasMale) continue;
            return true;
        }
        return false;
    }
}

