/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.education.EntityAIWorkResearcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JobResearch
extends AbstractJob<EntityAIWorkResearcher, JobResearch> {
    private static final int MANA_PER_SECOND = 144;
    private static final int MAX_TICKRATE_PER_SECOND = 25;
    private int currentMana = 0;

    public JobResearch(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.STUDENT_ID;
    }

    @Override
    @NotNull
    public EntityAIWorkResearcher generateAI() {
        return new EntityAIWorkResearcher(this);
    }

    public int getCurrentMana() {
        return this.currentMana;
    }

    @Override
    public void processOfflineTime(long time) {
        super.processOfflineTime(time);
        int maxMana = this.getCitizen().getCitizenSkillHandler().getLevel(Skill.Mana);
        int speed = this.getCitizen().getCitizenSkillHandler().getLevel(Skill.Knowledge);
        long currentMaxManaInSeconds = 144 * maxMana;
        long newMana = time / 100L * (long)speed;
        long both = newMana + (long)(this.currentMana * 25);
        long result = Math.min(both, currentMaxManaInSeconds);
        this.currentMana = (int)(result / 25L);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = super.serializeNBT();
        compoundNBT.m_128405_("currentMana", this.currentMana);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.currentMana = compound.m_128451_("currentMana");
    }

    public void reduceCurrentMana() {
        --this.currentMana;
    }
}

