/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.google.gson.JsonObject;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.eventbus.events.CustomRecipesReloadedEvent;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import com.minecolonies.core.colony.crafting.CustomRecipeManagerMessage;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.colony.crafting.RecipeAnalyzer;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRecipeManager {
    private static final CustomRecipeManager instance = new CustomRecipeManager();
    private final Map<String, Map<ResourceLocation, CustomRecipe>> recipeMap = new HashMap<String, Map<ResourceLocation, CustomRecipe>>();
    private final Map<Item, List<CustomRecipe>> recipeOutputMap = new HashMap<Item, List<CustomRecipe>>();
    private final List<ResourceLocation> removedRecipes = new ArrayList<ResourceLocation>();
    private final Map<ResourceLocation, List<LootTableAnalyzer.LootDrop>> lootTables = new HashMap<ResourceLocation, List<LootTableAnalyzer.LootDrop>>();
    private final Map<ResourceLocation, JsonObject> recipeTemplates = new HashMap<ResourceLocation, JsonObject>();

    private CustomRecipeManager() {
    }

    public static CustomRecipeManager getInstance() {
        return instance;
    }

    public void addRecipe(@NotNull CustomRecipe recipe) {
        if (!this.recipeMap.containsKey(recipe.getCrafter())) {
            this.recipeMap.put(recipe.getCrafter(), new HashMap());
        }
        this.recipeMap.get(recipe.getCrafter()).put(recipe.getRecipeId(), recipe);
        if (!this.recipeOutputMap.containsKey(recipe.getPrimaryOutput().m_41720_())) {
            this.recipeOutputMap.put(recipe.getPrimaryOutput().m_41720_(), new ArrayList());
        }
        this.recipeOutputMap.get(recipe.getPrimaryOutput().m_41720_()).add(recipe);
        for (ItemStack item : recipe.getAltOutputs()) {
            if (!this.recipeOutputMap.containsKey(item.m_41720_())) {
                this.recipeOutputMap.put(item.m_41720_(), new ArrayList());
            }
            this.recipeOutputMap.get(item.m_41720_()).add(recipe);
        }
    }

    public void removeRecipe(@NotNull ResourceLocation toRemove) {
        if (!this.removedRecipes.contains(toRemove)) {
            this.removedRecipes.add(toRemove);
        }
    }

    public void addRecipeTemplate(@NotNull ResourceLocation id, @NotNull JsonObject templateJson) {
        this.recipeTemplates.put(id, templateJson);
    }

    public void reset() {
        this.recipeOutputMap.clear();
        this.recipeMap.clear();
        this.lootTables.clear();
        this.removedRecipes.clear();
        this.recipeTemplates.clear();
    }

    public Set<CustomRecipe> getRecipes(@NotNull String crafter) {
        this.removeRecipes();
        return Collections.unmodifiableSet(new HashSet(((Map)this.recipeMap.getOrDefault(crafter, new HashMap())).values()));
    }

    public Map<String, Map<ResourceLocation, CustomRecipe>> getAllRecipes() {
        return this.recipeMap;
    }

    public List<CustomRecipe> getRecipeByOutput(Item item) {
        if (this.recipeOutputMap.containsKey(item)) {
            return this.recipeOutputMap.get(item);
        }
        return Collections.emptyList();
    }

    public List<CustomRecipe> getRecipeByOutput(ItemStack itemStack) {
        ArrayList<CustomRecipe> returnList = new ArrayList<CustomRecipe>();
        for (CustomRecipe recipe : this.recipeOutputMap.get(itemStack.m_41720_())) {
            if (ItemStack.m_41728_((ItemStack)recipe.getPrimaryOutput(), (ItemStack)itemStack)) {
                returnList.add(recipe);
            }
            for (ItemStack output : recipe.getAltOutputs()) {
                if (!ItemStack.m_41728_((ItemStack)output, (ItemStack)itemStack)) continue;
                returnList.add(recipe);
            }
        }
        return returnList;
    }

    public List<CustomRecipe> getRecipeByOutput(ItemStorage itemStorage) {
        ArrayList<CustomRecipe> returnList = new ArrayList<CustomRecipe>();
        block0: for (CustomRecipe recipe : this.recipeOutputMap.get(itemStorage.getItem())) {
            if (new ItemStorage(recipe.getPrimaryOutput()).equals(itemStorage)) {
                returnList.add(recipe);
            }
            for (ItemStack output : recipe.getAltOutputs()) {
                if (!new ItemStorage(output).equals(itemStorage)) continue;
                returnList.add(recipe);
                continue block0;
            }
        }
        return returnList;
    }

    @NotNull
    public List<LootTableAnalyzer.LootDrop> getLootDrops(@Nullable ResourceLocation lootTableId) {
        if (lootTableId == null) {
            return Collections.emptyList();
        }
        return this.lootTables.getOrDefault(lootTableId, Collections.emptyList());
    }

    private void removeRecipes() {
        if (!this.removedRecipes.isEmpty()) {
            for (ResourceLocation toRemove : this.removedRecipes) {
                this.recipeMap.values().stream().filter(recipes -> recipes.containsKey(toRemove)).findFirst().ifPresent(crafterRecipeMap -> {
                    ArrayList emptyList = new ArrayList();
                    CustomRecipe recipe = (CustomRecipe)crafterRecipeMap.remove(toRemove);
                    if (recipe != null) {
                        ((List)this.recipeOutputMap.getOrDefault(recipe.getPrimaryOutput().m_41720_(), emptyList)).remove(recipe);
                        for (ItemStack item : recipe.getAltOutputs()) {
                            ((List)this.recipeOutputMap.getOrDefault(item.m_41720_(), emptyList)).remove(recipe);
                        }
                    }
                });
            }
            this.removedRecipes.clear();
        }
    }

    public void resolveTemplates() {
        for (Map.Entry<ResourceLocation, JsonObject> templateEntry : this.recipeTemplates.entrySet()) {
            try {
                for (CustomRecipe recipe : CustomRecipe.parseTemplate(templateEntry.getKey(), templateEntry.getValue())) {
                    this.addRecipe(recipe);
                }
            }
            catch (Exception e) {
                Log.getLogger().error("Error parsing crafterrecipe template " + templateEntry.getKey().toString(), (Throwable)e);
            }
        }
        this.recipeTemplates.clear();
    }

    public void buildLootData(@NotNull LootDataManager lootTableManager, @NotNull Level level) {
        List<Animal> animals = RecipeAnalyzer.createAnimals(level);
        ArrayList<Object> lootIds = new ArrayList<Object>();
        for (Map<ResourceLocation, CustomRecipe> recipes : this.recipeMap.values()) {
            for (CustomRecipe recipe : recipes.values()) {
                ResourceLocation lootTable = recipe.getLootTable();
                if (lootTable == null) continue;
                lootIds.add(lootTable);
            }
        }
        for (MinecoloniesCropBlock crop : ModBlocks.getCrops()) {
            for (Block source : crop.getDroppedFrom()) {
                lootIds.add(source.m_60589_());
            }
        }
        for (String producerKey : BuildingEntry.getALlModuleProducers().keySet()) {
            IBuildingModule module = BuildingEntry.produceModuleWithoutBuilding(producerKey);
            if (module == null) continue;
            if (module instanceof AnimalHerdingModule) {
                AnimalHerdingModule herding = (AnimalHerdingModule)module;
                for (Animal animal : animals) {
                    if (!herding.isCompatible(animal)) continue;
                    lootIds.addAll(herding.getLootTables(animal));
                }
                continue;
            }
            if (!(module instanceof ICraftingBuildingModule)) continue;
            ICraftingBuildingModule crafting = (ICraftingBuildingModule)module;
            lootIds.addAll(crafting.getAdditionalLootTables());
        }
        lootIds.add(ModLootTables.FISHING);
        lootIds.addAll(ModLootTables.FISHERMAN_BONUS.values());
        this.lootTables.clear();
        this.lootTables.putAll(lootIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toConcurrentMap(Function.identity(), id -> LootTableAnalyzer.toDrops(lootTableManager, id))));
    }

    public void sendCustomRecipeManagerPackets(ServerPlayer player) {
        FriendlyByteBuf recipeMgrFriendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        this.serializeNetworkData(recipeMgrFriendlyByteBuf);
        Network.getNetwork().sendToPlayer(new CustomRecipeManagerMessage(recipeMgrFriendlyByteBuf), player);
    }

    private void serializeNetworkData(FriendlyByteBuf recipeMgrFriendlyByteBuf) {
        recipeMgrFriendlyByteBuf.m_130130_(this.recipeMap.size());
        for (Map.Entry<String, Map<ResourceLocation, CustomRecipe>> entry : this.recipeMap.entrySet()) {
            recipeMgrFriendlyByteBuf.m_130130_(entry.getValue().size());
            for (CustomRecipe recipe : entry.getValue().values()) {
                recipe.serialize(recipeMgrFriendlyByteBuf);
            }
        }
        recipeMgrFriendlyByteBuf.m_130130_(this.lootTables.size());
        for (Map.Entry<String, Object> entry : this.lootTables.entrySet()) {
            recipeMgrFriendlyByteBuf.m_130085_((ResourceLocation)entry.getKey());
            recipeMgrFriendlyByteBuf.m_130130_(((List)entry.getValue()).size());
            for (LootTableAnalyzer.LootDrop drop : (List)entry.getValue()) {
                drop.serialize(recipeMgrFriendlyByteBuf);
            }
        }
    }

    public void handleCustomRecipeManagerMessage(FriendlyByteBuf buff) {
        this.reset();
        for (int crafterNum = buff.m_130242_(); crafterNum > 0; --crafterNum) {
            for (int recipeNum = buff.m_130242_(); recipeNum > 0; --recipeNum) {
                this.addRecipe(CustomRecipe.deserialize(buff));
            }
        }
        for (int lootNum = buff.m_130242_(); lootNum > 0; --lootNum) {
            int count;
            ResourceLocation id = buff.m_130281_();
            ArrayList<LootTableAnalyzer.LootDrop> drops = new ArrayList<LootTableAnalyzer.LootDrop>(count);
            for (count = buff.m_130242_(); count > 0; --count) {
                drops.add(LootTableAnalyzer.LootDrop.deserialize(buff));
            }
            this.lootTables.put(id, drops);
        }
        try {
            MinecraftForge.EVENT_BUS.post((Event)new CustomRecipesReloadedEvent());
        }
        catch (Exception e) {
            Log.getLogger().error("Error during CustomRecipesReloadedEvent", (Throwable)e);
        }
    }
}

