/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.ai.JobStatus;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.quests.IQuestDeliveryObjective;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.interactionhandling.QuestDeliveryInteraction;
import com.minecolonies.core.colony.interactionhandling.QuestDialogueInteraction;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenDiseaseHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenFoodHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenHappinessHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenMournHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSkillHandler;
import com.minecolonies.core.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.core.util.AttributeModifierUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenData
implements ICitizenData {
    public static final float MAX_HEALTH = 20.0f;
    private static final int LETTERS_IN_THE_ALPHABET = 26;
    private static final int MIN_SATURATION = 0;
    public static final List<String> SUFFIXES = Arrays.asList("_b", "_d", "_a", "_w");
    private static final int NUM_SOUND_PROFILES = 4;
    private final int id;
    private UUID uuid;
    private final IColony colony;
    protected InventoryCitizen inventory;
    private String name;
    private boolean female;
    private boolean isChild = false;
    private boolean paused;
    private boolean restartScheduled;
    private ServerPlayer originPlayerRestart;
    private int textureId;
    private boolean isAsleep;
    private BlockPos bedPos = BlockPos.f_121853_;
    @Nullable
    private IBuilding homeBuilding;
    private IJob<?> job;
    private int dirty = Integer.MAX_VALUE;
    @NotNull
    private WeakReference<AbstractEntityCitizen> entity = new WeakReference<Object>(null);
    private double saturation;
    private boolean justAte;
    private BlockPos lastPosition = new BlockPos(0, 0, 0);
    private final CitizenHappinessHandler citizenHappinessHandler;
    private final CitizenMournHandler citizenMournHandler;
    private final CitizenSkillHandler citizenSkillHandler;
    private final ICitizenFoodHandler citizenFoodHandler;
    private final CitizenDiseaseHandler citizenDiseaseHandler;
    protected final Map<Component, IInteractionResponseHandler> citizenChatOptions = new HashMap<Component, IInteractionResponseHandler>();
    private JobStatus jobStatus = JobStatus.IDLE;
    private String textureSuffix;
    private VisibleCitizenStatus status;
    @Nullable
    private BlockPos statusPosition;
    private final Random random = new Random();
    private static final int NO_GUARD_COMPLAIN_CHANCE = 10;
    private BlockPos nextRespawnPos = null;
    private Tuple<String, String> parents = new Tuple<String, String>("", "");
    private final Set<Integer> children = new HashSet<Integer>();
    private final Set<Integer> siblings = new HashSet<Integer>();
    private Integer partner = 0;
    private boolean isWorking = false;
    private int inactivityTimer = -1;
    private final List<ResourceLocation> availableQuests = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> participatingQuests = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> finishedQuests = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> finishedQuestParticipation = new ArrayList<ResourceLocation>();
    private int voiceProfile;
    private int interactedRecently = 0;
    private final Set<UUID> interactedRecentlyPlayers = new HashSet<UUID>();
    private UUID textureUUID;
    private int leisureTime;

    public CitizenData(int id, IColony colony) {
        this.id = id;
        this.colony = colony;
        this.inventory = new InventoryCitizen("Minecolonies Inventory", true, this);
        this.citizenHappinessHandler = new CitizenHappinessHandler(this);
        this.citizenMournHandler = new CitizenMournHandler(this);
        this.citizenSkillHandler = new CitizenSkillHandler();
        this.citizenFoodHandler = new CitizenFoodHandler(this);
        this.citizenDiseaseHandler = new CitizenDiseaseHandler(this);
    }

    @Override
    public void onResponseTriggered(@NotNull Component key, int responseId, Player player) {
        if (this.citizenChatOptions.containsKey(key)) {
            this.citizenChatOptions.get(key).onServerResponseTriggered(responseId, player, this);
            this.markDirty(0);
        }
    }

    @Override
    @NotNull
    public Optional<AbstractEntityCitizen> getEntity() {
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)this.entity.get();
        if (citizen != null && citizen.m_213877_()) {
            this.entity.clear();
            return Optional.empty();
        }
        return Optional.ofNullable(citizen);
    }

    @Override
    public int getVoiceProfile() {
        return this.voiceProfile;
    }

    @Override
    public void setVoiceProfile(int profile) {
        this.voiceProfile = profile;
    }

    @Override
    public void setEntity(@Nullable AbstractCivilianEntity citizen) {
        if (this.entity.get() != null) {
            this.entity.clear();
        }
        if (citizen != null) {
            this.entity = new WeakReference<AbstractEntityCitizen>((AbstractEntityCitizen)citizen);
            citizen.setCivilianData(this);
        }
    }

    @Override
    public void markDirty(int time) {
        this.dirty = Math.min(this.dirty, time);
        if (this.interactedRecently > 0) {
            for (UUID player : this.interactedRecentlyPlayers) {
                Player player2 = this.getColony().getWorld().m_46003_(player);
                if (!(player2 instanceof ServerPlayer)) continue;
                ServerPlayer playerEntity = (ServerPlayer)player2;
                Network.getNetwork().sendToPlayer(new ColonyViewCitizenViewMessage((Colony)this.getColony(), this), playerEntity);
            }
        }
        if (this.isDirty()) {
            this.colony.getCitizenManager().markDirty();
        }
    }

    private static String getRandomElement(@NotNull Random rand, @NotNull List<String> list) {
        return list.get(rand.nextInt(list.size()));
    }

    private static char getRandomLetter(@NotNull Random rand) {
        return (char)(rand.nextInt(26) + 65);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitizenData data = (CitizenData)o;
        if (this.id != data.id) {
            return false;
        }
        return this.colony != null ? data.colony != null && this.colony.getID() == data.colony.getID() : data.colony == null;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void initForNewCivilian() {
        this.female = this.random.nextBoolean();
        this.textureSuffix = SUFFIXES.get(this.random.nextInt(SUFFIXES.size()));
        this.voiceProfile = this.random.nextInt(4);
        this.paused = false;
        this.name = CitizenData.generateName(this.random, this.female, this.getColony(), this.getColony().getCitizenNameFile());
        this.textureId = this.random.nextInt(255);
        this.saturation = 20.0;
        int levelCap = (int)this.colony.getOverallHappiness() * 2;
        if (this.colony.getCitizenManager().getCitizens().size() < (Integer)IMinecoloniesAPI.getInstance().getConfig().getServer().initialCitizenAmount.get()) {
            levelCap = Math.max(5, levelCap);
        }
        this.citizenSkillHandler.init(levelCap);
        this.markDirty(0);
    }

    @Override
    public void initEntityValues() {
        if (!this.getEntity().isPresent()) {
            Log.getLogger().warn("Missing entity upon adding data to that entity!" + String.valueOf(this), (Throwable)new Exception());
            return;
        }
        AbstractEntityCitizen citizen = this.getEntity().get();
        citizen.setCitizenId(this.getId());
        citizen.getCitizenColonyHandler().setColonyId(this.getColony().getID());
        citizen.setIsChild(this.isChild());
        citizen.m_6593_((Component)Component.m_237113_((String)this.getName()));
        citizen.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        citizen.setFemale(this.isFemale());
        citizen.setTextureId(this.getTextureId());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_COLONY_ID, (Object)this.colony.getID());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_CITIZEN_ID, (Object)citizen.getCivilianID());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_IS_FEMALE, (Object)(citizen.isFemale() ? 1 : 0));
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_TEXTURE, (Object)citizen.getTextureId());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_TEXTURE_SUFFIX, (Object)this.getTextureSuffix());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)this.isAsleep());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_IS_CHILD, (Object)this.isChild());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_BED_POS, (Object)this.getBedPos());
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_JOB, (Object)(this.getJob() == null ? "" : this.getJob().getJobRegistryEntry().getKey().toString()));
        citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_STYLE, (Object)this.colony.getTextureStyleId());
        if (this.getBedPos().equals((Object)BlockPos.f_121853_)) {
            citizen.getCitizenSleepHandler().onWakeUp();
        }
        citizen.getCitizenExperienceHandler().updateLevel();
        this.setLastPosition(citizen.m_20183_());
        citizen.getCitizenJobHandler().onJobChanged(citizen.getCitizenJobHandler().getColonyJob());
        this.applyResearchEffects();
        this.applyItemModifiers(citizen);
        this.markDirty(0);
    }

    private void applyItemModifiers(AbstractEntityCitizen citizen) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = slot.m_254934_() ? citizen.getInventoryCitizen().getArmorInSlot(slot) : citizen.m_6844_(slot);
            if (ItemStackUtils.isEmpty(stack)) continue;
            citizen.m_21204_().m_22178_(stack.m_41638_(slot));
        }
    }

    public static String generateName(@NotNull Random rand, boolean female, IColony colony, CitizenNameFile nameFile) {
        String firstName = female ? CitizenData.getRandomElement(rand, nameFile.femalefirstNames) : CitizenData.getRandomElement(rand, nameFile.maleFirstNames);
        String middleInitial = String.valueOf(CitizenData.getRandomLetter(rand));
        String lastName = CitizenData.getRandomElement(rand, nameFile.surnames);
        String citizenName = nameFile.order == CitizenNameFile.NameOrder.EASTERN ? String.format("%s %s", lastName, firstName) : (nameFile.parts == 3 ? String.format("%s %s. %s", firstName, middleInitial, lastName) : (nameFile.parts == 2 ? String.format("%s %s", firstName, lastName) : firstName));
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            if (citizen == null || !citizen.getName().equals(citizenName)) continue;
            citizenName = CitizenData.generateName(rand, female, colony, nameFile);
            break;
        }
        return citizenName;
    }

    @Override
    public void generateName(@NotNull Random rand, String firstParentName, String secondParentName, CitizenNameFile nameFile) {
        String lastName;
        boolean eastern;
        String nameA = firstParentName;
        String nameB = secondParentName;
        String middleInitial = "";
        if (firstParentName == null || firstParentName.isEmpty()) {
            nameA = CitizenData.generateName(rand, rand.nextBoolean(), this.colony, nameFile);
        }
        if (secondParentName == null || secondParentName.isEmpty()) {
            nameB = CitizenData.generateName(rand, rand.nextBoolean(), this.colony, nameFile);
        }
        String[] firstParentNameSplit = nameA.split(" ");
        String[] secondParentNameSplit = nameB.split(" ");
        if (firstParentNameSplit.length <= 1) {
            this.generateName(rand, "", secondParentName, nameFile);
            return;
        }
        if (secondParentNameSplit.length <= 1) {
            this.generateName(rand, firstParentName, "", nameFile);
            return;
        }
        boolean bl = eastern = nameFile.order == CitizenNameFile.NameOrder.EASTERN;
        if (this.random.nextBoolean()) {
            if (nameFile.parts == 3) {
                middleInitial = firstParentNameSplit[eastern ? 0 : firstParentNameSplit.length - 1].substring(0, 1);
                lastName = secondParentNameSplit[eastern ? 0 : secondParentNameSplit.length - 1];
            } else {
                lastName = eastern ? secondParentNameSplit[0] : nameB.replace(secondParentNameSplit[0], "").trim();
            }
        } else if (nameFile.parts == 3) {
            middleInitial = secondParentNameSplit[eastern ? 0 : secondParentNameSplit.length - 1].substring(0, 1);
            lastName = firstParentNameSplit[eastern ? 0 : firstParentNameSplit.length - 1];
        } else {
            lastName = eastern ? firstParentNameSplit[0] : nameA.replace(firstParentNameSplit[0], "").trim();
        }
        String firstName = this.female ? CitizenData.getRandomElement(rand, nameFile.femalefirstNames) : CitizenData.getRandomElement(rand, nameFile.maleFirstNames);
        String citizenName = nameFile.order == CitizenNameFile.NameOrder.EASTERN ? String.format("%s %s", lastName, firstName) : (nameFile.parts == 3 ? String.format("%s %s. %s", firstName, middleInitial, lastName) : (nameFile.parts == 2 ? String.format("%s %s", firstName, lastName) : firstName));
        for (ICitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (citizen == null || !citizen.getName().equals(citizenName)) continue;
            this.generateName(rand, firstParentName, secondParentName, nameFile);
            return;
        }
        this.name = citizenName;
    }

    @Override
    public boolean isRelatedTo(ICitizenData data) {
        return this.siblings.contains(data.getId()) || this.children.contains(data.getId()) || this.partner.intValue() == data.getId() || this.parents.getA().equals(data.getName()) || this.parents.getB().equals(data.getName());
    }

    @Override
    public boolean doesLiveWith(ICitizenData data) {
        return data.getHomeBuilding() != null && this.getHomeBuilding() != null && data.getHomeBuilding().getPosition().equals((Object)this.getHomeBuilding().getPosition());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFemale() {
        return this.female;
    }

    @Override
    public void setGenderAndGenerateName(boolean isFemale) {
        this.female = isFemale;
        this.name = CitizenData.generateName(this.random, isFemale, this.getColony(), this.getColony().getCitizenNameFile());
        this.markDirty(0);
    }

    @Override
    public void setGender(boolean isFemale) {
        this.female = isFemale;
    }

    @Override
    public void setPaused(boolean p) {
        this.paused = p;
        this.markDirty(40);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public int getTextureId() {
        return this.textureId;
    }

    @Override
    public boolean isDirty() {
        return this.dirty <= 0;
    }

    @Override
    public void clearDirty() {
        if (this.isDirty()) {
            this.dirty = Integer.MAX_VALUE;
        }
        if (this.dirty > 0) {
            this.dirty -= 20;
            if (this.isDirty()) {
                this.colony.getCitizenManager().markDirty();
            }
        }
    }

    @Override
    public void onRemoveBuilding(IBuilding building) {
        if (this.homeBuilding != null && this.homeBuilding.getID().equals((Object)building.getID())) {
            this.setHomeBuilding(null);
        }
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    public void setHomeBuilding(@Nullable IBuilding building) {
        if (this.homeBuilding != null && building != null && !this.homeBuilding.equals(building)) {
            ((LivingBuildingModule)this.homeBuilding.getFirstModuleOccurance(LivingBuildingModule.class)).removeCitizen(this);
        }
        if (this.homeBuilding != null) {
            this.setBedPos(BlockPos.f_121853_);
        }
        this.homeBuilding = building;
        this.markDirty(0);
        if (this.getEntity().isPresent() && this.getEntity().get().getCitizenJobHandler().getColonyJob() == null) {
            this.getEntity().get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
    }

    @Override
    @Nullable
    public IBuilding getWorkBuilding() {
        if (this.job == null) {
            return null;
        }
        return this.job.getWorkBuilding();
    }

    @Override
    public void updateEntityIfNecessary() {
        boolean spawnVisible;
        Entity entity2;
        if (this.getEntity().isPresent() && (entity2 = (Entity)this.getEntity().get()).m_6084_() && WorldUtil.isEntityBlockLoaded((LevelAccessor)entity2.f_19853_, entity2.m_20183_())) {
            return;
        }
        if (this.getColony().getTravellingManager().isTravelling(this)) {
            return;
        }
        Optional<BlockPos> travelingTargetCandidate = this.getColony().getTravellingManager().getTravellingTargetFor(this);
        if (travelingTargetCandidate.isPresent()) {
            this.getColony().getTravellingManager().finishTravellingFor(this);
            this.nextRespawnPos = travelingTargetCandidate.get();
            spawnVisible = false;
            this.lastPosition = this.nextRespawnPos;
        } else {
            spawnVisible = true;
        }
        if (this.nextRespawnPos != null) {
            ICitizenData data = this.colony.getCitizenManager().spawnOrCreateCivilian(this, this.colony.getWorld(), this.nextRespawnPos, true);
            data.getEntity().ifPresent(entity -> {
                entity.getCitizenJobHandler().setModelDependingOnJob(data.getJob());
                if (!spawnVisible) {
                    entity.m_6842_(true);
                    entity.m_6034_(this.nextRespawnPos.m_123341_(), this.nextRespawnPos.m_123342_(), this.nextRespawnPos.m_123343_());
                }
            });
            this.nextRespawnPos = null;
        } else {
            this.colony.getCitizenManager().spawnOrCreateCivilian(this, this.colony.getWorld(), this.lastPosition, true);
        }
    }

    @Override
    public IJob<?> getJob() {
        return this.job;
    }

    @Override
    public void setJob(IJob<?> job) {
        if (this.job != null && job == null) {
            IJob<?> oldJob = this.job;
            this.job = null;
            oldJob.onRemoval();
        }
        this.job = job;
        this.getEntity().ifPresent(entityCitizen -> entityCitizen.getCitizenJobHandler().onJobChanged(job));
        this.markDirty(0);
    }

    @Override
    @Nullable
    public <J extends IJob<?>> J getJob(@NotNull Class<J> type) {
        if (type.isInstance(this.job)) {
            return (J)((IJob)type.cast(this.job));
        }
        return null;
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.writeBoolean(this.female);
        buf.writeInt(this.getEntity().map(Entity::m_19879_).orElse(-1).intValue());
        buf.writeBoolean(this.paused);
        buf.writeBoolean(this.isChild);
        buf.writeBoolean(this.homeBuilding != null);
        if (this.homeBuilding != null) {
            buf.m_130064_(this.homeBuilding.getID());
        }
        buf.writeBoolean(this.getWorkBuilding() != null);
        if (this.getWorkBuilding() != null) {
            buf.m_130064_(this.getWorkBuilding().getID());
        }
        buf.writeDouble(this.getSaturation());
        buf.writeDouble(this.citizenHappinessHandler.getHappiness(this.getColony(), this));
        buf.m_130079_(this.citizenSkillHandler.write());
        buf.m_130070_(this.job != null ? this.job.getJobRegistryEntry().getTranslationKey() : "");
        buf.writeInt(this.colony.getID());
        CompoundTag compound = new CompoundTag();
        this.inventory.write(compound);
        buf.m_130079_(compound);
        buf.m_130064_(this.lastPosition);
        if (this.colony.getWorld() != null) {
            List<IInteractionResponseHandler> subInteractions = this.citizenChatOptions.values().stream().filter(e -> e.isVisible(this.colony.getWorld())).toList();
            buf.writeInt(subInteractions.size());
            for (IInteractionResponseHandler interactionHandler : subInteractions) {
                buf.m_130079_((CompoundTag)interactionHandler.serializeNBT());
            }
        } else {
            buf.writeInt(0);
        }
        CompoundTag happinessCompound = new CompoundTag();
        this.citizenHappinessHandler.write(happinessCompound, false);
        buf.m_130079_(happinessCompound);
        buf.writeInt(this.status != null ? this.status.getId() : -1);
        buf.writeBoolean(this.statusPosition != null);
        if (this.statusPosition != null) {
            buf.m_130064_(this.statusPosition);
        }
        buf.writeBoolean(this.job != null);
        if (this.job != null) {
            this.job.serializeToView(buf);
        }
        if (this.colony.getCitizenManager().getCivilian(this.partner) == null) {
            this.partner = 0;
        }
        this.siblings.removeIf(s -> this.colony.getCitizenManager().getCivilian((int)s) == null);
        this.children.removeIf(c -> this.colony.getCitizenManager().getCivilian((int)c) == null);
        buf.writeInt(this.partner.intValue());
        buf.writeInt(this.siblings.size());
        Iterator<Object> iterator = this.siblings.iterator();
        while (iterator.hasNext()) {
            int sibling = (Integer)iterator.next();
            buf.writeInt(sibling);
        }
        buf.writeInt(this.children.size());
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            int child = (Integer)iterator.next();
            buf.writeInt(child);
        }
        buf.m_130070_(this.parents.getA());
        buf.m_130070_(this.parents.getB());
        buf.writeInt(this.availableQuests.size());
        for (ResourceLocation av : this.availableQuests) {
            buf.m_130085_(av);
        }
        buf.writeInt(this.participatingQuests.size());
        for (ResourceLocation av : this.participatingQuests) {
            buf.m_130085_(av);
        }
        if (this.textureUUID == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130077_(this.textureUUID);
        }
        buf.writeBoolean(this.citizenDiseaseHandler.isSick());
    }

    @Override
    public void increaseSaturation(double extraSaturation) {
        this.saturation = Math.min(20.0, this.saturation + Math.abs(extraSaturation));
    }

    @Override
    public void decreaseSaturation(double extraSaturation) {
        if (this.colony != null && this.colony.isActive()) {
            this.saturation = Math.max(0.0, this.saturation - Math.abs(extraSaturation * (Double)MineColonies.getConfig().getServer().foodModifier.get()));
            this.justAte = false;
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.markDirty(0);
    }

    @Override
    public void setLastPosition(BlockPos lastPosition) {
        this.lastPosition = lastPosition;
    }

    @Override
    public BlockPos getLastPosition() {
        return this.lastPosition;
    }

    @Override
    public double getSaturation() {
        return this.saturation;
    }

    @Override
    public void setSaturation(double saturation) {
        this.saturation = saturation;
    }

    @Override
    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isAsleep() {
        return this.isAsleep;
    }

    @Override
    public BlockPos getBedPos() {
        return this.bedPos;
    }

    @Override
    public void setAsleep(boolean asleep) {
        this.isAsleep = asleep;
        this.leisureTime = 0;
    }

    @Override
    public void setBedPos(BlockPos bedPos) {
        this.bedPos = bedPos;
    }

    @Override
    public CitizenHappinessHandler getCitizenHappinessHandler() {
        return this.citizenHappinessHandler;
    }

    @Override
    public CitizenMournHandler getCitizenMournHandler() {
        return this.citizenMournHandler;
    }

    @Override
    public ICitizenSkillHandler getCitizenSkillHandler() {
        return this.citizenSkillHandler;
    }

    @Override
    public ICitizenFoodHandler getCitizenFoodHandler() {
        return this.citizenFoodHandler;
    }

    @Override
    public ICitizenDiseaseHandler getCitizenDiseaseHandler() {
        return this.citizenDiseaseHandler;
    }

    @Override
    public void scheduleRestart(ServerPlayer player) {
        this.originPlayerRestart = player;
        this.restartScheduled = true;
    }

    @Override
    public boolean shouldRestart() {
        return this.restartScheduled;
    }

    @Override
    public void restartDone() {
        this.restartScheduled = false;
        MessageUtils.format("com.minecolonies.coremod.gui.hiring.restartmessagedone", this.getName()).sendTo(new Player[]{this.originPlayerRestart});
    }

    @Override
    public void setIsChild(boolean isChild) {
        this.isChild = isChild;
        this.markDirty(0);
        if (this.colony != null) {
            this.colony.updateHasChilds();
        }
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public boolean justAte() {
        return this.justAte;
    }

    @Override
    public void setJustAte(boolean justAte) {
        this.justAte = justAte;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbtTagCompound = new CompoundTag();
        nbtTagCompound.m_128405_("id", this.id);
        nbtTagCompound.m_128359_("name", this.name);
        nbtTagCompound.m_128359_("suffix", this.textureSuffix);
        nbtTagCompound.m_128405_("soundProfile", this.voiceProfile);
        nbtTagCompound.m_128379_("female", this.female);
        nbtTagCompound.m_128379_("paused", this.paused);
        nbtTagCompound.m_128379_("child", this.isChild);
        nbtTagCompound.m_128405_("texture", this.textureId);
        nbtTagCompound.m_128365_("newSkills", (Tag)this.citizenSkillHandler.write());
        BlockPosUtil.write(nbtTagCompound, "pos", this.getEntity().isPresent() ? this.getEntity().get().m_20183_() : this.lastPosition);
        if (this.nextRespawnPos != null) {
            BlockPosUtil.write(nbtTagCompound, "nextrespawnpos", this.nextRespawnPos);
        }
        nbtTagCompound.m_128347_("saturation", this.saturation);
        if (this.job != null) {
            @NotNull Tag jobCompound = this.job.serializeNBT();
            nbtTagCompound.m_128365_("job", jobCompound);
        }
        this.citizenHappinessHandler.write(nbtTagCompound, true);
        this.citizenMournHandler.write(nbtTagCompound);
        this.citizenFoodHandler.write(nbtTagCompound);
        this.citizenDiseaseHandler.write(nbtTagCompound);
        this.inventory.write(nbtTagCompound);
        nbtTagCompound.m_128405_("HeldItemSlot", this.inventory.getHeldItemSlot(InteractionHand.MAIN_HAND));
        nbtTagCompound.m_128405_("OffhandHeldItemSlot", this.inventory.getHeldItemSlot(InteractionHand.OFF_HAND));
        BlockPosUtil.write(nbtTagCompound, "beds", this.bedPos);
        nbtTagCompound.m_128379_("asleep", this.isAsleep);
        nbtTagCompound.m_128379_("justAte", this.justAte);
        @NotNull ListTag chatTagList = new ListTag();
        for (IInteractionResponseHandler iInteractionResponseHandler : this.citizenChatOptions.values()) {
            @NotNull CompoundTag chatOptionCompound = new CompoundTag();
            chatOptionCompound.m_128365_("chatoption", iInteractionResponseHandler.serializeNBT());
            chatTagList.add((Object)chatOptionCompound);
        }
        nbtTagCompound.m_128365_("chatoptions", (Tag)chatTagList);
        nbtTagCompound.m_128405_("jobStatus", this.jobStatus.ordinal());
        nbtTagCompound.m_128359_("parentA", this.parents.getA());
        nbtTagCompound.m_128359_("parentB", this.parents.getB());
        @NotNull ListTag siblingsNBT = new ListTag();
        for (int sibling : this.siblings) {
            siblingsNBT.add((Object)IntTag.m_128679_((int)sibling));
        }
        nbtTagCompound.m_128365_("siblings", (Tag)siblingsNBT);
        @NotNull ListTag listTag = new ListTag();
        for (int child : this.children) {
            listTag.add((Object)IntTag.m_128679_((int)child));
        }
        nbtTagCompound.m_128365_("children", (Tag)listTag);
        nbtTagCompound.m_128405_("partner", this.partner.intValue());
        nbtTagCompound.m_128379_("activeNodeNode", this.isWorking);
        nbtTagCompound.m_128405_("leisureSites", this.leisureTime);
        @NotNull ListTag avQuestNBT = new ListTag();
        for (ResourceLocation resourceLocation : this.availableQuests) {
            avQuestNBT.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbtTagCompound.m_128365_("avquests", (Tag)avQuestNBT);
        @NotNull ListTag partQuestNBT = new ListTag();
        for (ResourceLocation resourceLocation : this.participatingQuests) {
            partQuestNBT.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
        }
        nbtTagCompound.m_128365_("partquests", (Tag)partQuestNBT);
        @NotNull ListTag listTag2 = new ListTag();
        for (ResourceLocation quest : this.finishedQuests) {
            listTag2.add((Object)StringTag.m_129297_((String)quest.toString()));
        }
        nbtTagCompound.m_128365_("finavquests", (Tag)listTag2);
        @NotNull ListTag listTag3 = new ListTag();
        for (ResourceLocation quest : this.finishedQuestParticipation) {
            listTag3.add((Object)StringTag.m_129297_((String)quest.toString()));
        }
        nbtTagCompound.m_128365_("finpartquests", (Tag)listTag3);
        if (this.textureUUID != null) {
            nbtTagCompound.m_128362_("textureUUID", this.textureUUID);
        }
        return nbtTagCompound;
    }

    public void deserializeNBT(CompoundTag nbtTagCompound) {
        this.name = nbtTagCompound.m_128461_("name");
        this.female = nbtTagCompound.m_128471_("female");
        this.paused = nbtTagCompound.m_128471_("paused");
        this.isChild = nbtTagCompound.m_128471_("child");
        this.textureId = nbtTagCompound.m_128451_("texture");
        this.textureSuffix = nbtTagCompound.m_128441_("suffix") ? nbtTagCompound.m_128461_("suffix") : SUFFIXES.get(this.random.nextInt(SUFFIXES.size()));
        this.voiceProfile = nbtTagCompound.m_128441_("soundProfile") ? nbtTagCompound.m_128451_("soundProfile") : this.random.nextInt(4);
        this.lastPosition = BlockPosUtil.read(nbtTagCompound, "pos");
        if (nbtTagCompound.m_128441_("nextrespawnpos")) {
            this.nextRespawnPos = BlockPosUtil.read(nbtTagCompound, "nextrespawnpos");
        }
        this.citizenSkillHandler.read(nbtTagCompound.m_128469_("newSkills"));
        this.saturation = nbtTagCompound.m_128459_("saturation");
        if (nbtTagCompound.m_128441_("job")) {
            this.setJob(IJobDataManager.getInstance().createFrom(this, nbtTagCompound.m_128469_("job")));
        }
        if (nbtTagCompound.m_128441_("inventory")) {
            this.inventory.read(nbtTagCompound);
            this.inventory.setHeldItem(InteractionHand.MAIN_HAND, nbtTagCompound.m_128451_("HeldItemSlot"));
            this.inventory.setHeldItem(InteractionHand.OFF_HAND, nbtTagCompound.m_128451_("OffhandHeldItemSlot"));
        }
        if (this.name.isEmpty()) {
            this.name = CitizenData.generateName(this.random, this.isFemale(), this.getColony(), this.getColony().getCitizenNameFile());
        }
        if (nbtTagCompound.m_128441_("asleep")) {
            this.bedPos = BlockPosUtil.read(nbtTagCompound, "beds");
            this.isAsleep = nbtTagCompound.m_128471_("asleep");
        }
        if (nbtTagCompound.m_128441_("justAte")) {
            this.justAte = nbtTagCompound.m_128471_("justAte");
        }
        if (nbtTagCompound.m_128441_("chatoptions")) {
            ListTag handlerTagList = nbtTagCompound.m_128437_("chatoptions", 10);
            for (int i = 0; i < handlerTagList.size(); ++i) {
                try {
                    ServerCitizenInteraction handler = (ServerCitizenInteraction)MinecoloniesAPIProxy.getInstance().getInteractionResponseHandlerDataManager().createFrom(this, handlerTagList.m_128728_(i).m_128469_("chatoption"));
                    this.citizenChatOptions.put(handler.getId(), handler);
                    continue;
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Failed to load Interaction for a quest. Did the quest vanish?", (Throwable)ex);
                }
            }
        }
        this.citizenHappinessHandler.read(nbtTagCompound, true);
        this.citizenMournHandler.read(nbtTagCompound);
        this.citizenFoodHandler.read(nbtTagCompound);
        this.citizenDiseaseHandler.read(nbtTagCompound);
        if (nbtTagCompound.m_128441_("levelMap") && !nbtTagCompound.m_128441_("newSkills")) {
            this.citizenSkillHandler.init((int)this.citizenHappinessHandler.getHappiness(this.getColony(), this));
            HashMap<String, Integer> levels = new HashMap<String, Integer>();
            ListTag levelTagList = nbtTagCompound.m_128437_("levelMap", 10);
            for (int i = 0; i < levelTagList.size(); ++i) {
                CompoundTag levelExperienceAtJob = levelTagList.m_128728_(i);
                String jobName = levelExperienceAtJob.m_128461_("name");
                int level = Math.min(levelExperienceAtJob.m_128451_("level"), 99);
                levels.put(jobName, level);
            }
            for (Map.Entry entry : levels.entrySet()) {
                Skill primary = Skill.values()[this.random.nextInt(Skill.values().length)];
                Skill secondary = Skill.values()[this.random.nextInt(Skill.values().length)];
                this.citizenSkillHandler.incrementLevel(primary, (Integer)entry.getValue() / 2);
                this.citizenSkillHandler.incrementLevel(secondary, (Integer)entry.getValue() / 4);
            }
        }
        if (nbtTagCompound.m_128441_("jobStatus")) {
            this.jobStatus = JobStatus.values()[nbtTagCompound.m_128451_("jobStatus")];
        } else if (nbtTagCompound.m_128471_("idle")) {
            this.jobStatus = JobStatus.STUCK;
        }
        String parentA = nbtTagCompound.m_128461_("parentA");
        String parentB = nbtTagCompound.m_128461_("parentB");
        this.parents = new Tuple<String, String>(parentA, parentB);
        @NotNull ListTag siblingsNBT = nbtTagCompound.m_128437_("siblings", 3);
        for (int i = 0; i < siblingsNBT.size(); ++i) {
            this.siblings.add(siblingsNBT.m_128763_(i));
        }
        @NotNull ListTag childrenNBT = nbtTagCompound.m_128437_("children", 3);
        for (int i = 0; i < childrenNBT.size(); ++i) {
            this.children.add(childrenNBT.m_128763_(i));
        }
        this.partner = nbtTagCompound.m_128451_("partner");
        this.isWorking = nbtTagCompound.m_128471_("activeNodeNode");
        this.leisureTime = nbtTagCompound.m_128451_("leisureSites");
        @NotNull ListTag availQuestNbt = nbtTagCompound.m_128437_("avquests", 8);
        for (int i = 0; i < availQuestNbt.size(); ++i) {
            this.availableQuests.add(new ResourceLocation(availQuestNbt.m_128778_(i)));
        }
        @NotNull ListTag partQuestsNbt = nbtTagCompound.m_128437_("partquests", 8);
        for (int i = 0; i < partQuestsNbt.size(); ++i) {
            this.participatingQuests.add(new ResourceLocation(partQuestsNbt.m_128778_(i)));
        }
        @NotNull ListTag finQuestNbt = nbtTagCompound.m_128437_("finavquests", 8);
        for (int i = 0; i < finQuestNbt.size(); ++i) {
            this.finishedQuests.add(new ResourceLocation(finQuestNbt.m_128778_(i)));
        }
        @NotNull ListTag finPartQuestsNbt = nbtTagCompound.m_128437_("finpartquests", 8);
        for (int i = 0; i < finPartQuestsNbt.size(); ++i) {
            this.finishedQuestParticipation.add(new ResourceLocation(finPartQuestsNbt.m_128778_(i)));
        }
        if (nbtTagCompound.m_128441_("textureUUID")) {
            this.textureUUID = nbtTagCompound.m_128342_("textureUUID");
        }
    }

    @Override
    public void onBuildingLoad() {
        if (this.job == null) {
            return;
        }
        if (this.job.getBuildingPos() == null) {
            this.setJob(null);
            return;
        }
        if (this.job.getBuildingPos() != null && this.job.getWorkBuilding() == null) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(this.job.getBuildingPos());
            if (building != null) {
                IAssignsJob module;
                Iterator iterator = building.getModulesByType(IAssignsJob.class).iterator();
                while (!(!iterator.hasNext() || (module = (IAssignsJob)iterator.next()).getJobEntry().equals(this.job.getJobRegistryEntry()) && module.assignCitizen(this))) {
                }
            }
            if (building == null || this.job.getWorkBuilding() == null) {
                this.setJob(null);
            }
        }
    }

    @Override
    public void setInteractedRecently(UUID player) {
        this.interactedRecentlyPlayers.add(player);
        this.interactedRecently = 400;
    }

    @Override
    public void update(int tickRate) {
        int homeBuildingLevel;
        if (!this.getEntity().isPresent() || !this.getEntity().get().m_6084_()) {
            return;
        }
        int n = homeBuildingLevel = this.homeBuilding == null ? 1 : this.homeBuilding.getBuildingLevel();
        if (this.leisureTime > 0) {
            this.leisureTime -= tickRate;
        } else if (MathUtils.RANDOM.nextInt(1200 * (int)(60.0 / ((double)homeBuildingLevel / 2.0)) / tickRate) <= 0) {
            this.leisureTime = 3600;
        }
        if (this.interactedRecently > 0) {
            this.interactedRecently -= tickRate;
            if (this.interactedRecently <= 0) {
                this.interactedRecentlyPlayers.clear();
            }
        }
        if (!this.isWorking && this.job != null && this.inactivityTimer != -1 && ++this.inactivityTimer >= this.job.getInactivityLimit()) {
            this.job.triggerActivityChangeAction(this.isWorking);
            this.inactivityTimer = -1;
        }
        ArrayList<IInteractionResponseHandler> toRemove = new ArrayList<IInteractionResponseHandler>();
        for (IInteractionResponseHandler handler : this.citizenChatOptions.values()) {
            try {
                if (handler.isValid(this)) continue;
                toRemove.add(handler);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error during validation of handler: " + String.valueOf(handler.getInquiry()), (Throwable)e);
                toRemove.add(handler);
            }
        }
        if (!toRemove.isEmpty()) {
            this.markDirty(200);
        }
        for (IInteractionResponseHandler handler : toRemove) {
            this.citizenChatOptions.remove(handler.getId());
            for (Component comp : handler.getPossibleResponses()) {
                if (!this.citizenChatOptions.containsKey(handler.getResponseResult(comp))) continue;
                this.citizenChatOptions.get(handler.getResponseResult(comp)).removeParent(handler.getId());
            }
        }
        this.citizenDiseaseHandler.update(tickRate);
    }

    @Override
    public void triggerInteraction(@NotNull IInteractionResponseHandler handler) {
        if (handler.isValid(this) && !this.citizenChatOptions.containsKey(handler.getId())) {
            this.citizenChatOptions.put(handler.getId(), handler);
            for (IInteractionResponseHandler childHandler : handler.genChildInteractions()) {
                this.citizenChatOptions.put(childHandler.getId(), childHandler);
            }
            this.markDirty(100);
        }
    }

    @Override
    public boolean isIdleAtJob() {
        return this.jobStatus == JobStatus.STUCK;
    }

    @Override
    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    @Override
    public void setJobStatus(JobStatus status) {
        this.jobStatus = status;
    }

    @Override
    public String getTextureSuffix() {
        return this.textureSuffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.textureSuffix = suffix;
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, false);
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequestAsync(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, true);
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
        if (this.isRequestAsync(token)) {
            this.job.getAsyncRequests().remove(token);
        }
    }

    @Override
    public boolean isRequestAsync(@NotNull IToken<?> token) {
        if (this.job != null) {
            return this.job.getAsyncRequests().contains(token);
        }
        return false;
    }

    @Override
    public VisibleCitizenStatus getStatus() {
        return this.status;
    }

    @Override
    public void setVisibleStatus(VisibleCitizenStatus status) {
        if (this.status != status) {
            this.markDirty(20);
        }
        this.status = status;
    }

    @Override
    @Nullable
    public BlockPos getStatusPosition() {
        return this.statusPosition;
    }

    @Override
    public void setStatusPosition(@Nullable BlockPos pos) {
        if (!Objects.equals(this.statusPosition, pos)) {
            this.statusPosition = pos;
            this.markDirty(100);
        }
    }

    public static CitizenData loadFromNBT(IColony colony, CompoundTag nbt) {
        CitizenData data = new CitizenData(nbt.m_128451_("id"), colony);
        data.deserializeNBT(nbt);
        return data;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void applyResearchEffects() {
        if (this.getEntity().isPresent()) {
            AbstractEntityCitizen citizen = this.getEntity().get();
            citizen.getNavigation().getPathingOptions().setCanUseRails(((EntityCitizen)citizen).canPathOnRails());
            citizen.getNavigation().getPathingOptions().setCanClimbAdvanced(((EntityCitizen)citizen).canClimbVines());
            AttributeModifier speedModifier = new AttributeModifier("ResearchSpeedBonus", this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WALKING), AttributeModifier.Operation.MULTIPLY_TOTAL);
            AttributeModifierUtils.addModifier((LivingEntity)citizen, speedModifier, Attributes.f_22279_);
            AttributeModifier healthModLevel = new AttributeModifier(ResearchConstants.HEALTH_BOOST.toString(), this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.HEALTH_BOOST), AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, healthModLevel);
            if (this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MORE_AIR) > 0.0) {
                ((EntityCitizen)citizen).setMaxAir(600);
            }
        }
    }

    @Override
    public void onGoSleep() {
        if (this.random.nextInt(10) != 0) {
            return;
        }
        if (this.job != null && this.job.getWorkBuilding() != null && !this.job.getWorkBuilding().isGuardBuildingNear() && !WorldUtil.isPeaceful(this.colony.getWorld())) {
            this.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.noguardnearwork"), (Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.noguardnearwork"), ChatPriority.CHITCHAT));
        }
        if (this.homeBuilding != null && !this.homeBuilding.isGuardBuildingNear() && !WorldUtil.isPeaceful(this.colony.getWorld())) {
            this.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.noguardnearhome"), (Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.noguardnearhome"), ChatPriority.CHITCHAT));
        }
    }

    @Override
    public void setNextRespawnPosition(BlockPos pos) {
        this.nextRespawnPos = pos;
    }

    @Override
    public boolean needsBetterFood() {
        if (this.getHomeBuilding() == null) {
            return false;
        }
        int slotBadFood = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.inventory, stack -> FoodUtils.canEat(stack, this.getHomeBuilding(), this.getWorkBuilding()));
        int slotGoodFood = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.inventory, stack -> FoodUtils.canEat(stack, this.getHomeBuilding(), this.getWorkBuilding()));
        return slotBadFood != -1 && slotGoodFood == -1;
    }

    @Override
    public boolean isWorking() {
        return this.isWorking;
    }

    @Override
    public void onResurrect() {
        this.homeBuilding = null;
        this.setJob(null);
    }

    @Override
    public void setWorking(boolean isWorking) {
        if (isWorking && !this.isWorking) {
            if (this.job != null) {
                this.isWorking = isWorking;
                this.job.triggerActivityChangeAction(isWorking);
            }
            this.inactivityTimer = -1;
        } else if (!isWorking && this.isWorking) {
            this.inactivityTimer = 0;
            this.isWorking = isWorking;
        }
    }

    @Override
    @Nullable
    public ICitizenData getPartner() {
        return this.colony.getCitizenManager().getCivilian(this.partner);
    }

    @Override
    public List<Integer> getChildren() {
        return new ArrayList<Integer>(this.children);
    }

    @Override
    public List<Integer> getSiblings() {
        return new ArrayList<Integer>(this.siblings);
    }

    @Override
    public Tuple<String, String> getParents() {
        return this.parents;
    }

    @Override
    public void addSiblings(Integer ... siblings) {
        Collections.addAll(this.siblings, siblings);
    }

    @Override
    public void addChildren(Integer ... children) {
        Collections.addAll(this.children, children);
    }

    @Override
    public void setPartner(int id) {
        this.partner = id;
    }

    @Override
    public void onDeath(Integer id) {
        this.children.remove(id);
        this.siblings.remove(id);
        if (this.partner.equals(id)) {
            this.partner = 0;
        }
    }

    @Override
    public void setParents(String firstParent, String secondParent) {
        this.parents = new Tuple<String, String>(firstParent, secondParent);
    }

    @Override
    public void setIdleDays(int days) {
    }

    @Override
    public void assignQuest(IQuestInstance quest) {
        this.availableQuests.add(quest.getId());
    }

    @Override
    public void openDialogue(IQuestInstance quest, int index) {
        MutableComponent comp = Component.m_237113_((String)quest.getId().toString());
        if (IQuestManager.GLOBAL_SERVER_QUESTS.get(quest.getId()).getObjective(index) instanceof IQuestDeliveryObjective) {
            this.citizenChatOptions.put((Component)comp, new QuestDeliveryInteraction((Component)comp, ChatPriority.CHITCHAT, quest.getId(), index, this));
        } else {
            this.citizenChatOptions.put((Component)comp, new QuestDialogueInteraction((Component)comp, ChatPriority.CHITCHAT, quest.getId(), index, this));
        }
        this.markDirty(0);
    }

    @Override
    public void addQuestParticipation(IQuestInstance quest) {
        this.participatingQuests.add(quest.getId());
    }

    @Override
    public void onQuestDeletion(ResourceLocation questId) {
        this.availableQuests.remove(questId);
        this.participatingQuests.remove(questId);
    }

    @Override
    public boolean isParticipantOfQuest(ResourceLocation questId) {
        return this.availableQuests.contains(questId) || this.participatingQuests.contains(questId);
    }

    @Override
    public void onQuestCompletion(ResourceLocation questId) {
        if (this.availableQuests.contains(questId)) {
            this.availableQuests.remove(questId);
            this.finishedQuests.add(questId);
        } else if (this.participatingQuests.contains(questId)) {
            this.participatingQuests.remove(questId);
            this.finishedQuestParticipation.add(questId);
        }
    }

    @Override
    public boolean hasQuestAssignment() {
        return !this.availableQuests.isEmpty() || !this.participatingQuests.isEmpty();
    }

    @Override
    public void onInteractionClosed(Component key, ServerPlayer sender) {
        IInteractionResponseHandler chatOption = this.citizenChatOptions.get(key);
        if (chatOption != null) {
            chatOption.onClosed();
        }
    }

    @Override
    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.nameUUIDFromBytes((this.getId() + ":" + this.getColony().getID() + ":" + String.valueOf(this.getColony().getDimension().m_135782_())).getBytes());
        }
        return this.uuid;
    }

    @Override
    public void setCustomTexture(UUID texture) {
        this.textureUUID = texture;
    }

    @Override
    public boolean hasCustomTexture() {
        return this.textureUUID != null;
    }

    @Override
    public UUID getCustomTexture() {
        return this.textureUUID;
    }

    @Override
    @Nullable
    public BlockPos getHomePosition() {
        @Nullable IBuilding homeBuilding = this.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getPosition();
        }
        if (this.colony != null) {
            IBuilding tavern = this.colony.getBuildingManager().getFirstBuildingMatching(b -> b.getBuildingType() == ModBuildings.tavern.get());
            if (tavern != null && tavern.getBuildingLevel() > 0) {
                return tavern.getPosition();
            }
            if (this.colony.getBuildingManager().getTownHall() != null) {
                return this.colony.getBuildingManager().getTownHall().getPosition();
            }
            return this.colony.getCenter();
        }
        return null;
    }

    @Override
    public double getDiseaseModifier() {
        return this.citizenFoodHandler.getDiseaseModifier(this.getJob() == null ? 1.0 : this.getJob().getDiseaseModifier());
    }

    @Override
    public int getLeisureTime() {
        return this.leisureTime;
    }
}

