/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.costs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.research.IResearchCost;
import com.minecolonies.api.research.ModResearchCosts;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.util.GsonHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ListItemCost
implements IResearchCost {
    private static final String JSON_PROP_ITEMS = "items";
    private static final String JSON_PROP_QUANTITY = "quantity";
    private final List<Item> items;
    private final int count;

    public ListItemCost(CompoundTag compound) {
        this.items = NBTUtils.streamCompound(compound.m_128437_("cost-items", 10)).map(itemCompound -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemCompound.m_128461_("cost-item")))).toList();
        this.count = compound.m_128451_("cost-count");
    }

    public ListItemCost(JsonObject json) {
        this.items = new ArrayList<Item>();
        for (JsonElement arrayItem : GsonHelper.m_13933_((JsonObject)json, (String)JSON_PROP_ITEMS)) {
            this.items.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arrayItem.getAsJsonPrimitive().getAsString())));
        }
        this.count = Math.max(GsonHelper.m_13824_((JsonObject)json, (String)JSON_PROP_QUANTITY, (int)1), 1);
    }

    @Override
    public ModResearchCosts.ResearchCostEntry getType() {
        return (ModResearchCosts.ResearchCostEntry)ModResearchCosts.listItemCost.get();
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public List<Item> getItems() {
        return this.items;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag itemList = this.items.stream().map(item -> {
            CompoundTag itemCompound = new CompoundTag();
            itemCompound.m_128359_("cost-item", ForgeRegistries.ITEMS.getKey(item).toString());
            return itemCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("cost-items", (Tag)itemList);
        compound.m_128405_("cost-count", this.count);
        return compound;
    }
}

