/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class DynamicHappinessSupplier
implements IHappinessSupplierWrapper {
    private ResourceLocation key;
    private double lastValue = 0.0;

    public DynamicHappinessSupplier(ResourceLocation key) {
        this.key = key;
    }

    public DynamicHappinessSupplier() {
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("id", this.key.toString());
        compoundTag.m_128347_("Value", this.lastValue);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.key = new ResourceLocation(nbt.m_128461_("id"));
        this.lastValue = nbt.m_128459_("Value");
    }

    @Override
    public double getValue(ICitizenData citizenData) {
        HappinessRegistry.HappinessFunctionEntry function = (HappinessRegistry.HappinessFunctionEntry)IMinecoloniesAPI.getInstance().getHappinessFunctionRegistry().getValue(this.key);
        if (function == null) {
            return this.lastValue;
        }
        this.lastValue = function.getDoubleSupplier().apply(citizenData);
        return this.lastValue;
    }

    @Override
    public double getLastCachedValue() {
        return this.lastValue;
    }
}

