/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.DynamicHappinessSupplier;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHappinessModifier
implements IHappinessModifier {
    private IHappinessSupplierWrapper supplier;
    public String id;
    private double weight;

    public AbstractHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier) {
        this.id = id;
        this.weight = weight;
        this.supplier = supplier;
    }

    @Override
    public double getFactor(@Nullable ICitizenData citizenData) {
        return citizenData == null ? this.supplier.getLastCachedValue() : this.supplier.getValue(citizenData);
    }

    public AbstractHappinessModifier() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void read(CompoundTag compoundNBT, boolean persist) {
        this.id = compoundNBT.m_128461_("id");
        this.weight = compoundNBT.m_128459_("weight");
        CompoundTag supplierCompound = compoundNBT.m_128469_("supplier");
        this.supplier = supplierCompound.m_128441_("id") ? new DynamicHappinessSupplier() : new StaticHappinessSupplier();
        this.supplier.deserializeNBT((Tag)supplierCompound);
    }

    @Override
    public void write(CompoundTag compoundNBT, boolean persist) {
        compoundNBT.m_128359_("id", this.id);
        compoundNBT.m_128347_("weight", this.weight);
        compoundNBT.m_128365_("supplier", this.supplier.serializeNBT());
    }

    @Override
    public double getWeight() {
        return this.weight;
    }
}

