/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.manager;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.data.IDataStoreManager;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.tileentities.ITickable;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRequestManager
extends INBTSerializable<CompoundTag>,
ITickable {
    @NotNull
    public IColony getColony();

    @NotNull
    public IFactoryController getFactoryController();

    @NotNull
    public <T extends IRequestable> IToken<?> createRequest(@NotNull IRequester var1, @NotNull T var2) throws IllegalArgumentException;

    @NotNull
    public void assignRequest(@NotNull IToken<?> var1) throws IllegalArgumentException;

    @NotNull
    default public <T extends IRequestable> IToken<?> createAndAssignRequest(@NotNull IRequester requester, @NotNull T object) throws IllegalArgumentException {
        IToken<?> token = this.createRequest(requester, object);
        this.assignRequest(token);
        return token;
    }

    @Nullable
    public IToken<?> reassignRequest(@NotNull IToken<?> var1, @NotNull Collection<IToken<?>> var2) throws IllegalArgumentException;

    @Nullable
    public IRequest<?> getRequestForToken(@NotNull IToken<?> var1) throws IllegalArgumentException;

    @NotNull
    public IRequestResolver<?> getResolverForToken(@NotNull IToken<?> var1) throws IllegalArgumentException;

    @Nullable
    public IRequestResolver<?> getResolverForRequest(@NotNull IToken<?> var1) throws IllegalArgumentException;

    @NotNull
    public void updateRequestState(@NotNull IToken<?> var1, @NotNull RequestState var2) throws IllegalArgumentException;

    public void overruleRequest(@NotNull IToken<?> var1, @Nullable ItemStack var2) throws IllegalArgumentException;

    public void onProviderAddedToColony(@NotNull IRequestResolverProvider var1) throws IllegalArgumentException;

    public void onRequesterRemovedFromColony(@NotNull IRequester var1) throws IllegalArgumentException;

    public void onProviderRemovedFromColony(@NotNull IRequestResolverProvider var1) throws IllegalArgumentException;

    public void onColonyUpdate(@NotNull Predicate<IRequest<?>> var1);

    @NotNull
    public IPlayerRequestResolver getPlayerResolver();

    @NotNull
    public IRetryingRequestResolver getRetryingRequestResolver();

    @NotNull
    public IDataStoreManager getDataStoreManager();

    public void reset();

    public boolean isDirty();

    public void setDirty(boolean var1);

    public void markDirty();

    public void log(String var1);

    public void serialize(IFactoryController var1, FriendlyByteBuf var2);

    public void deserialize(IFactoryController var1, FriendlyByteBuf var2);
}

