/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IInvisibleBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.INamedBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IRequirementsBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractColonyBlock;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.ItemBlockHut;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockHut<B extends AbstractBlockHut<B>>
extends AbstractColonyBlock<B>
implements IAnchorBlock,
INamedBlueprintAnchorBlock,
ILeveledBlueprintAnchorBlock,
IRequirementsBlueprintAnchorBlock,
IInvisibleBlueprintAnchorBlock,
ISpecialCreativeHandlerAnchorBlock,
IBuildingBrowsableBlock {
    public AbstractBlockHut() {
    }

    public AbstractBlockHut(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onBlockPlacedByBuildTool(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, boolean mirror, String style, String blueprintPath) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof AbstractTileEntityColonyBuilding) {
            ((AbstractTileEntityColonyBuilding)tileEntity).setMirror(mirror);
            ((AbstractTileEntityColonyBuilding)tileEntity).setPackName(style);
            ((AbstractTileEntityColonyBuilding)tileEntity).setBlueprintPath(blueprintPath);
        }
        this.m_6402_(worldIn, pos, state, placer, stack);
    }

    public boolean isVisible(@Nullable CompoundTag beData) {
        Map data = IBlueprintDataProviderBE.readTagPosMapFrom((CompoundTag)beData.m_128469_("blueprintDataProvider"));
        return !((List)data.getOrDefault(BlockPos.f_121853_, new ArrayList())).contains("invisible");
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<MutableComponent> getRequirements(ClientLevel level, BlockPos pos, LocalPlayer player) {
        ArrayList<MutableComponent> requirements = new ArrayList<MutableComponent>();
        IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)level, pos);
        if (colonyView == null) {
            requirements.add(Component.m_237115_((String)"com.minecolonies.coremod.hut.incolony").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return requirements;
        }
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), this) == -1) {
            requirements.add(Component.m_237110_((String)"com.minecolonies.coremod.hut.cost", (Object[])new Object[]{Component.m_237115_((String)("block.minecolonies." + this.getHutName()))}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return requirements;
        }
        ResourceLocation effectId = colonyView.getResearchManager().getResearchEffectIdFrom(this);
        if (colonyView.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return requirements;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            requirements.add(Component.m_237110_((String)"com.minecolonies.coremod.research.item1", (Object[])new Object[]{this.m_49954_()}));
            requirements.add(Component.m_237110_((String)"com.minecolonies.coremod.research.item2", (Object[])new Object[]{this.m_49954_()}));
        }
        return requirements;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean areRequirementsMet(ClientLevel level, BlockPos pos, LocalPlayer player) {
        if (player.m_7500_()) {
            return true;
        }
        return this.getRequirements(level, pos, player).isEmpty();
    }

    public List<MutableComponent> getDesc() {
        ArrayList<MutableComponent> desc = new ArrayList<MutableComponent>();
        desc.add(Component.m_237115_((String)this.getBuildingEntry().getTranslationKey()));
        desc.add(Component.m_237115_((String)(this.getBuildingEntry().getTranslationKey() + ".desc")));
        return desc;
    }

    public Component getBlueprintDisplayName() {
        return Component.m_237115_((String)this.getBuildingEntry().getTranslationKey());
    }

    public int getLevel(CompoundTag beData) {
        if (beData == null) {
            return 0;
        }
        try {
            return Integer.parseInt(beData.m_128469_("blueprintDataProvider").m_128461_("schematicName").replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException exception) {
            Log.getLogger().error("Couldn't get level from hut: " + this.getHutName() + ". Potential corrubt blockEntity data.");
            return 0;
        }
    }

    public AbstractStructureHandler getStructureHandler(Level level, BlockPos blockPos, Blueprint blueprint, PlacementSettings placementSettings, boolean b) {
        return new CreativeBuildingStructureHandler(level, blockPos, blueprint, placementSettings, b);
    }

    public boolean setup(ServerPlayer player, Level world, BlockPos pos, Blueprint blueprint, PlacementSettings settings, boolean fancyPlacement, String pack, String path) {
        BlockState anchor = blueprint.m_8055_(blueprint.getPrimaryBlockOffset());
        if (!(anchor.m_60734_() instanceof AbstractBlockHut) || !fancyPlacement && player.m_7500_()) {
            return true;
        }
        if (!((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().blueprintBuildMode.get()).booleanValue() && !this.canPaste(anchor.m_60734_(), (Player)player, pos)) {
            return false;
        }
        world.m_46961_(pos, true);
        world.m_46597_(pos, anchor);
        ((AbstractBlockHut)anchor.m_60734_()).onBlockPlacedByBuildTool(world, pos, anchor, (LivingEntity)player, null, settings.getMirror() != Mirror.NONE, pack, path);
        if (((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().blueprintBuildMode.get()).booleanValue()) {
            return true;
        }
        @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, pos);
        if (building == null) {
            if (anchor.m_60734_() != ModBlocks.blockHutTownHall) {
                SoundUtils.playErrorSound((Player)player, player.m_20183_());
                Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
                return false;
            }
        } else {
            SoundUtils.playSuccessSound((Player)player, player.m_20183_());
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.m_7755_().getString());
                    return false;
                }
                building.getTileEntity().setColony(colony);
            }
            String adjusted = path.replace(".blueprint", "");
            String num = adjusted.substring(path.replace(".blueprint", "").length() - 2, adjusted.length() - 1);
            building.setStructurePack(pack);
            building.setBlueprintPath(path);
            try {
                building.setBuildingLevel(Integer.parseInt(num));
            }
            catch (NumberFormatException ex) {
                building.setBuildingLevel(1);
            }
            building.setIsMirrored(settings.mirror != Mirror.NONE);
            building.onUpgradeComplete(building.getBuildingLevel());
        }
        return true;
    }

    private boolean canPaste(Block anchor, Player player, BlockPos pos) {
        IColony colony = IColonyManager.getInstance().getIColony(player.m_9236_(), pos);
        if (colony == null) {
            if (anchor == ModBlocks.blockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(player.m_9236_(), player) == null) {
                MessageUtils.format("tile.blockhut.messagenotownhall", new Object[0]).sendTo(player);
            } else {
                MessageUtils.format("tile.blockhut.messagetoofarfromtownhall", new Object[0]).sendTo(player);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            MessageUtils.format("tile.blockhut.messagenopermission", colony.getName()).sendTo(player);
            return false;
        }
        return colony.getBuildingManager().canPlaceAt(anchor, pos, player);
    }

    public String getBlueprintName() {
        return this.getBuildingEntry().getRegistryName().m_135815_();
    }

    @Override
    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register(this.getRegistryName(), (Object)new ItemBlockHut(this, properties));
    }
}

