/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DistributorModuleScreen
extends AbstractModuleScreen {
    private static final ItemStack ROUTER_STACK = new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get());
    private StrategyButton sb;
    private DirectionButton db;

    public DistributorModuleScreen(ModuleMenu container, Inventory inv, Component displayText) {
        super(container, inv, displayText);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        CompiledDistributorModule cdm = new CompiledDistributorModule(null, this.moduleItemStack);
        this.m_142416_((GuiEventListener)new TooltipButton(this.f_97735_ + 127, this.f_97736_ + 23));
        this.sb = new StrategyButton(this.f_97735_ + 147, this.f_97736_ + 23, 16, 16, cdm.getDistributionStrategy());
        this.m_142416_((GuiEventListener)this.sb);
        this.db = new DirectionButton(this.f_97735_ + 147, this.f_97736_ + 43, cdm.isPulling());
        this.m_142416_((GuiEventListener)this.db);
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 125, this.f_97736_ + 21, this.f_97735_ + 165, this.f_97736_ + 41, "modularrouters.guiText.popup.distributor.strategy");
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 125, this.f_97736_ + 41, this.f_97735_ + 165, this.f_97736_ + 61, "modularrouters.guiText.popup.distributor.direction");
    }

    @Override
    protected CompoundTag buildMessageData() {
        CompoundTag tag = super.buildMessageData();
        tag.m_128405_("DistStrategy", ((CompiledDistributorModule.DistributionStrategy)this.sb.getState()).ordinal());
        tag.m_128379_("Pulling", this.db.isToggled());
        return tag;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        graphics.m_280480_(ROUTER_STACK, this.f_97735_ + 127, this.f_97736_ + 43);
    }

    private static class TooltipButton
    extends ItemStackButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(176, 16);

        TooltipButton(int x, int y) {
            super(x, y, 16, 16, new ItemStack((ItemLike)ModItems.DISTRIBUTOR_MODULE.get()), true, p -> {});
            this.tooltip1.add(ClientUtil.xlate("modularrouters.guiText.tooltip.distributor.strategy", new Object[0]));
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void m_7435_(SoundManager soundHandlerIn) {
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }
    }

    private class StrategyButton
    extends TexturedCyclerButton<CompiledDistributorModule.DistributionStrategy> {
        private final List<List<Component>> tooltips;

        StrategyButton(int x, int y, int width, int height, CompiledDistributorModule.DistributionStrategy initialVal) {
            super(x, y, width, height, initialVal, DistributorModuleScreen.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledDistributorModule.DistributionStrategy strategy : CompiledDistributorModule.DistributionStrategy.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(strategy.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(160 + ((CompiledDistributorModule.DistributionStrategy)this.getState()).ordinal() * 16, 32);
        }

        @Override
        public List<Component> getTooltipLines() {
            return this.tooltips.get(((CompiledDistributorModule.DistributionStrategy)this.getState()).ordinal());
        }
    }

    private class DirectionButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(176, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(160, 16);

        public DirectionButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, DistributorModuleScreen.this);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.itemText.fluid.direction.OUT", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, ChatFormatting.WHITE, "modularrouters.itemText.fluid.direction.IN", new Object[0]);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }
}

