/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import umpaz.farmersrespite.common.FRConfiguration;
import umpaz.farmersrespite.common.block.CoffeeStemBlock;
import umpaz.farmersrespite.common.block.state.WitherRootsUtil;
import umpaz.farmersrespite.common.registry.FRBlocks;
import umpaz.farmersrespite.common.registry.FRItems;

public class CoffeeBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape SHAPE_LOWER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)18.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0));
    private static final VoxelShape SHAPE_UPPER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)-10.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)-16.0, (double)5.0, (double)11.0, (double)-10.0, (double)11.0));

    public CoffeeBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_UPPER;
        }
        return SHAPE_LOWER;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.NETHER;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50137_) || state.m_60713_(Blocks.f_50138_) || state.m_60713_(Blocks.f_152597_) || state.m_60713_(Blocks.f_50450_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FRItems.COFFEE_BEANS.get());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (!(facing.m_122434_() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != doubleblockhalf)) {
            return Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        for (BlockPos neighborPos : WitherRootsUtil.randomInSquare(random, pos, 2)) {
            BlockState neighborState = level.m_8055_(neighborPos);
            int witherRootRandom = random.m_188503_(5);
            BlockState witherRootsState = witherRootRandom < 2 ? ((Block)FRBlocks.WITHER_ROOTS.get()).m_49966_() : (witherRootRandom < 4 ? ((Block)FRBlocks.WITHER_ROOTS_PLANT.get()).m_49966_() : ((Block)FRBlocks.WILD_COFFEE_BUSH.get()).m_49966_());
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && level.m_46859_(pos.m_7494_().m_7494_()) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(2) == 0 ? 1 : 0) != 0)) {
                if (neighborState.m_60734_() instanceof CropBlock) {
                    level.m_46597_(neighborPos, witherRootsState);
                    this.m_214148_(level, random, pos, state);
                } else if (level.m_6042_().f_63857_()) {
                    this.m_214148_(level, random, pos, state);
                }
            }
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            CoffeeBushBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? this.m_6266_(level.m_8055_(blockpos), (BlockGetter)level, blockpos) : blockstate.m_60713_((Block)this);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)FRConfiguration.BONE_MEAL_COFFEE.get();
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public Direction getDirection(Random rand) {
        int i = rand.nextInt(4);
        if (i == 0) {
            return Direction.NORTH;
        }
        if (i == 1) {
            return Direction.SOUTH;
        }
        if (i == 2) {
            return Direction.EAST;
        }
        if (i == 3) {
            return Direction.WEST;
        }
        return null;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        Random randDirection = new Random();
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && level.m_46859_(pos.m_7494_().m_7494_())) {
            level.m_46597_(pos, (BlockState)((Block)FRBlocks.COFFEE_STEM.get()).m_49966_().m_61124_((Property)CoffeeStemBlock.FACING, (Comparable)this.getDirection(randDirection)));
            level.m_46597_(pos.m_7494_(), ((Block)FRBlocks.COFFEE_BUSH_TOP.get()).m_49966_());
            level.m_46597_(pos.m_7494_().m_7494_(), (BlockState)((Block)FRBlocks.COFFEE_BUSH_TOP.get()).m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER && level.m_46859_(pos.m_7494_())) {
            level.m_46597_(pos.m_7495_(), (BlockState)((Block)FRBlocks.COFFEE_STEM.get()).m_49966_().m_61124_((Property)CoffeeStemBlock.FACING, (Comparable)this.getDirection(randDirection)));
            level.m_46597_(pos, ((Block)FRBlocks.COFFEE_BUSH_TOP.get()).m_49966_());
            level.m_46597_(pos.m_7494_(), (BlockState)((Block)FRBlocks.COFFEE_BUSH_TOP.get()).m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }
}

