/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.item;

import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.util.EnvironmentHelper;
import com.mrcrayfish.mightymail.client.util.ScreenHelper;
import com.mrcrayfish.mightymail.core.ModItems;
import com.mrcrayfish.mightymail.core.ModSounds;
import com.mrcrayfish.mightymail.util.Utils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PackageItem
extends Item {
    public PackageItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        if (level == null) {
            return;
        }
        this.loadString(stack, "Sender", s -> lines.add((Component)Utils.translation("gui", "package_sent_by", s).m_130940_(ChatFormatting.AQUA)));
        this.loadString(stack, "Message", s -> EnvironmentHelper.runOn((Environment)Environment.CLIENT, () -> () -> ScreenHelper.splitText(s, 170).forEach(component -> lines.add((Component)component.m_130940_(ChatFormatting.GRAY)))));
        lines.add((Component)Utils.translation("gui", "package_open", new Object[0]).m_130940_(ChatFormatting.YELLOW));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            float pitch = 0.9f + 0.2f * level.f_46441_.m_188501_();
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_PACKAGE_OPEN.get(), SoundSource.PLAYERS, 1.0f, pitch);
            PackageItem.getPackagedItems(stack).forEach(s -> Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)s));
            player.m_21008_(hand, ItemStack.f_41583_);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public static List<ItemStack> getPackagedItems(ItemStack stack) {
        NonNullList items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
        CompoundTag tag = stack.m_41784_();
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
        return items;
    }

    private void loadString(ItemStack stack, String key, Consumer<String> consumer) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(key, 8)) {
            consumer.accept(tag.m_128461_(key));
        }
    }

    public static ItemStack create(Container container, @Nullable String message, @Nullable String sender) {
        return PackageItem.create(Utils.nonNullListFromContainer(container), message, sender);
    }

    public static ItemStack create(NonNullList<ItemStack> items, @Nullable String message, @Nullable String sender) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.PACKAGE.get());
        CompoundTag tag = stack.m_41784_();
        ContainerHelper.m_18973_((CompoundTag)tag, items);
        Optional.ofNullable(message).ifPresent(s -> tag.m_128359_("Message", s));
        Optional.ofNullable(sender).ifPresent(s -> tag.m_128359_("Sender", s));
        return stack;
    }
}

